/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.DbConfig;
import io.ebean.docker.commands.JdbcBaseDbContainer;
import io.ebean.docker.container.Container;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class BasePostgresContainer
extends JdbcBaseDbContainer
implements Container {
    BasePostgresContainer(DbConfig config) {
        super(config);
    }

    @Override
    void createDatabase() {
        this.createRoleAndDatabase(false);
    }

    @Override
    void dropCreateDatabase() {
        this.createRoleAndDatabase(true);
    }

    private void createRoleAndDatabase(boolean withDrop) {
        try (Connection connection = this.config.createAdminConnection();){
            if (withDrop) {
                this.dropDatabaseIfExists(connection, this.dbConfig.getDbName());
                this.dropRoleIfExists(connection, this.dbConfig.getUsername());
            }
            if (this.databaseNotExists(connection, this.dbConfig.getDbName())) {
                this.createExtraDb(connection, withDrop);
                this.createRole(connection);
                this.createDatabase(connection);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error when creating database and role", e);
        }
    }

    private void dropRoleIfExists(Connection connection, String username) {
        this.sqlRun(connection, "drop role if exists " + username);
    }

    private void dropDatabaseIfExists(Connection connection, String dbName) {
        this.sqlRun(connection, "drop database if exists " + dbName);
    }

    private void createExtraDb(Connection connection, boolean withDrop) {
        String extraUser = this.getExtraDbUser();
        if (this.defined(extraUser)) {
            String extraDb = this.dbConfig.getExtraDb();
            if (withDrop) {
                this.dropDatabaseIfExists(connection, extraDb);
                this.dropRoleIfExists(connection, extraUser);
            }
            this.createRole(connection, extraUser, this.getWithDefault(this.dbConfig.getExtraDbPassword(), this.dbConfig.getPassword()));
            if (this.databaseNotExists(connection, extraDb)) {
                this.createDatabase(connection, false, extraDb, extraUser, this.dbConfig.getExtraDbInitSqlFile(), this.dbConfig.getExtraDbSeedSqlFile());
            }
        }
    }

    private void createDatabase(Connection connection) {
        this.createDatabase(connection, true, this.dbConfig.getDbName(), this.dbConfig.getUsername(), this.dbConfig.getInitSqlFile(), this.dbConfig.getSeedSqlFile());
    }

    private void createRole(Connection connection) {
        this.createRole(connection, this.dbConfig.getUsername(), this.dbConfig.getPassword());
    }

    private void createRole(Connection connection, String username, String password) {
        if (!this.sqlHasRow(connection, "select rolname from pg_roles where rolname = '" + username + "'")) {
            this.sqlRun(connection, "create role " + username + " password '" + password + "' login createrole");
        }
    }

    private boolean databaseNotExists(Connection connection, String dbName) {
        return !this.sqlHasRow(connection, "select 1 from pg_database where datname = '" + dbName + "'");
    }

    private void createDatabase(Connection connection, boolean withExtensions, String dbName, String owner, String initSql, String seedSql) {
        this.sqlRun(connection, "create database " + dbName + " with owner " + owner);
        if (withExtensions) {
            this.addExtensions();
        }
        if (this.defined(initSql)) {
            this.runDbSqlFile(dbName, owner, initSql);
        }
        if (this.defined(seedSql)) {
            this.runDbSqlFile(dbName, owner, seedSql);
        }
    }

    private void addExtensions() {
        if (!this.defined(this.dbConfig.getExtensions())) {
            return;
        }
        List<String> extensions = this.parseExtensions(this.dbConfig.getExtensions());
        if (!extensions.isEmpty()) {
            try (Connection connection = this.dbConfig.createAdminConnection(this.dbConfig.jdbcUrl());){
                for (String extension : extensions) {
                    this.sqlRun(connection, "create extension if not exists \"" + extension + "\"");
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getExtraDbUser() {
        String extraUser = this.getWithDefault(this.dbConfig.getExtraDbUser(), this.dbConfig.getExtraDb());
        return extraUser != null && !extraUser.equals(this.dbConfig.getUsername()) ? extraUser : null;
    }

    @Override
    protected void executeSqlFile(String dbUser, String dbName, String containerFilePath) {
        ProcessBuilder pb = this.sqlFileProcess(dbUser, dbName, containerFilePath);
        this.executeWithout("ERROR", pb, "Error executing init sql file: " + containerFilePath);
    }

    private ProcessBuilder sqlFileProcess(String dbUser, String dbName, String containerFilePath) {
        List<String> args = this.execPsql();
        args.add(dbUser);
        args.add("-d");
        args.add(dbName);
        args.add("-f");
        args.add(containerFilePath);
        return this.createProcessBuilder(args);
    }

    private String getWithDefault(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    private List<String> parseExtensions(String dbExtn) {
        if (dbExtn == null) {
            return Collections.emptyList();
        }
        ArrayList<String> extensions = new ArrayList<String>();
        for (String extension : dbExtn.split(",")) {
            if ((extension = extension.trim()).isEmpty()) continue;
            extensions.add(extension);
        }
        return extensions;
    }

    private List<String> execPsql() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("exec");
        args.add("-i");
        args.add(this.config.containerName());
        args.add("psql");
        args.add("-U");
        return args;
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        if (this.dbConfig.isInMemory() && this.dbConfig.getTmpfs() != null) {
            args.add("--tmpfs");
            args.add(this.dbConfig.getTmpfs());
        }
        if (!this.dbConfig.adminPassword.isEmpty()) {
            args.add("-e");
            args.add("POSTGRES_PASSWORD=" + this.dbConfig.getAdminPassword());
        }
        args.add(this.config.getImage());
        return this.createProcessBuilder(args);
    }
}

