/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.StartMode;
import io.ebean.docker.commands.StopMode;
import io.ebean.docker.container.ContainerConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public abstract class BaseConfig
implements ContainerConfig {
    protected final String platform;
    protected String containerName;
    protected String host = "localhost";
    protected int port;
    protected int internalPort;
    protected int adminPort;
    protected int adminInternalPort;
    protected String image;
    protected StartMode startMode = StartMode.Create;
    protected StopMode stopMode = StopMode.Stop;
    protected StopMode shutdownMode = StopMode.None;
    protected String characterSet;
    protected String collation;
    protected int maxReadyAttempts = 300;
    protected String docker = "docker";
    protected final String version;

    BaseConfig(String platform, int port, int internalPort, String version) {
        this.platform = platform;
        this.port = port;
        this.internalPort = internalPort;
        this.containerName = "ut_" + platform;
        this.image = platform + ":" + version;
        this.version = version;
    }

    @Override
    public String startDescription() {
        return "starting " + this.platform + " container:" + this.containerName + " port:" + this.port + " startMode:" + (Object)((Object)this.startMode);
    }

    @Override
    public String stopDescription() {
        return "stopping " + this.platform + " container:" + this.containerName + " stopMode:" + (Object)((Object)this.stopMode);
    }

    @Override
    public String platform() {
        return this.platform;
    }

    @Override
    public String containerName() {
        return this.containerName;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public void setStartMode(StartMode startMode) {
        this.startMode = startMode;
    }

    @Override
    public void setStopMode(StopMode stopMode) {
        this.stopMode = stopMode;
    }

    @Override
    public void setShutdownMode(StopMode shutdownMode) {
        this.shutdownMode = shutdownMode;
    }

    @Override
    public Connection createConnection() throws SQLException {
        throw new IllegalStateException("Not valid for this type");
    }

    @Override
    public Connection createConnectionNoSchema() throws SQLException {
        throw new IllegalStateException("Not valid for this type");
    }

    @Override
    public Connection createAdminConnection() throws SQLException {
        throw new IllegalStateException("Not valid for this type");
    }

    @Override
    public String jdbcUrl() {
        throw new IllegalStateException("Not valid for this type");
    }

    @Override
    public String jdbcAdminUrl() {
        return this.jdbcUrl();
    }

    public BaseConfig setProperties(Properties properties) {
        if (properties == null) {
            return this;
        }
        this.docker = properties.getProperty("docker", this.docker);
        this.containerName = this.prop(properties, "containerName", this.containerName);
        this.image = this.prop(properties, "image", this.image);
        this.host = this.prop(properties, "host", this.host);
        this.port = this.prop(properties, "port", this.port);
        this.internalPort = this.prop(properties, "internalPort", this.internalPort);
        this.adminPort = this.prop(properties, "adminPort", this.adminPort);
        this.adminInternalPort = this.prop(properties, "adminInternalPort", this.adminInternalPort);
        this.characterSet = this.prop(properties, "characterSet", this.characterSet);
        this.collation = this.prop(properties, "collation", this.collation);
        String start = properties.getProperty("startMode", this.startMode.name());
        this.startMode = StartMode.of(this.prop(properties, "startMode", start));
        String stop = properties.getProperty("stopMode", this.stopMode.name());
        this.stopMode = StopMode.of(this.prop(properties, "stopMode", stop));
        String shutdown = properties.getProperty("shutdown", this.shutdownMode.name());
        this.shutdownMode = StopMode.of(this.prop(properties, "shutdown", shutdown));
        String maxVal = this.prop(properties, "maxReadyAttempts", null);
        if (maxVal != null) {
            try {
                this.maxReadyAttempts = Integer.parseInt(maxVal);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this;
    }

    protected String prop(Properties properties, String key, String defaultValue) {
        String val = properties.getProperty("ebean.test." + this.platform + "." + key, defaultValue);
        return properties.getProperty(this.platform + "." + key, val);
    }

    protected int prop(Properties properties, String key, int defaultValue) {
        String val = properties.getProperty("ebean.test." + this.platform + "." + key);
        val = properties.getProperty(this.platform + "." + key, val);
        return val == null ? defaultValue : Integer.parseInt(val);
    }

    public BaseConfig setContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    public BaseConfig setPort(int port) {
        this.port = port;
        return this;
    }

    public BaseConfig setInternalPort(int internalPort) {
        this.internalPort = internalPort;
        return this;
    }

    public BaseConfig setAdminPort(int adminPort) {
        this.adminPort = adminPort;
        return this;
    }

    public BaseConfig setAdminInternalPort(int adminInternalPort) {
        this.adminInternalPort = adminInternalPort;
        return this;
    }

    public BaseConfig setImage(String image) {
        this.image = image;
        return this;
    }

    public BaseConfig setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
        return this;
    }

    public BaseConfig setCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public BaseConfig setMaxReadyAttempts(int maxReadyAttempts) {
        this.maxReadyAttempts = maxReadyAttempts;
        return this;
    }

    public BaseConfig setDocker(String docker) {
        this.docker = docker;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public int getAdminInternalPort() {
        return this.adminInternalPort;
    }

    public String getImage() {
        return this.image;
    }

    public StartMode getStartMode() {
        return this.startMode;
    }

    public StopMode getStopMode() {
        return this.stopMode;
    }

    public int getMaxReadyAttempts() {
        return this.maxReadyAttempts;
    }

    public String getDocker() {
        return this.docker;
    }

    public StopMode shutdownMode() {
        return this.shutdownMode;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public String getCollation() {
        return this.collation;
    }

    public boolean isExplicitCollation() {
        return this.collation != null || this.characterSet != null;
    }

    public boolean isDefaultCollation() {
        return "default".equals(this.collation);
    }

    public boolean isStopModeNone() {
        return StopMode.None == this.stopMode;
    }

    public void clearStopMode() {
        this.stopMode = StopMode.None;
    }
}

