/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.docker.commands;

import io.ebean.docker.commands.CommandException;
import io.ebean.docker.commands.Db2Config;
import io.ebean.docker.commands.JdbcBaseDbContainer;
import io.ebean.docker.commands.process.ProcessHandler;
import io.ebean.docker.commands.process.ProcessResult;
import io.ebean.docker.container.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;

public class Db2Container
extends JdbcBaseDbContainer
implements Container {
    public static Db2Container create(String Db2Version, Properties properties) {
        return new Db2Container(new Db2Config(Db2Version, properties));
    }

    public Db2Container(Db2Config config) {
        super(config);
    }

    @Override
    void createDatabase() {
        if (this.checkConnectivity(false)) {
            return;
        }
        try {
            this.dockerSu("root", "useradd -g db2iadm1 " + this.dbConfig.getUsername());
        }
        catch (CommandException e) {
            e.getResult().getOutLines().forEach(arg_0 -> ((Logger)log).warn(arg_0));
        }
        this.dockerSu("root", "echo \"" + this.dbConfig.getUsername() + ":" + this.dbConfig.getPassword() + "\" | chpasswd");
        String cmd = "db2 create database " + this.dbConfig.getDbName();
        if (this.defined(((Db2Config)this.dbConfig).getCreateOptions())) {
            cmd = cmd + " " + ((Db2Config)this.dbConfig).getCreateOptions();
        }
        this.dockerSu(cmd);
        if (this.defined(((Db2Config)this.dbConfig).getConfigOptions())) {
            cmd = "db2 update database config for " + this.dbConfig.getDbName() + " " + ((Db2Config)this.dbConfig).getConfigOptions();
            this.dockerSu(this.dbConfig.getAdminUsername(), cmd);
        }
        cmd = "db2 activate database " + this.dbConfig.getDbName();
        this.dockerSu(cmd);
        cmd = "/var/db2_setup/lib/set_rec_values.sh " + this.dbConfig.getDbName();
        this.dockerSu(cmd);
    }

    @Override
    void dropCreateDatabase() {
        try {
            this.dockerSu("db2 drop database " + this.dbConfig.getDbName());
        }
        catch (CommandException e) {
            e.getResult().getOutLines().forEach(arg_0 -> ((Logger)log).warn(arg_0));
        }
        this.createDatabase();
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        args.add("--privileged");
        args.add("-e");
        args.add("LICENSE=accept");
        args.add("-e");
        args.add("SAMPLEDB=false");
        args.add("-e");
        args.add("ARCHIVE_LOGS=false");
        args.add("-e");
        args.add("AUTOCONFIG=false");
        args.add("-e");
        args.add("DB2INSTANCE=" + this.dbConfig.getAdminUsername());
        if (this.defined(this.dbConfig.getAdminPassword())) {
            args.add("-e");
            args.add("DB2INST1_PASSWORD=" + this.dbConfig.getAdminPassword());
        }
        args.add("-e");
        args.add("DBNAME=");
        args.add(this.config.getImage());
        return this.createProcessBuilder(args);
    }

    protected List<String> dockerSu(String user, String cmd) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker);
        args.add("exec");
        args.add("-i");
        args.add(this.config.containerName());
        args.add("su");
        args.add("-");
        args.add(user);
        args.add("-c");
        args.add(cmd);
        ProcessBuilder pb = this.createProcessBuilder(args);
        ProcessResult pr = ProcessHandler.process(pb);
        pr.getOutLines().forEach(arg_0 -> ((Logger)log).debug(arg_0));
        return pr.getOutLines();
    }

    protected List<String> dockerSu(String cmd) {
        return this.dockerSu(this.dbConfig.getAdminUsername(), cmd);
    }

    @Override
    boolean checkConnectivity() {
        try {
            List<String> result = this.dockerSu("db2pd -");
            for (String outLine : result) {
                if (!outLine.contains("-- Active --")) continue;
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

