/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.CommandException;
import io.ebean.test.containers.DbConfig;
import io.ebean.test.containers.JdbcBaseDbContainer;
import io.ebean.test.containers.process.ProcessHandler;
import io.ebean.test.containers.process.ProcessResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class NuoDBContainer
extends JdbcBaseDbContainer {
    private static final String AD_RESET = "Entering initializing for server";
    private static final String AD_RUNNING = "NuoAdmin Server running";
    private static final String SM_RESET = "Starting Storage Manager";
    private static final String SM_RUNNING = "Database formed";
    private static final String SM_UNABLE_TO_CONNECT = "Unable to connect ";
    private static final String TE_RESET = "Starting Transaction Engine";
    private static final String TE_RUNNING = "Database entered";
    private final String network;
    private final String adName;
    private final String smName;
    private final String teName;

    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return NuoDBContainer.builder(version);
    }

    private NuoDBContainer(Builder builder) {
        super(builder);
        this.checkConnectivityUsingAdmin = true;
        builder.initDefaultSchema();
        builder.internalConfig().setDefaultContainerName();
        this.adName = this.config.containerName();
        String network_ = builder.getNetwork();
        this.network = network_ == null ? this.adName + "-net" : network_;
        this.smName = this.adName + "_" + builder.getSm1();
        this.teName = this.adName + "_" + builder.getTe1();
    }

    @Override
    public void stopRemove() {
        if (this.stopDatabase()) {
            this.commands.removeContainers(this.teName, this.smName, this.adName);
        }
        if (this.networkExists()) {
            this.removeNetwork();
        }
    }

    private void removeNetwork() {
        ProcessHandler.process(this.procNetworkRemove());
    }

    @Override
    public void stopIfRunning() {
        this.stopDatabase();
    }

    private boolean stopDatabase() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("exec");
        args.add("-i");
        args.add(this.adName);
        args.add("nuocmd");
        args.add("shutdown");
        args.add("database");
        args.add("--db-name");
        args.add(this.dbConfig.getDbName());
        ProcessResult result = ProcessHandler.process(this.createProcessBuilder(args));
        if (!result.success()) {
            log.log(System.Logger.Level.ERROR, "Error performing shutdown database " + result);
            return false;
        }
        this.waitTime(100L);
        this.commands.stop(this.adName);
        return true;
    }

    @Override
    void runContainer() {
        this.createNetwork();
        ProcessHandler.process(this.runAdminProcess());
        if (this.waitForAdminProcess()) {
            ProcessHandler.process(this.runStorageManager());
            if (this.waitForStorageManager()) {
                ProcessHandler.process(this.runTransactionManager());
                this.waitForTransactionManager();
            }
        }
    }

    private boolean waitForTransactionManager() {
        return this.waitForLogs(this.teName, TE_RUNNING, TE_RESET) && this.waitTime(100L);
    }

    private boolean storageManagerUnableToConnect() {
        boolean unableToConnect = false;
        List<String> logs = this.commands.logs(this.smName);
        for (String log : logs) {
            if (log.contains(SM_UNABLE_TO_CONNECT)) {
                unableToConnect = true;
                continue;
            }
            if (!log.contains(SM_RUNNING)) continue;
            unableToConnect = false;
        }
        return unableToConnect;
    }

    private boolean waitForStorageManager() {
        return this.waitForLogs(this.smName, SM_RUNNING, SM_RESET);
    }

    private boolean waitForAdminProcess() {
        return this.waitForLogs(this.config.containerName(), AD_RUNNING, AD_RESET);
    }

    private boolean waitTime(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
        }
        return true;
    }

    private boolean waitForLogs(String containerName, String match, String resetMatch) {
        for (int i = 0; i < 150; ++i) {
            if (this.logsContain(containerName, match, resetMatch)) {
                return true;
            }
            try {
                int sleep = i < 10 ? 10 : (i < 20 ? 20 : 100);
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return false;
    }

    @Override
    void startContainer() {
        this.commands.start(this.adName);
        if (!this.waitForAdminProcess() || !this.waitForDatabaseState()) {
            throw new RuntimeException("Failed waiting for NuoDB admin container [" + this.smName + "] to start running");
        }
        if (!this.startStorageManager(0)) {
            throw new RuntimeException("Failed to start storage manager NuoDB [" + this.adName + "]");
        }
        this.commands.start(this.teName);
        if (!this.waitForTransactionManager()) {
            throw new RuntimeException("Failed waiting for NuoDB transaction manager [" + this.smName + "] to start running");
        }
    }

    private boolean waitForDatabaseState() {
        this.waitTime(100L);
        for (int i = 0; i < 20; ++i) {
            if (this.checkDbStateOk()) {
                return true;
            }
            this.waitTime(100L);
        }
        return false;
    }

    private boolean checkDbStateOk() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("exec");
        args.add("-i");
        args.add(this.adName);
        args.add("nuocmd");
        args.add("show");
        args.add("database");
        args.add("--db-format");
        args.add("dbState:{state}");
        args.add("--db-name");
        args.add(this.dbConfig.getDbName());
        try {
            ProcessResult result = ProcessHandler.process(this.createProcessBuilder(args));
            if (result.success()) {
                for (String outLine : result.getOutLines()) {
                    String trimmedOut = outLine.trim();
                    if (!trimmedOut.startsWith("dbState:")) continue;
                    return this.dbStateOk(trimmedOut);
                }
            }
        }
        catch (CommandException e) {
            return false;
        }
        return false;
    }

    private boolean dbStateOk(String trimmedOut) {
        log.log(System.Logger.Level.TRACE, "checking dbStateOk [{0}]", trimmedOut);
        return trimmedOut.contains("NOT_RUNNING") || trimmedOut.contains("RUNNING");
    }

    private boolean startStorageManager(int attempt) {
        this.commands.start(this.smName);
        if (!this.waitForStorageManager()) {
            log.log(System.Logger.Level.ERROR, "Failed waiting for NuoDB storage manager [" + this.adName + "] to start running");
            return false;
        }
        if (this.storageManagerUnableToConnect()) {
            log.log(System.Logger.Level.INFO, "Retry NuoDB storage manager [" + this.adName + "] attempt:" + attempt);
            return attempt <= 2 && this.startStorageManager(attempt + 1);
        }
        return true;
    }

    private void createNetwork() {
        if (!this.networkExists()) {
            ProcessHandler.process(this.procNetworkCreate());
        }
    }

    private boolean networkExists() {
        return this.execute(this.network, this.procNetworkList());
    }

    private ProcessBuilder procNetworkCreate() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("network");
        args.add("create");
        args.add(this.network);
        return this.createProcessBuilder(args);
    }

    private ProcessBuilder procNetworkRemove() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("network");
        args.add("rm");
        args.add(this.network);
        return this.createProcessBuilder(args);
    }

    private ProcessBuilder procNetworkList() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("network");
        args.add("ls");
        args.add("-f");
        args.add("name=" + this.network);
        return this.createProcessBuilder(args);
    }

    @Override
    protected ProcessBuilder runProcess() {
        throw new RuntimeException("Not used for NuoDB container");
    }

    private ProcessBuilder runAdminProcess() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.adName);
        args.add("--hostname");
        args.add(this.adName);
        args.add("--network");
        args.add(this.network);
        args.add("-p");
        args.add(this.config.getPort() + ":" + this.config.getInternalPort());
        args.add("--env");
        args.add("NUODB_DOMAIN_ENTRYPOINT=" + this.adName);
        args.add(this.config.getImage());
        args.add("nuoadmin");
        return this.createProcessBuilder(args);
    }

    private ProcessBuilder runStorageManager() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.smName);
        args.add("--hostname");
        args.add(this.smName);
        args.add("--network");
        args.add(this.network);
        args.add(this.config.getImage());
        args.add("nuodocker");
        args.add("--api-server");
        args.add(this.adName + ":" + this.config.getAdminInternalPort());
        args.add("start");
        args.add("sm");
        args.add("--db-name");
        args.add(this.dbConfig.getDbName());
        args.add("--server-id");
        args.add(this.adName);
        args.add("--dba-user");
        args.add(this.dbConfig.getAdminUsername());
        args.add("--dba-password");
        args.add(this.dbConfig.getAdminPassword());
        return this.createProcessBuilder(args);
    }

    private ProcessBuilder runTransactionManager() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.config.docker());
        args.add("run");
        args.add("-d");
        args.add("--name");
        args.add(this.teName);
        args.add("--hostname");
        args.add(this.teName);
        args.add("--network");
        args.add(this.network);
        args.add(this.config.getImage());
        args.add("nuodocker");
        args.add("--api-server");
        args.add(this.adName + ":" + this.config.getAdminInternalPort());
        args.add("start");
        args.add("te");
        args.add("--db-name");
        args.add(this.dbConfig.getDbName());
        args.add("--server-id");
        args.add(this.adName);
        return this.createProcessBuilder(args);
    }

    @Override
    public boolean isDatabaseReady() {
        return this.commands.logsContain(this.config.containerName(), AD_RUNNING);
    }

    @Override
    protected boolean isDatabaseAdminReady() {
        return true;
    }

    @Override
    void createDatabase() {
        this.createSchemaAndUser(false);
    }

    @Override
    void dropCreateDatabase() {
        this.createSchemaAndUser(true);
    }

    private void createSchemaAndUser(boolean withDrop) {
        try (Connection connection = this.config.createAdminConnection();){
            boolean userExists;
            boolean schemaExists;
            if (withDrop) {
                this.sqlDropSchema(connection, this.dbConfig.getSchema());
            }
            if (!(schemaExists = this.sqlSchemaExists(connection, this.dbConfig.getSchema()))) {
                this.sqlCreateSchema(connection, this.dbConfig.getSchema());
            }
            if (!(userExists = this.sqlUserExists(connection, this.dbConfig.getUsername()))) {
                this.sqlCreateUser(connection, this.dbConfig.getUsername(), this.dbConfig.getPassword());
            }
            if (withDrop || !userExists) {
                this.sqlUserGrants(connection, this.dbConfig.getSchema(), this.dbConfig.getUsername());
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void sqlDropSchema(Connection connection, String schema) throws SQLException {
        this.exeSql(connection, "drop schema " + schema + " cascade if exists");
    }

    private void sqlUserGrants(Connection connection, String schema, String username) throws SQLException {
        this.exeSql(connection, "grant create on schema " + schema + " to " + username);
    }

    private void sqlCreateSchema(Connection connection, String schema) throws SQLException {
        this.exeSql(connection, "create schema " + schema);
    }

    private void sqlCreateUser(Connection connection, String username, String password) throws SQLException {
        this.exeSql(connection, "create user " + username + " password '" + password + "'");
    }

    private boolean sqlSchemaExists(Connection connection, String schemaName) throws SQLException {
        return this.sqlQueryMatch(connection, "select schema from system.schemas", schemaName);
    }

    private boolean sqlUserExists(Connection connection, String dbUser) throws SQLException {
        return this.sqlQueryMatch(connection, "select username from system.users", dbUser);
    }

    private void exeSql(Connection connection, String sql) throws SQLException {
        log.log(System.Logger.Level.DEBUG, "exeSql {0}", sql);
        try (PreparedStatement st = connection.prepareStatement(sql);){
            st.execute();
        }
    }

    public static class Builder
    extends DbConfig<NuoDBContainer, Builder> {
        private String network;
        private String sm1 = "sm";
        private String te1 = "te";

        private Builder(String version) {
            super("nuodb", 48004, 48004, version);
            this.containerName = this.platform;
            this.image = "nuodb/nuodb-ce:" + version;
            this.adminUsername = "dba";
            this.adminPassword = "dba";
            this.adminPort = 8888;
            this.adminInternalPort = 8888;
            this.dbName = "testdb";
        }

        @Override
        protected String buildSummary() {
            return "host:" + this.host + " port:" + this.port + " db:" + this.dbName + " schema:" + this.schema + " user:" + this.deriveUsername() + "/" + this.password;
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:com.nuodb://" + this.getHost() + ":" + this.getPort() + "/" + this.getDbName();
        }

        public Builder network(String network) {
            this.network = network;
            return (Builder)this.self();
        }

        public Builder sm1(String sm1) {
            this.sm1 = sm1;
            return (Builder)this.self();
        }

        public Builder te1(String te1) {
            this.te1 = te1;
            return (Builder)this.self();
        }

        private String getSm1() {
            return this.sm1;
        }

        private String getTe1() {
            return this.te1;
        }

        private String getNetwork() {
            return this.network;
        }

        @Override
        public NuoDBContainer build() {
            return new NuoDBContainer(this);
        }
    }
}

