/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.redis;

import java.util.Properties;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisConfig {
    private String server = "localhost";
    private int port = 6379;
    private int maxTotal = 200;
    private int maxIdle = 200;
    private int minIdle = 1;
    private long maxWaitMillis = -1L;
    private boolean blockWhenExhausted = true;
    private int timeout = 2000;
    private String username;
    private String password;
    private boolean ssl;

    public JedisPool createPool() {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(this.maxTotal);
        poolConfig.setMaxIdle(this.maxIdle);
        poolConfig.setMinIdle(this.minIdle);
        poolConfig.setMaxWaitMillis(this.maxWaitMillis);
        poolConfig.setBlockWhenExhausted(this.blockWhenExhausted);
        return new JedisPool((GenericObjectPoolConfig)poolConfig, this.server, this.port, this.timeout, this.username, this.password, this.ssl);
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public boolean isBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public void setBlockWhenExhausted(boolean blockWhenExhausted) {
        this.blockWhenExhausted = blockWhenExhausted;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public void loadProperties(Properties properties) {
        Reader reader = new Reader(properties);
        this.server = reader.get("ebean.redis.server", this.server);
        this.port = reader.getInt("ebean.redis.port", this.port);
        this.ssl = reader.getBool("ebean.redis.ssl", this.ssl);
        this.minIdle = reader.getInt("ebean.redis.minIdle", this.minIdle);
        this.maxIdle = reader.getInt("ebean.redis.maxIdle", this.maxIdle);
        this.maxTotal = reader.getInt("ebean.redis.maxTotal", this.maxTotal);
        this.maxWaitMillis = reader.getLong("ebean.redis.maxWaitMillis", this.maxWaitMillis);
        this.timeout = reader.getInt("ebean.redis.timeout", this.timeout);
        this.username = reader.get("ebean.redis.username", this.username);
        this.password = reader.get("ebean.redis.password", this.password);
        this.blockWhenExhausted = reader.getBool("ebean.redis.blockWhenExhausted", this.blockWhenExhausted);
    }

    private static class Reader {
        private final Properties properties;

        Reader(Properties properties) {
            this.properties = properties != null ? properties : new Properties();
        }

        String get(String key, String defaultVal) {
            return System.getProperty(key, this.properties.getProperty(key, defaultVal));
        }

        int getInt(String key, int defaultVal) {
            String val = this.get(key, null);
            return val != null ? Integer.parseInt(val.trim()) : defaultVal;
        }

        long getLong(String key, long defaultVal) {
            String val = this.get(key, null);
            return val != null ? (long)Integer.parseInt(val.trim()) : defaultVal;
        }

        boolean getBool(String key, boolean defaultVal) {
            String val = this.get(key, null);
            return val != null ? Boolean.parseBoolean(val.trim()) : defaultVal;
        }
    }
}

