/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.redis.topic;

import io.avaje.applog.AppLog;
import io.ebean.redis.topic.DaemonTopic;
import java.util.Timer;
import java.util.TimerTask;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

public final class DaemonTopicRunner {
    private static final System.Logger log = AppLog.getLogger(DaemonTopicRunner.class);
    private static final long reconnectWaitMillis = 1000L;
    private final JedisPool jedisPool;
    private final DaemonTopic daemonTopic;

    public DaemonTopicRunner(JedisPool jedisPool, DaemonTopic daemonTopic) {
        this.jedisPool = jedisPool;
        this.daemonTopic = daemonTopic;
    }

    public void run() {
        new Thread(this::attemptConnections, "redis-sub").start();
    }

    private void attemptConnections() {
        Timer reloadTimer = new Timer("redis-sub-notify");
        TimerTask notifyTask = null;
        int attempts = 1;
        while (true) {
            if (notifyTask != null) {
                notifyTask.cancel();
            }
            notifyTask = new ReloadNotifyTask();
            reloadTimer.schedule(notifyTask, 1500L);
            ++attempts;
            try {
                this.subscribe();
                continue;
            }
            catch (JedisException e) {
                log.log(System.Logger.Level.DEBUG, "... redis subscribe connection attempt:{0} failed:{1}", attempts, e.getMessage());
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    log.log(System.Logger.Level.WARNING, "Interrupted redis re-connection wait", (Throwable)e1);
                    continue;
                }
            }
            break;
        }
    }

    private void subscribe() {
        Jedis jedis = this.jedisPool.getResource();
        jedis.echo("hi");
        try {
            this.daemonTopic.subscribe(jedis);
        }
        catch (Exception e) {
            log.log(System.Logger.Level.ERROR, "Lost connection to topic, starting re-connection loop", (Throwable)e);
            this.attemptConnections();
        }
        finally {
            try {
                jedis.close();
            }
            catch (Exception e) {
                log.log(System.Logger.Level.WARNING, "Error closing probably broken Redis connection", (Throwable)e);
            }
        }
    }

    private class ReloadNotifyTask
    extends TimerTask {
        private ReloadNotifyTask() {
        }

        @Override
        public void run() {
            DaemonTopicRunner.this.daemonTopic.notifyConnected();
        }
    }
}

