/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.redis;

import io.avaje.applog.AppLog;
import io.ebean.BackgroundExecutor;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheConfig;
import io.ebean.cache.ServerCacheFactory;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import io.ebean.config.DatabaseConfig;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.MetricFactory;
import io.ebean.metric.TimedMetric;
import io.ebean.redis.DuelCache;
import io.ebean.redis.ModId;
import io.ebean.redis.NearCacheInvalidate;
import io.ebean.redis.NearCacheNotify;
import io.ebean.redis.RedisCache;
import io.ebean.redis.RedisConfig;
import io.ebean.redis.encode.EncodeBeanData;
import io.ebean.redis.encode.EncodeManyIdsData;
import io.ebean.redis.encode.EncodeSerializable;
import io.ebean.redis.topic.DaemonTopic;
import io.ebean.redis.topic.DaemonTopicRunner;
import io.ebeaninternal.server.cache.DefaultServerCache;
import io.ebeaninternal.server.cache.DefaultServerCacheConfig;
import io.ebeaninternal.server.cache.DefaultServerQueryCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.SafeEncoder;

final class RedisCacheFactory
implements ServerCacheFactory {
    private static final System.Logger log = AppLog.getLogger(RedisCacheFactory.class);
    private static final System.Logger queryLogger = AppLog.getLogger((String)"io.ebean.cache.QUERY");
    private static final System.Logger logger = AppLog.getLogger((String)"io.ebean.cache.CACHE");
    private static final System.Logger tableModLogger = AppLog.getLogger((String)"io.ebean.cache.TABLEMODS");
    private static final int MSG_NEARCACHE_CLEAR = 1;
    private static final int MSG_NEARCACHE_KEYS = 2;
    private static final int MSG_NEARCACHE_KEY = 3;
    private static final String CHANNEL_L2 = "ebean.l2cache";
    private static final String CHANNEL_NEAR = "ebean.l2near";
    private static final byte[] CHANNEL_L2_BYTES = SafeEncoder.encode((String)"ebean.l2cache");
    private static final byte[] CHANNEL_NEAR_BYTES = SafeEncoder.encode((String)"ebean.l2near");
    private final ConcurrentHashMap<String, RQueryCache> queryCaches = new ConcurrentHashMap();
    private final Map<String, NearCacheInvalidate> nearCacheMap = new ConcurrentHashMap<String, NearCacheInvalidate>();
    private final EncodeManyIdsData encodeManyIdsData = new EncodeManyIdsData();
    private final EncodeBeanData encodeBeanData = new EncodeBeanData();
    private final EncodeSerializable encodeSerializable = new EncodeSerializable();
    private final BackgroundExecutor executor;
    private final JedisPool jedisPool;
    private final NearCacheNotify nearCacheNotify;
    private final TimedMetric metricOutNearCache;
    private final TimedMetric metricOutTableMod;
    private final TimedMetric metricOutQueryCache;
    private final TimedMetric metricInNearCache;
    private final TimedMetric metricInTableMod;
    private final TimedMetric metricInQueryCache;
    private final String serverId = ModId.id();
    private final ReentrantLock lock = new ReentrantLock();
    private ServerCacheNotify listener;

    RedisCacheFactory(DatabaseConfig config, BackgroundExecutor executor) {
        this.executor = executor;
        this.nearCacheNotify = new DNearCacheNotify();
        MetricFactory factory = MetricFactory.get();
        this.metricOutTableMod = factory.createTimedMetric("l2a.outTableMod");
        this.metricOutQueryCache = factory.createTimedMetric("l2a.outQueryCache");
        this.metricOutNearCache = factory.createTimedMetric("l2a.outNearKeys");
        this.metricInTableMod = factory.createTimedMetric("l2a.inTableMod");
        this.metricInQueryCache = factory.createTimedMetric("l2a.inQueryCache");
        this.metricInNearCache = factory.createTimedMetric("l2a.inNearKeys");
        if (config.isDisableL2Cache()) {
            this.jedisPool = null;
        } else {
            this.jedisPool = this.getJedisPool(config);
            new DaemonTopicRunner(this.jedisPool, new CacheDaemonTopic()).run();
        }
    }

    private JedisPool getJedisPool(DatabaseConfig config) {
        JedisPool jedisPool = (JedisPool)config.getServiceObject(JedisPool.class);
        if (jedisPool != null) {
            return jedisPool;
        }
        RedisConfig redisConfig = (RedisConfig)config.getServiceObject(RedisConfig.class);
        if (redisConfig == null) {
            redisConfig = new RedisConfig();
        }
        redisConfig.loadProperties(config.getProperties());
        log.log(System.Logger.Level.INFO, "using l2cache redis host {0}:{1}", redisConfig.getServer(), redisConfig.getPort());
        return redisConfig.createPool();
    }

    public void visit(MetricVisitor visitor) {
        this.metricOutQueryCache.visit(visitor);
        this.metricOutTableMod.visit(visitor);
        this.metricOutNearCache.visit(visitor);
        this.metricInTableMod.visit(visitor);
        this.metricInQueryCache.visit(visitor);
        this.metricInNearCache.visit(visitor);
    }

    public ServerCache createCache(ServerCacheConfig config) {
        if (config.isQueryCache()) {
            return this.createQueryCache(config);
        }
        return this.createNormalCache(config);
    }

    private ServerCache createNormalCache(ServerCacheConfig config) {
        RedisCache redisCache = this.createRedisCache(config);
        boolean nearCache = config.getCacheOptions().isNearCache();
        if (!nearCache) {
            return config.tenantAware((ServerCache)redisCache);
        }
        String cacheKey = config.getCacheKey();
        DefaultServerCache near = new DefaultServerCache(new DefaultServerCacheConfig(config));
        near.periodicTrim(this.executor);
        DuelCache duelCache = new DuelCache(near, redisCache, cacheKey, this.nearCacheNotify);
        this.nearCacheMap.put(cacheKey, duelCache);
        return config.tenantAware((ServerCache)duelCache);
    }

    private RedisCache createRedisCache(ServerCacheConfig config) {
        switch (config.getType()) {
            case NATURAL_KEY: {
                return new RedisCache(this.jedisPool, config, this.encodeSerializable);
            }
            case BEAN: {
                return new RedisCache(this.jedisPool, config, this.encodeBeanData);
            }
            case COLLECTION_IDS: {
                return new RedisCache(this.jedisPool, config, this.encodeManyIdsData);
            }
        }
        throw new IllegalArgumentException("Unexpected cache type? " + config.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerCache createQueryCache(ServerCacheConfig config) {
        this.lock.lock();
        try {
            RQueryCache cache = this.queryCaches.get(config.getCacheKey());
            if (cache == null) {
                logger.log(System.Logger.Level.DEBUG, "create query cache [{0}]", config.getCacheKey());
                cache = new RQueryCache(new DefaultServerCacheConfig(config));
                cache.periodicTrim(this.executor);
                this.queryCaches.put(config.getCacheKey(), cache);
            }
            ServerCache serverCache = config.tenantAware((ServerCache)cache);
            return serverCache;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ServerCacheNotify createCacheNotify(ServerCacheNotify listener) {
        this.listener = listener;
        return new RServerCacheNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueryCacheInvalidation(String name) {
        long nanos = System.nanoTime();
        try (Jedis resource = this.jedisPool.getResource();){
            resource.publish(CHANNEL_L2, this.serverId + ":queryCache:" + name);
        }
        finally {
            this.metricOutQueryCache.addSinceNanos(nanos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTableMod(String formattedMsg) {
        long nanos = System.nanoTime();
        try (Jedis resource = this.jedisPool.getResource();){
            resource.publish(CHANNEL_L2, this.serverId + ":tableMod:" + formattedMsg);
        }
        finally {
            this.metricOutTableMod.addSinceNanos(nanos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryCacheInvalidate(String key) {
        long nanos = System.nanoTime();
        try {
            RQueryCache queryCache = this.queryCaches.get(key);
            if (queryCache != null) {
                queryCache.invalidate();
            }
        }
        finally {
            this.metricInQueryCache.addSinceNanos(nanos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTableNotify(String rawMessage) {
        long nanos = System.nanoTime();
        try {
            if (logger.isLoggable(System.Logger.Level.DEBUG)) {
                logger.log(System.Logger.Level.DEBUG, "processTableNotify {0}", rawMessage);
            }
            HashSet<String> tables = new HashSet<String>(Arrays.asList(rawMessage.split(",")));
            this.listener.notify(new ServerCacheNotification(tables));
        }
        finally {
            this.metricInTableMod.addSinceNanos(nanos);
        }
    }

    private void nearCacheInvalidateKey(String cacheKey, Object key) {
        NearCacheInvalidate invalidate = this.nearCacheMap.get(cacheKey);
        if (invalidate == null) {
            this.warnNearCacheNotFound(cacheKey);
        } else {
            invalidate.invalidateKey(key);
        }
    }

    private void nearCacheInvalidateKeys(String cacheKey, Set<Object> keys) {
        NearCacheInvalidate invalidate = this.nearCacheMap.get(cacheKey);
        if (invalidate == null) {
            this.warnNearCacheNotFound(cacheKey);
        } else {
            invalidate.invalidateKeys(keys);
        }
    }

    private void nearCacheInvalidateClear(String cacheKey) {
        NearCacheInvalidate invalidate = this.nearCacheMap.get(cacheKey);
        if (invalidate == null) {
            this.warnNearCacheNotFound(cacheKey);
        } else {
            invalidate.invalidateClear();
        }
    }

    private void warnNearCacheNotFound(String cacheKey) {
        logger.log(System.Logger.Level.WARNING, "No near cache found for cacheKey [" + cacheKey + "] yet - probably on startup");
    }

    private class DNearCacheNotify
    implements NearCacheNotify {
        private DNearCacheNotify() {
        }

        @Override
        public void invalidateKeys(String cacheKey, Set<Object> keySet) {
            try {
                this.sendMessage(this.messageInvalidateKeys(cacheKey, keySet));
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.ERROR, "failed to transmit invalidateKeys() message", (Throwable)e);
            }
        }

        @Override
        public void invalidateKey(String cacheKey, Object id) {
            try {
                this.sendMessage(this.messageInvalidateKey(cacheKey, id));
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.ERROR, "failed to transmit invalidateKeys() message", (Throwable)e);
            }
        }

        @Override
        public void invalidateClear(String cacheKey) {
            try {
                this.sendMessage(this.messageInvalidateClear(cacheKey));
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.ERROR, "failed to transmit invalidateKeys() message", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessage(byte[] message) {
            long nanos = System.nanoTime();
            try (Jedis resource = RedisCacheFactory.this.jedisPool.getResource();){
                resource.publish(CHANNEL_NEAR_BYTES, message);
            }
            finally {
                RedisCacheFactory.this.metricOutNearCache.addSinceNanos(nanos);
            }
        }

        private byte[] messageInvalidateKeys(String cacheKey, Set<Object> keySet) throws IOException {
            ByteArrayOutputStream ba = new ByteArrayOutputStream(100);
            ObjectOutputStream os = new ObjectOutputStream(ba);
            os.writeUTF(RedisCacheFactory.this.serverId);
            os.writeInt(2);
            os.writeUTF(cacheKey);
            os.writeInt(keySet.size());
            for (Object key : keySet) {
                os.writeObject(key);
            }
            os.flush();
            os.close();
            return ba.toByteArray();
        }

        private byte[] messageInvalidateKey(String cacheKey, Object id) throws IOException {
            ByteArrayOutputStream ba = new ByteArrayOutputStream(100);
            ObjectOutputStream os = new ObjectOutputStream(ba);
            os.writeUTF(RedisCacheFactory.this.serverId);
            os.writeInt(3);
            os.writeUTF(cacheKey);
            os.writeObject(id);
            os.flush();
            os.close();
            return ba.toByteArray();
        }

        private byte[] messageInvalidateClear(String cacheKey) throws IOException {
            ByteArrayOutputStream ba = new ByteArrayOutputStream(100);
            ObjectOutputStream os = new ObjectOutputStream(ba);
            os.writeUTF(RedisCacheFactory.this.serverId);
            os.writeInt(1);
            os.writeUTF(cacheKey);
            os.flush();
            os.close();
            return ba.toByteArray();
        }
    }

    private class CacheDaemonTopic
    implements DaemonTopic {
        private CacheDaemonTopic() {
        }

        @Override
        public void subscribe(Jedis jedis) {
            jedis.subscribe((BinaryJedisPubSub)new ChannelSubscriber(), (byte[][])new byte[][]{CHANNEL_L2_BYTES, CHANNEL_NEAR_BYTES});
        }

        @Override
        public void notifyConnected() {
            logger.log(System.Logger.Level.INFO, "Established connection to Redis");
        }

        private class ChannelSubscriber
        extends BinaryJedisPubSub {
            private ChannelSubscriber() {
            }

            public void onMessage(byte[] channel, byte[] message) {
                String channelName = SafeEncoder.encode((byte[])channel);
                if (channelName.equals(RedisCacheFactory.CHANNEL_L2)) {
                    this.processL2Message(SafeEncoder.encode((byte[])message));
                } else {
                    this.processNearCacheMessage(message);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void processNearCacheMessage(byte[] message) {
                long nanos = System.nanoTime();
                int msgType = 0;
                String cacheKey = null;
                try {
                    ObjectInputStream oi = new ObjectInputStream(new ByteArrayInputStream(message));
                    String sourceServerId = oi.readUTF();
                    if (sourceServerId.equals(RedisCacheFactory.this.serverId)) {
                        return;
                    }
                    msgType = oi.readInt();
                    cacheKey = oi.readUTF();
                    if (logger.isLoggable(System.Logger.Level.DEBUG)) {
                        logger.log(System.Logger.Level.DEBUG, "processNearCacheMessage serverId:{0} type:{1} cacheKey:{2}", sourceServerId, msgType, cacheKey);
                    }
                    switch (msgType) {
                        case 1: {
                            RedisCacheFactory.this.nearCacheInvalidateClear(cacheKey);
                            return;
                        }
                        case 3: {
                            Object key = oi.readObject();
                            RedisCacheFactory.this.nearCacheInvalidateKey(cacheKey, key);
                            return;
                        }
                        case 2: {
                            int count = oi.readInt();
                            LinkedHashSet<Object> keys = new LinkedHashSet<Object>();
                            for (int i = 0; i < count; ++i) {
                                keys.add(oi.readObject());
                            }
                            RedisCacheFactory.this.nearCacheInvalidateKeys(cacheKey, keys);
                            return;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected message type ? " + msgType);
                        }
                    }
                }
                catch (IOException | ClassNotFoundException e) {
                    logger.log(System.Logger.Level.ERROR, "failed to decode near cache message [" + SafeEncoder.encode((byte[])message) + "] for cache:" + cacheKey, (Throwable)e);
                    if (cacheKey == null) return;
                    RedisCacheFactory.this.nearCacheInvalidateClear(cacheKey);
                    return;
                }
                finally {
                    if (msgType != 0) {
                        RedisCacheFactory.this.metricInNearCache.addSinceNanos(nanos);
                    }
                }
            }

            private void processL2Message(String message) {
                try {
                    String[] split = message.split(":");
                    if (RedisCacheFactory.this.serverId.equals(split[0])) {
                        return;
                    }
                    switch (split[1]) {
                        case "tableMod": {
                            RedisCacheFactory.this.processTableNotify(split[2]);
                            break;
                        }
                        case "queryCache": {
                            RedisCacheFactory.this.queryCacheInvalidate(split[2]);
                            break;
                        }
                        default: {
                            logger.log(System.Logger.Level.ERROR, "Unknown L2 message type[{0}] on redis channel - message[{1}] ", split[0], message);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Error handling L2 message[" + message + "]", (Throwable)e);
                }
            }
        }
    }

    private class RQueryCache
    extends DefaultServerQueryCache {
        RQueryCache(DefaultServerCacheConfig config) {
            super(config);
        }

        public void clear() {
            super.clear();
            RedisCacheFactory.this.sendQueryCacheInvalidation(this.name);
        }

        private void invalidate() {
            queryLogger.log(System.Logger.Level.DEBUG, "   CLEAR {0}(*) - cluster invalidate", this.name);
            super.clear();
        }
    }

    private class RServerCacheNotify
    implements ServerCacheNotify {
        private RServerCacheNotify() {
        }

        public void notify(ServerCacheNotification tableModifications) {
            Set dependentTables = tableModifications.getDependentTables();
            if (dependentTables != null && !dependentTables.isEmpty()) {
                StringBuilder msg = new StringBuilder(50);
                for (String table : dependentTables) {
                    msg.append(table).append(",");
                }
                String formattedMsg = msg.toString();
                if (tableModLogger.isLoggable(System.Logger.Level.DEBUG)) {
                    tableModLogger.log(System.Logger.Level.DEBUG, "Publish TableMods - {0}", formattedMsg);
                }
                RedisCacheFactory.this.sendTableMod(formattedMsg);
            }
        }
    }
}

