/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.redis;

import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheStatistics;
import io.ebean.meta.MetricVisitor;
import io.ebean.redis.NearCacheInvalidate;
import io.ebean.redis.NearCacheNotify;
import io.ebean.redis.RedisCache;
import io.ebeaninternal.server.cache.DefaultServerCache;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class DuelCache
implements ServerCache,
NearCacheInvalidate {
    private final DefaultServerCache near;
    private final RedisCache remote;
    private final NearCacheNotify cacheNotify;
    private final String cacheKey;

    public DuelCache(DefaultServerCache near, RedisCache remote, String cacheKey, NearCacheNotify cacheNotify) {
        this.near = near;
        this.remote = remote;
        this.cacheKey = cacheKey;
        this.cacheNotify = cacheNotify;
    }

    public void visit(MetricVisitor visitor) {
        this.near.visit(visitor);
        this.remote.visit(visitor);
    }

    @Override
    public void invalidateKeys(Set<Object> keySet) {
        this.near.removeAll(keySet);
    }

    @Override
    public void invalidateKey(Object id) {
        this.near.remove(id);
    }

    @Override
    public void invalidateClear() {
        this.near.clear();
    }

    public Map<Object, Object> getAll(Set<Object> keys) {
        Map<Object, Object> remoteMap;
        Map resultMap = this.near.getAll(keys);
        Set localKeys = resultMap.keySet();
        HashSet<Object> remainingKeys = new HashSet<Object>();
        for (Object key : keys) {
            if (localKeys.contains(key)) continue;
            remainingKeys.add(key);
        }
        if (!remainingKeys.isEmpty() && !(remoteMap = this.remote.getAll(remainingKeys)).isEmpty()) {
            this.near.putAll(remoteMap);
            resultMap.putAll(remoteMap);
        }
        return resultMap;
    }

    public Object get(Object id) {
        Object val = this.near.get(id);
        if (val != null) {
            return val;
        }
        Object remoteVal = this.remote.get(id);
        if (remoteVal != null) {
            this.near.put(id, remoteVal);
        }
        return remoteVal;
    }

    public void putAll(Map<Object, Object> keyValues) {
        this.near.putAll(keyValues);
        this.remote.putAll(keyValues);
        this.cacheNotify.invalidateKeys(this.cacheKey, keyValues.keySet());
    }

    public void put(Object id, Object value) {
        this.near.put(id, value);
        this.remote.put(id, value);
        this.cacheNotify.invalidateKey(this.cacheKey, id);
    }

    public void removeAll(Set<Object> keys) {
        this.near.removeAll(keys);
        this.remote.removeAll(keys);
        this.cacheNotify.invalidateKeys(this.cacheKey, keys);
    }

    public void remove(Object id) {
        this.near.remove(id);
        this.remote.remove(id);
        this.cacheNotify.invalidateKey(this.cacheKey, id);
    }

    public void clear() {
        this.near.clear();
        this.remote.clear();
        this.cacheNotify.invalidateClear(this.cacheKey);
    }

    public long getNearHitCount() {
        return this.near.getHitCount();
    }

    public long getNearMissCount() {
        return this.near.getMissCount();
    }

    public long getRemoteHitCount() {
        return this.remote.getHitCount();
    }

    public long getRemoteMissCount() {
        return this.remote.getMissCount();
    }

    public int size() {
        return 0;
    }

    public int getHitRatio() {
        return 0;
    }

    public ServerCacheStatistics getStatistics(boolean reset) {
        return null;
    }
}

