/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.typequery;

import io.ebean.ExpressionList;
import io.ebean.FetchConfig;
import io.ebean.FetchGroup;
import io.ebean.typequery.TQProperty;
import io.ebean.typequery.TQRootBean;
import io.ebeaninternal.api.SpiQueryFetch;
import io.ebeaninternal.server.querydefn.OrmQueryDetail;
import io.ebeaninternal.server.querydefn.SpiFetchGroup;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class TQAssocBean<T, R>
extends TQProperty<R, Object> {
    private static final FetchConfig FETCH_DEFAULT = FetchConfig.ofDefault();
    private static final FetchConfig FETCH_QUERY = FetchConfig.ofQuery();
    private static final FetchConfig FETCH_LAZY = FetchConfig.ofLazy();
    private static final FetchConfig FETCH_CACHE = FetchConfig.ofCache();

    public TQAssocBean(String name, R root) {
        this(name, root, null);
    }

    public TQAssocBean(String name, R root, String prefix) {
        super(name, root, prefix);
    }

    public final R fetch() {
        ((TQRootBean)this._root).query().fetch(this._name);
        return (R)this._root;
    }

    public final R fetchQuery() {
        ((TQRootBean)this._root).query().fetchQuery(this._name);
        return (R)this._root;
    }

    public final R fetchCache() {
        ((TQRootBean)this._root).query().fetchCache(this._name);
        return (R)this._root;
    }

    public final R fetchLazy() {
        ((TQRootBean)this._root).query().fetchLazy(this._name);
        return (R)this._root;
    }

    public final R fetch(String properties) {
        ((TQRootBean)this._root).query().fetch(this._name, properties);
        return (R)this._root;
    }

    public final R fetchQuery(String properties) {
        ((TQRootBean)this._root).query().fetchQuery(this._name, properties);
        return (R)this._root;
    }

    public final R fetchCache(String properties) {
        ((TQRootBean)this._root).query().fetchCache(this._name, properties);
        return (R)this._root;
    }

    @Deprecated
    public final R fetchAll() {
        return this.fetch();
    }

    @SafeVarargs
    protected final R fetchProperties(TQProperty<?, ?> ... props) {
        return this.fetchWithProperties(FETCH_DEFAULT, props);
    }

    @SafeVarargs
    protected final R fetchQueryProperties(TQProperty<?, ?> ... props) {
        return this.fetchWithProperties(FETCH_QUERY, props);
    }

    @SafeVarargs
    protected final R fetchCacheProperties(TQProperty<?, ?> ... props) {
        return this.fetchWithProperties(FETCH_CACHE, props);
    }

    @SafeVarargs
    protected final R fetchLazyProperties(TQProperty<?, ?> ... props) {
        return this.fetchWithProperties(FETCH_LAZY, props);
    }

    @SafeVarargs
    private R fetchWithProperties(FetchConfig config, TQProperty<?, ?> ... props) {
        this.spiQuery().fetchProperties(this._name, this.properties(props), config);
        return (R)this._root;
    }

    public final R fetch(FetchGroup<T> nestedGroup) {
        return this.fetchNested(nestedGroup, FETCH_DEFAULT);
    }

    public final R fetchQuery(FetchGroup<T> nestedGroup) {
        return this.fetchNested(nestedGroup, FETCH_QUERY);
    }

    public final R fetchCache(FetchGroup<T> nestedGroup) {
        return this.fetchNested(nestedGroup, FETCH_CACHE);
    }

    private R fetchNested(FetchGroup<T> nestedGroup, FetchConfig fetchConfig) {
        OrmQueryDetail nestedDetail = ((SpiFetchGroup)nestedGroup).underlying();
        this.spiQuery().addNested(this._name, nestedDetail, fetchConfig);
        return (R)this._root;
    }

    private SpiQueryFetch spiQuery() {
        return (SpiQueryFetch)((TQRootBean)this._root).query();
    }

    @SafeVarargs
    private Set<String> properties(TQProperty<?, ?> ... props) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (TQProperty<?, ?> prop : props) {
            set.add(prop.propertyName());
        }
        return set;
    }

    public final R eq(T other) {
        this.expr().eq(this._name, other);
        return (R)this._root;
    }

    public final R equalTo(T other) {
        return this.eq(other);
    }

    public final R ne(T other) {
        this.expr().ne(this._name, other);
        return (R)this._root;
    }

    public final R notEqualTo(T other) {
        return this.ne(other);
    }

    public final R filterMany(ExpressionList<T> filter) {
        ExpressionList expressionList = this.expr().filterMany(this._name);
        expressionList.addAll(filter);
        return (R)this._root;
    }

    public final R filterMany(String expressions, Object ... params) {
        this.expr().filterMany(this._name, expressions, params);
        return (R)this._root;
    }

    public final R isEmpty() {
        this.expr().isEmpty(this._name);
        return (R)this._root;
    }

    public final R isNotEmpty() {
        this.expr().isNotEmpty(this._name);
        return (R)this._root;
    }
}

