/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.sqlserver;

import io.ebean.config.dbplatform.AbstractDbEncrypt;
import io.ebean.config.dbplatform.DbEncryptFunction;

public class SqlServerDbEncrypt
extends AbstractDbEncrypt {
    public SqlServerDbEncrypt() {
        this.varcharEncryptFunction = new VarcharFunction();
        this.dateEncryptFunction = new DateFunction();
    }

    public boolean isBindEncryptDataFirst() {
        return false;
    }

    private static class DateFunction
    implements DbEncryptFunction {
        private DateFunction() {
        }

        public String getDecryptSql(String columnWithTableAlias) {
            return "cast(convert(nvarchar,DecryptByPassPhrase(?," + columnWithTableAlias + ")) as date)";
        }

        public String getEncryptBindSql() {
            return "EncryptByPassPhrase(?,format(?,'yyyy-MM-dd'))";
        }
    }

    private static class VarcharFunction
    implements DbEncryptFunction {
        private VarcharFunction() {
        }

        public String getDecryptSql(String columnWithTableAlias) {
            return "convert(nvarchar,DecryptByPassPhrase(?," + columnWithTableAlias + "))";
        }

        public String getEncryptBindSql() {
            return "EncryptByPassPhrase(?,?)";
        }
    }
}

