/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.postgres;

import io.ebean.annotation.Platform;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DatabasePlatformProvider;
import io.ebean.platform.cockroach.CockroachPlatform;
import io.ebean.platform.postgres.Postgres9Platform;
import io.ebean.platform.postgres.PostgresPlatform;
import io.ebean.platform.yugabyte.YugabytePlatform;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import javax.persistence.PersistenceException;

public class PostgresPlatformProvider
implements DatabasePlatformProvider {
    public String toString() {
        return "Postgres,Cockroach,Yugabyte";
    }

    public boolean match(String name) {
        return name.startsWith("postgres") || name.equals("cockroach") || name.equals("yugabyte");
    }

    public DatabasePlatform create(String name) {
        switch (name) {
            case "postgres9": {
                return new Postgres9Platform();
            }
            case "postgres": {
                return new PostgresPlatform();
            }
            case "cockroach": {
                return new CockroachPlatform();
            }
            case "yugabyte": {
                return new YugabytePlatform();
            }
        }
        throw new IllegalArgumentException("Unknown platform name " + name);
    }

    public boolean matchByProductName(String productName) {
        return productName.contains("postgres");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabasePlatform create(int majorVersion, int minorVersion, DatabaseMetaData meta, Connection connection) {
        try {
            String productVersion = meta.getDatabaseProductVersion().toLowerCase(Locale.ENGLISH);
            if (productVersion.contains("-yb-")) {
                return new YugabytePlatform();
            }
            try (PreparedStatement statement = connection.prepareStatement("select version() as \"version\"");
                 ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next() && (productVersion = resultSet.getString("version").toLowerCase()).contains("cockroach")) {
                    CockroachPlatform cockroachPlatform = new CockroachPlatform();
                    return cockroachPlatform;
                }
            }
            finally {
                if (!connection.getAutoCommit()) {
                    connection.rollback();
                }
            }
            if (majorVersion > 9) return new PostgresPlatform();
            return new Postgres9Platform();
        }
        catch (SQLException e) {
            throw new PersistenceException("Error trying to determine postgres platform via JDBC metadata", (Throwable)e);
        }
    }

    public boolean matchPlatform(Platform platform) {
        switch (platform) {
            case POSTGRES: 
            case POSTGRES9: 
            case COCKROACH: 
            case YUGABYTE: {
                return true;
            }
        }
        return false;
    }

    public DatabasePlatform create(Platform platform) {
        switch (platform) {
            case POSTGRES: {
                return new PostgresPlatform();
            }
            case POSTGRES9: {
                return new Postgres9Platform();
            }
            case COCKROACH: {
                return new CockroachPlatform();
            }
            case YUGABYTE: {
                return new YugabytePlatform();
            }
        }
        throw new IllegalArgumentException("Unknown platform " + platform);
    }
}

