/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.platform.db2;

import io.ebean.config.dbplatform.BasicSqlLimiter;

final class DB2RowNumberBasicLimiter
implements BasicSqlLimiter {
    DB2RowNumberBasicLimiter() {
    }

    public String limit(String dbSql, int firstRow, int maxRows) {
        if (firstRow < 1 && maxRows < 1) {
            return dbSql;
        }
        StringBuilder sb = new StringBuilder(120 + dbSql.length());
        int lastRow = maxRows;
        if (lastRow > 0) {
            lastRow += firstRow;
        }
        sb.append("select * from (select row_number() over() a.*, rn from (");
        sb.append(dbSql).append(") a ");
        if (lastRow > 0) {
            sb.append(" where rn <= ").append(lastRow);
        }
        sb.append(") ");
        if (firstRow > 0) {
            sb.append(" where rn_ > ").append(firstRow);
        }
        return sb.toString();
    }
}

