/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.avaje.applog.AppLog;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationException;
import io.ebean.migration.MigrationResource;
import io.ebean.migration.runner.DbNameUtil;
import io.ebean.migration.runner.LocalMigrationResource;
import io.ebean.migration.runner.LocalMigrationResources;
import io.ebean.migration.runner.MigrationPlatform;
import io.ebean.migration.runner.MigrationSchema;
import io.ebean.migration.runner.MigrationTable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class MigrationEngine {
    static final System.Logger log = AppLog.getLogger((String)"io.ebean.migration");
    private final MigrationConfig migrationConfig;
    private final boolean checkStateOnly;

    public MigrationEngine(MigrationConfig migrationConfig, boolean checkStateOnly) {
        this.migrationConfig = migrationConfig;
        this.checkStateOnly = checkStateOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MigrationResource> run(Connection connection) {
        try {
            List<MigrationResource> list;
            LocalMigrationResources resources = new LocalMigrationResources(this.migrationConfig);
            if (!resources.readResources() && !resources.readInitResources()) {
                log.log(System.Logger.Level.DEBUG, "no migrations to check");
                List<MigrationResource> list2 = Collections.emptyList();
                return list2;
            }
            long startMs = System.currentTimeMillis();
            connection.setAutoCommit(false);
            MigrationTable table = this.initialiseMigrationTable(connection);
            try {
                List<MigrationResource> result = this.runMigrations(resources.versions(), table, this.checkStateOnly);
                connection.commit();
                if (!this.checkStateOnly) {
                    long commitMs = System.currentTimeMillis();
                    log.log(System.Logger.Level.INFO, "DB migrations completed in {0}ms - executed:{1} totalMigrations:{2}", commitMs - startMs, table.count(), table.size());
                    int countNonTransactional = table.runNonTransactional();
                    if (countNonTransactional > 0) {
                        log.log(System.Logger.Level.INFO, "Non-transactional DB migrations completed in {0}ms - executed:{1}", System.currentTimeMillis() - commitMs, countNonTransactional);
                    }
                }
                list = result;
            }
            catch (Throwable throwable) {
                try {
                    table.unlockMigrationTable();
                    throw throwable;
                }
                catch (MigrationException e) {
                    this.rollback(connection);
                    throw e;
                }
                catch (Exception e) {
                    this.rollback(connection);
                    throw new MigrationException("Error running DB migrations", e);
                }
            }
            table.unlockMigrationTable();
            return list;
        }
        finally {
            this.close(connection);
        }
    }

    private MigrationTable initialiseMigrationTable(Connection connection) throws SQLException, IOException {
        MigrationPlatform platform = this.derivePlatformName(this.migrationConfig, connection);
        new MigrationSchema(this.migrationConfig, connection).createAndSetIfNeeded();
        MigrationTable table = new MigrationTable(this.migrationConfig, connection, this.checkStateOnly, platform);
        table.createIfNeededAndLock();
        return table;
    }

    private List<MigrationResource> runMigrations(List<LocalMigrationResource> localVersions, MigrationTable table, boolean checkStateMode) throws SQLException {
        LocalMigrationResource initVersion;
        if (table.isEmpty() && (initVersion = this.getInitVersion()) != null) {
            log.log(System.Logger.Level.INFO, "dbinit migration version:{0}  local migrations:{1}  checkState:{2}", initVersion, localVersions.size(), checkStateMode);
            return table.runInit(initVersion, localVersions);
        }
        return table.runAll(localVersions);
    }

    private LocalMigrationResource getInitVersion() {
        List<LocalMigrationResource> initVersions;
        LocalMigrationResources initResources = new LocalMigrationResources(this.migrationConfig);
        if (initResources.readInitResources() && !(initVersions = initResources.versions()).isEmpty()) {
            return initVersions.get(initVersions.size() - 1);
        }
        return null;
    }

    private MigrationPlatform derivePlatformName(MigrationConfig migrationConfig, Connection connection) {
        String platform = migrationConfig.getPlatform();
        if (platform != null) {
            return DbNameUtil.platform(platform);
        }
        String derivedPlatformName = DbNameUtil.normalise(connection);
        migrationConfig.setPlatform(derivedPlatformName);
        return DbNameUtil.platform(derivedPlatformName);
    }

    private void close(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Error closing connection", (Throwable)e);
        }
    }

    private void rollback(Connection connection) {
        try {
            if (connection != null) {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            log.log(System.Logger.Level.WARNING, "Error on connection rollback", (Throwable)e);
        }
    }
}

