/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.avaje.applog.AppLog;
import io.ebean.migration.MigrationConfig;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class MigrationSchema {
    static final System.Logger log = AppLog.getLogger((String)"io.ebean.migration");
    private final Connection connection;
    private final String dbSchema;
    private final boolean createSchemaIfNotExists;
    private final boolean setCurrentSchema;

    public MigrationSchema(MigrationConfig migrationConfig, Connection connection) {
        this.dbSchema = this.trim(migrationConfig.getDbSchema());
        this.createSchemaIfNotExists = migrationConfig.isCreateSchemaIfNotExists();
        this.setCurrentSchema = migrationConfig.isSetCurrentSchema();
        this.connection = connection;
    }

    private String trim(String dbSchema) {
        return dbSchema == null ? null : dbSchema.trim();
    }

    public void createAndSetIfNeeded() throws SQLException {
        if (this.dbSchema != null) {
            log.log(System.Logger.Level.INFO, "Migration Schema: {0}", this.dbSchema);
            if (this.createSchemaIfNotExists) {
                this.createSchemaIfNeeded();
            }
            if (this.setCurrentSchema) {
                this.setSchema();
            }
        }
    }

    private void createSchemaIfNeeded() throws SQLException {
        if (!this.schemaExists()) {
            log.log(System.Logger.Level.INFO, "Creating Schema: {0}", this.dbSchema);
            try (Statement query = this.connection.createStatement();){
                query.executeUpdate("CREATE SCHEMA " + this.dbSchema);
            }
        }
    }

    private boolean schemaExists() throws SQLException {
        try (ResultSet schemas = this.connection.getMetaData().getSchemas();){
            while (schemas.next()) {
                String schema = schemas.getString(1);
                if (!schema.equalsIgnoreCase(this.dbSchema)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private void setSchema() throws SQLException {
        log.log(System.Logger.Level.INFO, "Setting Schema: {0}", this.dbSchema);
        this.connection.setSchema(this.dbSchema);
    }
}

