/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.avaje.classpath.scanner.Resource;
import io.ebean.migration.MigrationVersion;
import io.ebean.migration.runner.LocalMigrationResource;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;

public class LocalDdlMigrationResource
extends LocalMigrationResource {
    private final Resource resource;

    public LocalDdlMigrationResource(MigrationVersion version, String location, Resource resource) {
        super(version, location);
        this.resource = resource;
    }

    @Override
    @Nonnull
    public String getContent() {
        try {
            return this.resource.loadAsString(StandardCharsets.UTF_8);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException(this.missingOpensMessage(), e);
        }
    }

    public List<String> lines() {
        try {
            return this.resource.loadAsLines(StandardCharsets.UTF_8);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException(this.missingOpensMessage(), e);
        }
    }

    private String missingOpensMessage() {
        return "NPE reading DB migration content at [" + this.location + "] Probably missing an 'opens dbmigration;' in module-info.java";
    }
}

