/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.runner;

import io.avaje.classpath.scanner.Resource;
import io.avaje.classpath.scanner.core.Scanner;
import io.ebean.migration.JdbcMigration;
import io.ebean.migration.MigrationConfig;
import io.ebean.migration.MigrationVersion;
import io.ebean.migration.runner.LocalDdlMigrationResource;
import io.ebean.migration.runner.LocalJdbcMigrationResource;
import io.ebean.migration.runner.LocalMigrationResource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMigrationResources {
    private static final Logger log = LoggerFactory.getLogger((String)"io.ebean.migration");
    private final List<LocalMigrationResource> versions = new ArrayList<LocalMigrationResource>();
    private final MigrationConfig migrationConfig;
    private final ClassLoader classLoader;
    private final boolean searchForJdbcMigrations;

    public LocalMigrationResources(MigrationConfig migrationConfig) {
        this.migrationConfig = migrationConfig;
        this.classLoader = migrationConfig.getClassLoader();
        this.searchForJdbcMigrations = migrationConfig.getJdbcMigrationFactory() != null;
    }

    public boolean readInitResources() {
        return this.readResourcesForPath(this.migrationConfig.getMigrationInitPath());
    }

    public boolean readResources() {
        return this.readResourcesForPath(this.migrationConfig.getMigrationPath());
    }

    private boolean readResourcesForPath(String path) {
        String basePlatform = this.migrationConfig.getBasePlatform();
        if (basePlatform != null && this.loadedFrom(path, basePlatform)) {
            return true;
        }
        String platform = this.migrationConfig.getPlatform();
        if (platform != null && this.loadedFrom(path, platform)) {
            return true;
        }
        this.addResources(this.scanForBoth(path));
        Collections.sort(this.versions);
        return !this.versions.isEmpty();
    }

    private boolean loadedFrom(String path, String platform) {
        this.addResources(this.scanForBoth(path + "/" + platform));
        if (this.versions.isEmpty()) {
            return false;
        }
        log.debug("platform migrations for {}", (Object)platform);
        if (this.searchForJdbcMigrations) {
            this.addResources(this.scanForJdbcOnly(path));
        }
        Collections.sort(this.versions);
        return true;
    }

    private List<Resource> scanForJdbcOnly(String path) {
        return new Scanner(this.classLoader).scanForResources(path, (Predicate)new JdbcOnly());
    }

    private List<Resource> scanForBoth(String path) {
        return new Scanner(this.classLoader).scanForResources(path, (Predicate)new Match(this.searchForJdbcMigrations));
    }

    private void addResources(List<Resource> resourceList) {
        if (!resourceList.isEmpty()) {
            log.debug("resources: {}", resourceList);
        }
        for (Resource resource : resourceList) {
            String filename = resource.name();
            if (filename.endsWith(".sql")) {
                this.versions.add(this.createScriptMigration(resource, filename));
                continue;
            }
            if (!this.searchForJdbcMigrations || !filename.endsWith(".class")) continue;
            this.versions.add(this.createJdbcMigration(resource, filename));
        }
    }

    private LocalMigrationResource createJdbcMigration(Resource resource, String filename) {
        int pos = filename.lastIndexOf(".class");
        String mainName = filename.substring(0, pos);
        MigrationVersion migrationVersion = MigrationVersion.parse(mainName);
        String className = resource.location().replace('/', '.');
        className = className.substring(0, className.length() - 6);
        JdbcMigration instance = this.migrationConfig.getJdbcMigrationFactory().createInstance(className);
        return new LocalJdbcMigrationResource(migrationVersion, resource.location(), instance);
    }

    private LocalMigrationResource createScriptMigration(Resource resource, String filename) {
        int pos = filename.lastIndexOf(".sql");
        String mainName = filename.substring(0, pos);
        MigrationVersion migrationVersion = MigrationVersion.parse(mainName);
        return new LocalDdlMigrationResource(migrationVersion, resource.location(), resource);
    }

    @Nonnull
    public List<LocalMigrationResource> getVersions() {
        return this.versions;
    }

    private static class JdbcOnly
    implements Predicate<String> {
        private JdbcOnly() {
        }

        @Override
        public boolean test(String name) {
            return name.endsWith(".class") && !name.contains("$");
        }
    }

    private static class Match
    implements Predicate<String> {
        private final boolean searchJdbc;

        Match(boolean searchJdbc) {
            this.searchJdbc = searchJdbc;
        }

        @Override
        public boolean test(String name) {
            return name.endsWith(".sql") || this.searchJdbc && name.endsWith(".class") && !name.contains("$");
        }
    }
}

