/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration;

import io.ebean.migration.DbPlatformNames;
import io.ebean.migration.MigrationRunner;
import io.ebean.migration.runner.MigrationPlatform;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.Nonnull;

class DbNameUtil
implements DbPlatformNames {
    DbNameUtil() {
    }

    @Nonnull
    static String normalise(Connection connection) {
        try {
            String productName = connection.getMetaData().getDatabaseProductName().toLowerCase();
            if (productName.contains("postgres")) {
                return DbNameUtil.readPostgres(connection);
            }
            if (productName.contains("mysql")) {
                return "mysql";
            }
            if (productName.contains("oracle")) {
                return "oracle";
            }
            if (productName.contains("microsoft")) {
                return "sqlserver";
            }
            if (productName.contains("db2")) {
                return "db2";
            }
            if (productName.contains("h2")) {
                return "h2";
            }
            if (productName.contains("hsql")) {
                return "hsql";
            }
            if (productName.contains("sqlite")) {
                return "sqlite";
            }
            if (productName.contains("sql anywhere")) {
                return "sqlanywhere";
            }
            return "";
        }
        catch (SQLException e) {
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readPostgres(Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement("SELECT version() AS \"version\"");
             ResultSet resultSet = statement.executeQuery();){
            if (!resultSet.next()) return "postgres";
            String productVersion = resultSet.getString("version").toLowerCase();
            if (!productVersion.contains("cockroach")) return "postgres";
            String string = "cockroach";
            return string;
        }
        catch (SQLException e) {
            MigrationRunner.log.warn("Error running detection query on Postgres", (Throwable)e);
        }
        return "postgres";
    }

    @Nonnull
    static MigrationPlatform platform(String platformName) {
        switch (platformName) {
            case "postgres": {
                return new MigrationPlatform.Postgres();
            }
            case "sqlserver": {
                return new MigrationPlatform.SqlServer();
            }
            case "sqlite": 
            case "cockroach": {
                return new MigrationPlatform.NoLocking();
            }
        }
        return new MigrationPlatform();
    }
}

