/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration.ddl;

import io.ebean.migration.ddl.DdlAutoCommit;
import io.ebean.migration.ddl.DdlParser;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DdlRunner {
    protected static final Logger logger = LoggerFactory.getLogger((String)"io.ebean.DDL");
    private final DdlParser parser;
    private final String scriptName;
    private final boolean useAutoCommit;

    public DdlRunner(boolean useAutoCommit, String scriptName) {
        this(useAutoCommit, scriptName, DdlAutoCommit.NONE);
    }

    public DdlRunner(boolean useAutoCommit, String scriptName, String platformName) {
        this(useAutoCommit, scriptName, DdlAutoCommit.forPlatform(platformName));
    }

    public DdlRunner(boolean useAutoCommit, String scriptName, DdlAutoCommit ddlAutoCommit) {
        this.useAutoCommit = useAutoCommit || ddlAutoCommit.isAutoCommit();
        this.scriptName = scriptName;
        this.parser = new DdlParser(this.useAutoCommit ? DdlAutoCommit.NONE : ddlAutoCommit);
    }

    public List<String> runAll(String content, Connection connection) throws SQLException {
        List<String> statements = this.parser.parse(new StringReader(content));
        this.runStatements(statements, connection);
        return this.parser.getNonTransactional();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStatements(List<String> statements, Connection connection) throws SQLException {
        boolean setAutoCommit;
        ArrayList<String> noDuplicates = new ArrayList<String>();
        for (String statement : statements) {
            if (noDuplicates.contains(statement)) continue;
            noDuplicates.add(statement);
        }
        if (noDuplicates.isEmpty()) {
            return;
        }
        boolean bl = setAutoCommit = this.useAutoCommit && !connection.getAutoCommit();
        if (setAutoCommit) {
            connection.setAutoCommit(true);
        }
        try {
            logger.info("Executing {} - {} statements, autoCommit:{}", new Object[]{this.scriptName, noDuplicates.size(), this.useAutoCommit});
            for (int i = 0; i < noDuplicates.size(); ++i) {
                String xOfy = i + 1 + " of " + noDuplicates.size();
                String ddl = (String)noDuplicates.get(i);
                this.runStatement(xOfy, ddl, connection);
            }
        }
        finally {
            if (setAutoCommit) {
                connection.setAutoCommit(false);
            }
        }
    }

    private void runStatement(String oneOf, String stmt, Connection c) throws SQLException {
        if ((stmt = stmt.trim()).endsWith(";")) {
            stmt = stmt.substring(0, stmt.length() - 1);
        } else if (stmt.endsWith("/")) {
            stmt = stmt.substring(0, stmt.length() - 1);
        }
        if (stmt.isEmpty()) {
            logger.debug("skip empty statement at " + oneOf);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("executing " + oneOf + " " + this.getSummary(stmt));
        }
        try (PreparedStatement statement = c.prepareStatement(stmt);){
            statement.execute();
        }
        catch (SQLException e) {
            if (this.useAutoCommit) {
                logger.debug(" ... ignoring error executing " + this.getSummary(stmt) + "  error: " + e.getMessage());
            }
            throw new SQLException("Error executing stmt[" + stmt + "] error[" + e.getMessage() + "]", e);
        }
    }

    private String getSummary(String s) {
        if (s.length() > 80) {
            return s.substring(0, 80).trim().replace('\n', ' ') + "...";
        }
        return s.replace('\n', ' ');
    }

    public int runNonTransactional(Connection connection) {
        List<String> nonTransactional = this.parser.getNonTransactional();
        return !nonTransactional.isEmpty() ? this.runNonTransactional(connection, nonTransactional) : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runNonTransactional(Connection connection, List<String> nonTransactional) {
        int count = 0;
        String sql = null;
        try {
            int i;
            logger.debug("running {} non-transactional migration statements", (Object)nonTransactional.size());
            connection.setAutoCommit(true);
            for (i = 0; i < nonTransactional.size(); ++i) {
                sql = nonTransactional.get(i);
                try (PreparedStatement statement = connection.prepareStatement(sql);){
                    logger.debug("executing - {}", (Object)sql);
                    statement.execute();
                    ++count;
                    continue;
                }
            }
            i = count;
            return i;
        }
        catch (SQLException e) {
            logger.error("Error running non-transaction migration: " + sql, (Throwable)e);
            int n = count;
            return n;
        }
        finally {
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException e) {
                logger.error("Error resetting connection autoCommit to false", (Throwable)e);
            }
        }
    }
}

