/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.joda.time;

import io.ebean.config.DatabaseConfig;
import io.ebean.config.JsonConfig;
import io.ebean.core.type.ExtraTypeFactory;
import io.ebean.core.type.ScalarType;
import io.ebean.joda.time.ScalarTypeJodaDateMidnight;
import io.ebean.joda.time.ScalarTypeJodaDateTime;
import io.ebean.joda.time.ScalarTypeJodaLocalDate;
import io.ebean.joda.time.ScalarTypeJodaLocalDateNative;
import io.ebean.joda.time.ScalarTypeJodaLocalDateTime;
import io.ebean.joda.time.ScalarTypeJodaLocalTime;
import io.ebean.joda.time.ScalarTypeJodaLocalTimeUTC;
import io.ebean.joda.time.ScalarTypeJodaPeriod;
import java.util.ArrayList;
import java.util.List;

public class JodaExtraTypeFactory
implements ExtraTypeFactory {
    public List<? extends ScalarType<?>> createTypes(DatabaseConfig config, Object objectMapper) {
        JsonConfig.DateTime jsonDateTime = config.getJsonDateTime();
        JsonConfig.Date jsonDate = config.getJsonDate();
        ArrayList<Object> types = new ArrayList<Object>();
        types.add((Object)new ScalarTypeJodaLocalDateTime(jsonDateTime));
        types.add((Object)new ScalarTypeJodaDateTime(jsonDateTime));
        if (config.getDatabasePlatform().supportsNativeJavaTime()) {
            types.add((Object)new ScalarTypeJodaLocalDateNative(jsonDate));
        } else {
            types.add((Object)new ScalarTypeJodaLocalDate(jsonDate));
        }
        types.add((Object)new ScalarTypeJodaDateMidnight(jsonDate));
        types.add((Object)new ScalarTypeJodaPeriod());
        String jodaLocalTimeMode = config.getJodaLocalTimeMode();
        if ("normal".equalsIgnoreCase(jodaLocalTimeMode)) {
            types.add((Object)new ScalarTypeJodaLocalTime());
        } else if ("utc".equalsIgnoreCase(jodaLocalTimeMode)) {
            types.add((Object)new ScalarTypeJodaLocalTimeUTC());
        }
        return types;
    }
}

