/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.NamingConvention;
import io.ebean.config.dbplatform.IdType;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.migration.Column;
import io.ebeaninternal.dbmigration.migration.CreateTable;
import io.ebeaninternal.dbmigration.model.MTableIdentity;
import io.ebeaninternal.server.deploy.IdentityMode;
import java.util.ArrayList;
import java.util.List;

final class BaseTableIdentity {
    private final PlatformDdl platformDdl;
    private final NamingConvention namingConvention;
    private final CreateTable createTable;
    private final List<Column> pk = new ArrayList<Column>(3);

    BaseTableIdentity(CreateTable createTable, PlatformDdl platformDdl, NamingConvention namingConvention) {
        this.platformDdl = platformDdl;
        this.namingConvention = namingConvention;
        this.createTable = createTable;
        this.init(createTable.getColumn());
    }

    private void init(List<Column> columns) {
        for (Column column : columns) {
            if (!Boolean.TRUE.equals(column.isPrimaryKey())) continue;
            this.pk.add(column);
        }
    }

    DdlIdentity identity() {
        if (this.pk.size() != 1) {
            return DdlIdentity.NONE;
        }
        IdentityMode identityMode = MTableIdentity.fromCreateTable(this.createTable);
        IdType idType = this.platformDdl.useIdentityType(identityMode.getIdType());
        String sequenceName = identityMode.getSequenceName();
        if (IdType.SEQUENCE == idType && (sequenceName == null || sequenceName.isEmpty())) {
            sequenceName = this.deriveSequenceName();
        }
        return new DdlIdentity(idType, identityMode, sequenceName);
    }

    private String deriveSequenceName() {
        String columnName = this.pk.size() == 1 ? this.pk.get(0).getName() : "";
        return this.namingConvention.getSequenceName(this.createTable.getName(), columnName);
    }

    boolean hasPrimaryKey() {
        return !this.pk.isEmpty();
    }

    List<Column> pkColumns() {
        String partitionColumn;
        if (this.createTable.getPartitionMode() != null && this.platformDdl.addPartitionColumnToPrimaryKey() && !this.pkContains(partitionColumn = this.createTable.getPartitionColumn())) {
            Column pc = new Column();
            pc.setName(partitionColumn);
            this.pk.add(pc);
        }
        return this.pk;
    }

    private boolean pkContains(String partitionColumn) {
        for (Column column : this.pk) {
            if (!column.getName().equals(partitionColumn)) continue;
            return true;
        }
        return false;
    }
}

