/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebeaninternal.dbmigration.ddlgeneration.DdlAlterTable;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseDdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BaseAlterTableWrite
implements DdlAlterTable {
    protected static final String RAW_OPERATION = "$RAW";
    protected final PlatformDdl platformDdl;
    private final String tableName;
    private final List<AlterCmd> cmds = new ArrayList<AlterCmd>();
    private boolean historyHandled;

    public BaseAlterTableWrite(String tableName, PlatformDdl platformDdl) {
        this.tableName = tableName;
        this.platformDdl = platformDdl;
    }

    public String tableName() {
        return this.tableName;
    }

    protected AlterCmd newRawCommand(String sql) {
        AlterCmd cmd = new AlterCmd(RAW_OPERATION, null);
        cmd.alternationBuffer.append(sql);
        return cmd;
    }

    @Override
    public DdlBuffer append(String operation, String column) {
        AlterCmd cmd = new AlterCmd(operation, column);
        this.cmds.add(cmd);
        return cmd.alternationBuffer;
    }

    @Override
    public DdlBuffer raw(String sql) {
        AlterCmd cmd = this.newRawCommand(sql);
        this.cmds.add(cmd);
        return cmd.alternationBuffer;
    }

    protected List<AlterCmd> postProcessCommands(List<AlterCmd> cmds) {
        return cmds;
    }

    @Override
    public void write(Appendable target) throws IOException {
        for (AlterCmd cmd : this.postProcessCommands(Collections.unmodifiableList(this.cmds))) {
            cmd.write(target);
            target.append(";\n");
        }
    }

    @Override
    public boolean isHistoryHandled() {
        return this.historyHandled;
    }

    @Override
    public void setHistoryHandled() {
        this.historyHandled = true;
    }

    public class AlterCmd {
        private final String operation;
        private final String column;
        private final DdlBuffer alternationBuffer = new BaseDdlBuffer(){

            @Override
            public DdlBuffer endOfStatement() {
                throw new UnsupportedOperationException();
            }
        };

        protected AlterCmd(String operation, String column) {
            this.operation = operation;
            this.column = column;
        }

        public AlterCmd append(String content) {
            this.alternationBuffer.append(content);
            return this;
        }

        public String getOperation() {
            return this.operation;
        }

        public String getColumn() {
            return this.column;
        }

        public String getAlternation() {
            return this.alternationBuffer.getBuffer();
        }

        protected void write(Appendable target) throws IOException {
            if (this.operation.equals(BaseAlterTableWrite.RAW_OPERATION)) {
                target.append(this.getAlternation());
            } else {
                target.append("alter table ").append(BaseAlterTableWrite.this.platformDdl.quote(BaseAlterTableWrite.this.tableName)).append(' ').append(this.operation);
                if (this.column != null) {
                    target.append(' ').append(BaseAlterTableWrite.this.platformDdl.quote(this.column));
                }
                if (!this.getAlternation().isEmpty()) {
                    target.append(' ').append(this.getAlternation());
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            try {
                this.write(sb);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return sb.toString();
        }
    }
}

