/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebeaninternal.dbmigration.migration.CreateIndex;
import io.ebeaninternal.dbmigration.migration.DropIndex;
import io.ebeaninternal.dbmigration.model.ModelDiff;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MIndex {
    private final String tableName;
    private final String indexName;
    private String platforms;
    private List<String> columns = new ArrayList<String>();
    private boolean unique;
    private boolean concurrent;
    private String definition;

    public MIndex(String indexName, String tableName, String columnName) {
        this.tableName = tableName;
        this.indexName = indexName;
        this.columns.add(columnName);
    }

    public MIndex(String indexName, String tableName, String[] columnNames) {
        this.tableName = tableName;
        this.indexName = indexName;
        Collections.addAll(this.columns, columnNames);
    }

    public MIndex(String indexName, String tableName, String[] columnNames, String platforms, boolean unique, boolean concurrent, String definition) {
        this(indexName, tableName, columnNames);
        this.platforms = platforms;
        this.unique = unique;
        this.concurrent = concurrent;
        this.definition = this.emptyToNull(definition);
    }

    public MIndex(CreateIndex createIndex) {
        this.indexName = createIndex.getIndexName();
        this.tableName = createIndex.getTableName();
        this.columns = this.split(createIndex.getColumns());
        this.platforms = createIndex.getPlatforms();
        this.unique = Boolean.TRUE.equals(createIndex.isUnique());
        this.concurrent = Boolean.TRUE.equals(createIndex.isConcurrent());
        this.definition = this.emptyToNull(createIndex.getDefinition());
    }

    public String getKey() {
        return this.indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public CreateIndex createIndex() {
        CreateIndex create = new CreateIndex();
        create.setIndexName(this.indexName);
        create.setTableName(this.tableName);
        create.setColumns(this.join());
        create.setPlatforms(this.platforms);
        if (Boolean.TRUE.equals(this.unique)) {
            create.setUnique(Boolean.TRUE);
        }
        if (Boolean.TRUE.equals(this.concurrent)) {
            create.setConcurrent(Boolean.TRUE);
        }
        create.setDefinition(this.emptyToNull(this.definition));
        return create;
    }

    private String emptyToNull(String val) {
        if (val == null || val.isEmpty()) {
            return null;
        }
        return val;
    }

    public DropIndex dropIndex() {
        DropIndex dropIndex = new DropIndex();
        dropIndex.setIndexName(this.indexName);
        dropIndex.setTableName(this.tableName);
        dropIndex.setPlatforms(this.platforms);
        if (Boolean.TRUE.equals(this.concurrent)) {
            dropIndex.setConcurrent(Boolean.TRUE);
        }
        return dropIndex;
    }

    public void compare(ModelDiff modelDiff, MIndex newIndex) {
        if (this.changed(newIndex)) {
            modelDiff.addDropIndex(this.dropIndex());
            modelDiff.addCreateIndex(newIndex.createIndex());
        }
    }

    private boolean changed(MIndex newIndex) {
        if (!this.tableName.equals(newIndex.getTableName())) {
            return true;
        }
        if (this.unique != newIndex.unique) {
            return true;
        }
        if (!Objects.equals(this.definition, newIndex.definition)) {
            return true;
        }
        List<String> newColumns = newIndex.getColumns();
        if (this.columns.size() != newColumns.size()) {
            return true;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            if (this.columns.get(i).equals(newColumns.get(i))) continue;
            return true;
        }
        return false;
    }

    private List<String> split(String columns) {
        if (columns.isEmpty()) {
            return Collections.emptyList();
        }
        String[] cols = columns.split(",");
        ArrayList<String> colList = new ArrayList<String>(cols.length);
        Collections.addAll(colList, cols);
        return colList;
    }

    private String join() {
        StringBuilder sb = new StringBuilder(50);
        for (int i = 0; i < this.columns.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.columns.get(i));
        }
        return sb.toString();
    }
}

