/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.annotation.ConstraintMode;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.DbConstraintNaming;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbDefaultValue;
import io.ebean.config.dbplatform.DbIdentity;
import io.ebean.config.dbplatform.IdType;
import io.ebean.util.StringHelper;
import io.ebeaninternal.dbmigration.ddlgeneration.BaseDdlHandler;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlHandler;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlOptions;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlHelp;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.HistoryTableUpdate;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.NoHistorySupportDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.WriteCreateIndex;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.WriteForeignKey;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.util.PlatformTypeConverter;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.util.VowelRemover;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.Column;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.model.MTable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class PlatformDdl {
    protected final DatabasePlatform platform;
    protected PlatformHistoryDdl historyDdl = new NoHistorySupportDdl();
    private final PlatformTypeConverter typeConverter;
    private final DbIdentity dbIdentity;
    protected boolean inlineComments;
    protected String dropTableIfExists = "drop table if exists ";
    protected String dropTableCascade = "";
    protected String dropSequenceIfExists = "drop sequence if exists ";
    protected String foreignKeyOnDelete = "on delete";
    protected String foreignKeyOnUpdate = "on update";
    protected String identitySuffix = " auto_increment";
    protected String identityStartWith = "start with";
    protected String identityIncrementBy = "increment by";
    protected String identityCache = "cache";
    protected String sequenceStartWith = "start with";
    protected String sequenceIncrementBy = "increment by";
    protected String sequenceCache = "cache";
    protected String alterTableIfExists = "";
    protected String dropConstraintIfExists = "drop constraint if exists";
    protected String dropIndexIfExists = "drop index if exists ";
    protected String alterColumn = "alter column";
    protected String alterColumnSuffix = "";
    protected String dropUniqueConstraint = "drop constraint";
    protected String addConstraint = "add constraint";
    protected String addColumn = "add column";
    protected String addColumnSuffix = "";
    protected String columnSetType = "";
    protected String columnSetDefault = "set default";
    protected String columnDropDefault = "drop default";
    protected String columnSetNotnull = "set not null";
    protected String columnSetNull = "set null";
    protected String updateNullWithDefault = "update ${table} set ${column} = ${default} where ${column} is null";
    protected String createTable = "create table";
    protected String dropColumn = "drop column";
    protected String dropColumnSuffix = "";
    protected String addForeignKeySkipCheck = "";
    protected String uniqueIndex = "unique";
    protected String indexConcurrent = "";
    protected boolean inlineUniqueWhenNullable = true;
    protected DbConstraintNaming naming;
    protected boolean inlineForeignKeys;
    protected boolean includeStorageEngine;
    protected final DbDefaultValue dbDefaultValue;
    protected String fallbackArrayType = "varchar(1000)";

    public PlatformDdl(DatabasePlatform platform) {
        this.platform = platform;
        this.dbIdentity = platform.getDbIdentity();
        this.dbDefaultValue = platform.getDbDefaultValue();
        this.typeConverter = new PlatformTypeConverter(platform.getDbTypeMap());
    }

    public void configure(DatabaseConfig config) {
        this.historyDdl.configure(config, this);
        this.naming = config.getConstraintNaming();
    }

    public DdlHandler createDdlHandler(DatabaseConfig config) {
        return new BaseDdlHandler(config, this);
    }

    public IdType useIdentityType(IdType modelIdentity) {
        if (modelIdentity == null) {
            return this.dbIdentity.getIdType();
        }
        return this.identityType(modelIdentity, this.dbIdentity.getIdType(), this.dbIdentity.isSupportsSequence(), this.dbIdentity.isSupportsIdentity());
    }

    private IdType identityType(IdType modelIdentity, IdType platformIdType, boolean supportsSequence, boolean supportsIdentity) {
        switch (modelIdentity) {
            case GENERATOR: {
                return IdType.GENERATOR;
            }
            case EXTERNAL: {
                return IdType.EXTERNAL;
            }
            case SEQUENCE: {
                return supportsSequence ? IdType.SEQUENCE : platformIdType;
            }
            case IDENTITY: {
                return supportsIdentity ? IdType.IDENTITY : platformIdType;
            }
        }
        return platformIdType;
    }

    public String asIdentityColumn(String columnDefn, DdlIdentity identity) {
        return columnDefn + this.identitySuffix;
    }

    protected String asIdentityStandardOptions(String columnDefn, DdlIdentity identity) {
        StringBuilder sb = new StringBuilder(columnDefn.length() + 60);
        sb.append(columnDefn).append(identity.optionGenerated());
        sb.append(identity.identityOptions(this.identityStartWith, this.identityIncrementBy, this.identityCache));
        return sb.toString();
    }

    public boolean isInlineComments() {
        return this.inlineComments;
    }

    public boolean isIncludeStorageEngine() {
        return this.includeStorageEngine;
    }

    public boolean isInlineForeignKeys() {
        return this.inlineForeignKeys;
    }

    public String setLockTimeout(int lockTimeoutSeconds) {
        return null;
    }

    public void writeTableColumns(DdlBuffer apply, List<Column> columns, DdlIdentity identity) throws IOException {
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                apply.append(",");
            }
            apply.newLine();
            this.writeColumnDefinition(apply, columns.get(i), identity);
        }
        for (Column column : columns) {
            String checkConstraint = column.getCheckConstraint();
            if (!this.hasValue(checkConstraint) || !this.hasValue(checkConstraint = this.createCheckConstraint(this.maxConstraintName(column.getCheckConstraintName()), checkConstraint))) continue;
            apply.append(",").newLine();
            apply.append(checkConstraint);
        }
    }

    protected void writeColumnDefinition(DdlBuffer buffer, Column column, DdlIdentity identity) throws IOException {
        String defaultValue;
        String columnDefn = this.convert(column.getType());
        if (identity.useIdentity() && this.isTrue(column.isPrimaryKey())) {
            columnDefn = this.asIdentityColumn(columnDefn, identity);
        }
        buffer.append("  ");
        buffer.append(this.lowerColumnName(column.getName()), 29);
        buffer.append(columnDefn);
        if (!Boolean.TRUE.equals(column.isPrimaryKey()) && (defaultValue = this.convertDefaultValue(column.getDefaultValue())) != null) {
            buffer.append(" default ").append(defaultValue);
        }
        if (this.isTrue(column.isNotnull()) || this.isTrue(column.isPrimaryKey())) {
            this.writeColumnNotNull(buffer);
        }
    }

    protected void writeColumnNotNull(DdlBuffer buffer) throws IOException {
        buffer.append(" not null");
    }

    public String createCheckConstraint(String ckName, String checkConstraint) {
        return "  constraint " + ckName + " " + checkConstraint;
    }

    public String convertDefaultValue(String dbDefault) {
        return this.dbDefaultValue.convert(dbDefault);
    }

    public String alterTableDropForeignKey(String tableName, String fkName) {
        return "alter table " + this.alterTableIfExists + tableName + " " + this.dropConstraintIfExists + " " + this.maxConstraintName(fkName);
    }

    public String convert(String type) {
        if (type == null) {
            return null;
        }
        if (type.contains("[]")) {
            return this.convertArrayType(type);
        }
        return this.typeConverter.convert(type);
    }

    protected String convertArrayType(String logicalArrayType) {
        if (logicalArrayType.endsWith("]")) {
            return this.fallbackArrayType;
        }
        int colonPos = logicalArrayType.lastIndexOf(93);
        return "varchar" + logicalArrayType.substring(colonPos + 1);
    }

    public void createWithHistory(DdlWrite writer, MTable table) throws IOException {
        this.historyDdl.createWithHistory(writer, table);
    }

    public void dropHistoryTable(DdlWrite writer, DropHistoryTable dropHistoryTable) throws IOException {
        this.historyDdl.dropHistoryTable(writer, dropHistoryTable);
    }

    public void addHistoryTable(DdlWrite writer, AddHistoryTable addHistoryTable) throws IOException {
        this.historyDdl.addHistoryTable(writer, addHistoryTable);
    }

    public void regenerateHistoryTriggers(DdlWrite write, HistoryTableUpdate update) throws IOException {
        this.historyDdl.updateTriggers(write, update);
    }

    public String createSequence(String sequenceName, DdlIdentity identity) {
        StringBuilder sb = new StringBuilder("create sequence ");
        sb.append(sequenceName);
        sb.append(identity.sequenceOptions(this.sequenceStartWith, this.sequenceIncrementBy, this.sequenceCache));
        sb.append(";");
        return sb.toString();
    }

    public String dropSequence(String sequenceName) {
        return this.dropSequenceIfExists + sequenceName;
    }

    public String dropTable(String tableName) {
        return this.dropTableIfExists + tableName + this.dropTableCascade;
    }

    public String dropIndex(String indexName, String tableName) {
        return this.dropIndex(indexName, tableName, false);
    }

    public String dropIndex(String indexName, String tableName, boolean concurrent) {
        return this.dropIndexIfExists + this.maxConstraintName(indexName);
    }

    public String createIndex(WriteCreateIndex create) {
        if (create.useDefinition()) {
            return create.getDefinition();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("create ");
        if (create.isUnique()) {
            buffer.append(this.uniqueIndex).append(" ");
        }
        buffer.append("index ");
        if (create.isConcurrent()) {
            buffer.append(this.indexConcurrent);
        }
        buffer.append(this.maxConstraintName(create.getIndexName())).append(" on ").append(create.getTableName());
        this.appendColumns(create.getColumns(), buffer);
        return buffer.toString();
    }

    public String tableInlineForeignKey(WriteForeignKey request) {
        StringBuilder buffer = new StringBuilder(90);
        buffer.append("foreign key");
        this.appendColumns(request.cols(), buffer);
        buffer.append(" references ").append(this.lowerTableName(request.refTable()));
        this.appendColumns(request.refCols(), buffer);
        this.appendForeignKeySuffix(request, buffer);
        return buffer.toString();
    }

    public String alterTableAddForeignKey(DdlOptions options, WriteForeignKey request) {
        StringBuilder buffer = new StringBuilder(90);
        buffer.append("alter table ").append(this.lowerTableName(request.table())).append(" add constraint ").append(this.maxConstraintName(request.fkName())).append(" foreign key");
        this.appendColumns(request.cols(), buffer);
        buffer.append(" references ").append(this.lowerTableName(request.refTable()));
        this.appendColumns(request.refCols(), buffer);
        this.appendForeignKeySuffix(request, buffer);
        if (options.isForeignKeySkipCheck()) {
            buffer.append(this.addForeignKeySkipCheck);
        }
        return buffer.toString();
    }

    protected void appendForeignKeySuffix(WriteForeignKey request, StringBuilder buffer) {
        this.appendForeignKeyOnDelete(buffer, this.withDefault(request.onDelete()));
        this.appendForeignKeyOnUpdate(buffer, this.withDefault(request.onUpdate()));
    }

    protected ConstraintMode withDefault(ConstraintMode mode) {
        return mode == null ? ConstraintMode.RESTRICT : mode;
    }

    protected void appendForeignKeyOnDelete(StringBuilder buffer, ConstraintMode mode) {
        this.appendForeignKeyMode(buffer, this.foreignKeyOnDelete, mode);
    }

    protected void appendForeignKeyOnUpdate(StringBuilder buffer, ConstraintMode mode) {
        this.appendForeignKeyMode(buffer, this.foreignKeyOnUpdate, mode);
    }

    protected void appendForeignKeyMode(StringBuilder buffer, String onMode, ConstraintMode mode) {
        buffer.append(" ").append(onMode).append(" ").append(this.translate(mode));
    }

    protected String translate(ConstraintMode mode) {
        switch (mode) {
            case SET_NULL: {
                return "set null";
            }
            case SET_DEFAULT: {
                return "set default";
            }
            case RESTRICT: {
                return "restrict";
            }
            case CASCADE: {
                return "cascade";
            }
        }
        throw new IllegalStateException("Unknown mode " + mode);
    }

    public String alterTableDropUniqueConstraint(String tableName, String uniqueConstraintName) {
        return "alter table " + tableName + " " + this.dropUniqueConstraint + " " + this.maxConstraintName(uniqueConstraintName);
    }

    public String alterTableDropConstraint(String tableName, String constraintName) {
        return "alter table " + tableName + " " + this.dropConstraintIfExists + " " + this.maxConstraintName(constraintName);
    }

    public String alterTableAddUniqueConstraint(String tableName, String uqName, String[] columns, String[] nullableColumns) {
        StringBuilder buffer = new StringBuilder(90);
        buffer.append("alter table ").append(tableName).append(" add constraint ").append(this.maxConstraintName(uqName)).append(" unique ");
        this.appendColumns(columns, buffer);
        return buffer.toString();
    }

    public void alterTableAddColumn(DdlBuffer buffer, String tableName, Column column, boolean onHistoryTable, String defaultValue) throws IOException {
        String convertedType = this.convert(column.getType());
        buffer.append("alter table ").append(tableName).append(" ").append(this.addColumn).append(" ").append(column.getName()).append(" ").append(convertedType);
        if (!(defaultValue == null || onHistoryTable && this.isTrue(column.isHistoryExclude()))) {
            buffer.append(" default ");
            buffer.append(defaultValue);
        }
        if (!onHistoryTable) {
            String ddl;
            if (this.isTrue(column.isNotnull())) {
                this.writeColumnNotNull(buffer);
            }
            buffer.append(this.addColumnSuffix);
            buffer.endOfStatement();
            if (!StringHelper.isNull((String)column.getCheckConstraint()) && this.hasValue(ddl = this.alterTableAddCheckConstraint(tableName, column.getCheckConstraintName(), column.getCheckConstraint()))) {
                buffer.append(ddl).endOfStatement();
            }
        } else {
            buffer.append(this.addColumnSuffix);
            buffer.endOfStatement();
        }
    }

    public void alterTableDropColumn(DdlBuffer buffer, String tableName, String columnName) throws IOException {
        buffer.append("alter table ").append(tableName).append(" ").append(this.dropColumn).append(" ").append(columnName).append(this.dropColumnSuffix).endOfStatement();
    }

    public boolean isInlineUniqueWhenNullable() {
        return this.inlineUniqueWhenNullable;
    }

    public String alterColumnType(String tableName, String columnName, String type) {
        return "alter table " + tableName + " " + this.alterColumn + " " + columnName + " " + this.columnSetType + this.convert(type) + this.alterColumnSuffix;
    }

    public String alterColumnNotnull(String tableName, String columnName, boolean notnull) {
        String suffix = notnull ? this.columnSetNotnull : this.columnSetNull;
        return "alter table " + tableName + " " + this.alterColumn + " " + columnName + " " + suffix + this.alterColumnSuffix;
    }

    public String alterTableAddCheckConstraint(String tableName, String checkConstraintName, String checkConstraint) {
        return "alter table " + tableName + " " + this.addConstraint + " " + this.maxConstraintName(checkConstraintName) + " " + checkConstraint;
    }

    public String alterColumnDefaultValue(String tableName, String columnName, String defaultValue) {
        String suffix = DdlHelp.isDropDefault(defaultValue) ? this.columnDropDefault : this.columnSetDefault + " " + this.convertDefaultValue(defaultValue);
        return "alter table " + tableName + " " + this.alterColumn + " " + columnName + " " + suffix + this.alterColumnSuffix;
    }

    public String alterColumnBaseAttributes(AlterColumn alter) {
        return null;
    }

    protected void appendColumns(String[] columns, StringBuilder buffer) {
        buffer.append(" (");
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(this.lowerColumnName(columns[i].trim()));
        }
        buffer.append(")");
    }

    protected String lowerTableName(String name) {
        return this.naming.lowerTableName(name);
    }

    protected String lowerColumnName(String name) {
        return this.naming.lowerColumnName(name);
    }

    public DatabasePlatform getPlatform() {
        return this.platform;
    }

    public String getUpdateNullWithDefault() {
        return this.updateNullWithDefault;
    }

    protected boolean hasValue(String value) {
        return value != null && !value.trim().isEmpty();
    }

    protected boolean isTrue(Boolean value) {
        return Boolean.TRUE.equals(value);
    }

    public void inlineTableComment(DdlBuffer apply, String tableComment) throws IOException {
    }

    public void tableStorageEngine(DdlBuffer apply, String storageEngine) throws IOException {
    }

    public void addTableComment(DdlBuffer apply, String tableName, String tableComment) throws IOException {
        if (DdlHelp.isDropComment(tableComment)) {
            tableComment = "";
        }
        apply.append(String.format("comment on table %s is '%s'", tableName, tableComment)).endOfStatement();
    }

    public void addColumnComment(DdlBuffer apply, String table, String column, String comment) throws IOException {
        if (DdlHelp.isDropComment(comment)) {
            comment = "";
        }
        apply.append(String.format("comment on column %s.%s is '%s'", table, column, comment)).endOfStatement();
    }

    public void generateProlog(DdlWrite write) throws IOException {
    }

    public void generateEpilog(DdlWrite write) throws IOException {
    }

    protected String maxConstraintName(String name) {
        if (name.length() > this.platform.getMaxConstraintNameLength()) {
            int hash = name.hashCode() & Integer.MAX_VALUE;
            if ((name = VowelRemover.trim(name, 4)).length() > this.platform.getMaxConstraintNameLength()) {
                return name.substring(0, this.platform.getMaxConstraintNameLength() - 7) + "_" + Integer.toString(hash, 36);
            }
        }
        return name;
    }

    public void lockTables(DdlBuffer buffer, Collection<String> tables) throws IOException {
    }

    public void unlockTables(DdlBuffer buffer, Collection<String> tables) throws IOException {
    }

    public String getCreateTableCommandPrefix() {
        return this.createTable;
    }

    public boolean suppressPrimaryKeyOnPartition() {
        return false;
    }

    public void addTablePartition(DdlBuffer apply, String partitionMode, String partitionColumn) throws IOException {
    }
}

