/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.dbplatform.h2.H2HistoryTrigger;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTriggerBasedHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DbTriggerUpdate;
import io.ebeaninternal.dbmigration.model.MTable;
import java.io.IOException;

public class H2HistoryDdl
extends DbTriggerBasedHistoryDdl {
    private static final String TRIGGER_CLASS = H2HistoryTrigger.class.getName();

    H2HistoryDdl() {
        this.sysPeriodType = "timestamp";
        this.now = "now()";
        this.sysPeriodEndValue = "now()";
    }

    @Override
    protected void dropTriggers(DdlBuffer buffer, String baseTable) throws IOException {
        buffer.append("drop trigger ").append(this.updateTriggerName(baseTable)).endOfStatement();
    }

    @Override
    protected void createTriggers(DdlWrite writer, MTable table) throws IOException {
        String baseTableName = table.getName();
        DdlBuffer apply = writer.applyHistoryTrigger();
        this.addCreateTrigger(apply, this.updateTriggerName(baseTableName), baseTableName);
    }

    @Override
    protected void updateHistoryTriggers(DbTriggerUpdate update) throws IOException {
        this.recreateHistoryView(update);
        DdlBuffer buffer = update.historyTriggerBuffer();
        this.dropTriggers(buffer, update.getBaseTable());
        this.addCreateTrigger(buffer, this.updateTriggerName(update.getBaseTable()), update.getBaseTable());
    }

    private void addCreateTrigger(DdlBuffer apply, String triggerName, String baseTable) throws IOException {
        apply.append("create trigger ").append(triggerName).append(" before update,delete on ").append(baseTable).append(" for each row call \"" + TRIGGER_CLASS + "\";").newLine();
    }
}

