/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebean.migration.MigrationVersion;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlHelp;
import io.ebeaninternal.dbmigration.migration.AddColumn;
import io.ebeaninternal.dbmigration.migration.AddHistoryTable;
import io.ebeaninternal.dbmigration.migration.AddTableComment;
import io.ebeaninternal.dbmigration.migration.AddUniqueConstraint;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.AlterForeignKey;
import io.ebeaninternal.dbmigration.migration.AlterTable;
import io.ebeaninternal.dbmigration.migration.ChangeSet;
import io.ebeaninternal.dbmigration.migration.ChangeSetType;
import io.ebeaninternal.dbmigration.migration.CreateIndex;
import io.ebeaninternal.dbmigration.migration.CreateTable;
import io.ebeaninternal.dbmigration.migration.DropColumn;
import io.ebeaninternal.dbmigration.migration.DropHistoryTable;
import io.ebeaninternal.dbmigration.migration.DropIndex;
import io.ebeaninternal.dbmigration.migration.DropTable;
import io.ebeaninternal.dbmigration.migration.Migration;
import io.ebeaninternal.dbmigration.migration.RenameColumn;
import io.ebeaninternal.dbmigration.migration.Sql;
import io.ebeaninternal.dbmigration.model.MCompoundUniqueConstraint;
import io.ebeaninternal.dbmigration.model.MIndex;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.dbmigration.model.PendingDrops;
import io.ebeaninternal.server.deploy.TablespaceMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ModelContainer {
    private final Set<String> schemas = new TreeSet<String>();
    private final Map<String, MTable> tables = new LinkedHashMap<String, MTable>();
    private final Map<String, MIndex> indexes = new LinkedHashMap<String, MIndex>();
    private final PendingDrops pendingDrops = new PendingDrops();
    private final List<MTable> partitionedTables = new ArrayList<MTable>();

    public Set<String> getSchemas() {
        return this.schemas;
    }

    public boolean isTablePartitioning() {
        return !this.partitionedTables.isEmpty();
    }

    public List<MTable> getPartitionedTables() {
        return this.partitionedTables;
    }

    public void adjustDraftReferences() {
        for (MTable table : this.tables.values()) {
            if (!table.isDraft()) continue;
            table.adjustReferences(this);
        }
    }

    public Map<String, MTable> getTables() {
        return this.tables;
    }

    public MTable getTable(String tableName) {
        return this.tables.get(tableName);
    }

    public MIndex getIndex(MIndex newIndex) {
        return this.indexes.get(newIndex.getKey());
    }

    public Collection<MIndex> allIndexes() {
        return this.indexes.values();
    }

    public boolean dropIndex(MIndex existingIndex) {
        return !this.indexes.containsKey(existingIndex.getKey());
    }

    public void apply(Migration migration, MigrationVersion version) {
        List<ChangeSet> changeSets = migration.getChangeSet();
        for (ChangeSet changeSet : changeSets) {
            boolean pending;
            boolean bl = pending = changeSet.getType() == ChangeSetType.PENDING_DROPS;
            if (pending) {
                this.pendingDrops.add(version, changeSet);
            } else if (this.isDropsFor(changeSet)) {
                this.pendingDrops.appliedDropsFor(changeSet);
            }
            if (this.isDropsFor(changeSet)) continue;
            this.applyChangeSet(changeSet);
        }
    }

    private boolean isDropsFor(ChangeSet changeSet) {
        return changeSet.getDropsFor() != null;
    }

    protected void applyChangeSet(ChangeSet changeSet) {
        List<Object> changeSetChildren = changeSet.getChangeSetChildren();
        for (Object change : changeSetChildren) {
            if (change instanceof CreateTable) {
                this.applyChange((CreateTable)change);
                continue;
            }
            if (change instanceof DropTable) {
                this.applyChange((DropTable)change);
                continue;
            }
            if (change instanceof AlterTable) {
                this.applyChange((AlterTable)change);
                continue;
            }
            if (change instanceof AlterColumn) {
                this.applyChange((AlterColumn)change);
                continue;
            }
            if (change instanceof AddColumn) {
                this.applyChange((AddColumn)change);
                continue;
            }
            if (change instanceof DropColumn) {
                this.applyChange((DropColumn)change);
                continue;
            }
            if (change instanceof RenameColumn) {
                this.applyChange((RenameColumn)change);
                continue;
            }
            if (change instanceof CreateIndex) {
                this.applyChange((CreateIndex)change);
                continue;
            }
            if (change instanceof DropIndex) {
                this.applyChange((DropIndex)change);
                continue;
            }
            if (change instanceof AddHistoryTable) {
                this.applyChange((AddHistoryTable)change);
                continue;
            }
            if (change instanceof DropHistoryTable) {
                this.applyChange((DropHistoryTable)change);
                continue;
            }
            if (change instanceof AddUniqueConstraint) {
                this.applyChange((AddUniqueConstraint)change);
                continue;
            }
            if (change instanceof AlterForeignKey) {
                this.applyChange((AlterForeignKey)change);
                continue;
            }
            if (change instanceof AddTableComment) {
                this.applyChange((AddTableComment)change);
                continue;
            }
            if (change instanceof Sql) continue;
            throw new IllegalArgumentException("No rule for " + change);
        }
    }

    private void applyChange(AddHistoryTable change) {
        MTable table = this.tables.get(change.getBaseTable());
        if (table == null) {
            throw new IllegalStateException("Table [" + change.getBaseTable() + "] does not exist in model?");
        }
        table.setWithHistory(true);
    }

    protected void applyChange(DropHistoryTable change) {
        MTable table = this.tables.get(change.getBaseTable());
        if (table != null) {
            table.setWithHistory(false);
        }
    }

    private void applyChange(AddUniqueConstraint change) {
        MTable table = this.tables.get(change.getTableName());
        if (table == null) {
            throw new IllegalStateException("Table [" + change.getTableName() + "] does not exist in model?");
        }
        if (DdlHelp.isDropConstraint(change.getColumnNames())) {
            table.getUniqueConstraints().removeIf(constraint -> constraint.getName().equals(change.getConstraintName()));
        } else {
            table.getUniqueConstraints().add(new MCompoundUniqueConstraint(change));
        }
    }

    private void applyChange(AlterForeignKey change) {
        MTable table = this.tables.get(change.getTableName());
        if (table == null) {
            throw new IllegalStateException("Table [" + change.getName() + "] does not exist in model?");
        }
        if (DdlHelp.isDropForeignKey(change.getColumnNames())) {
            table.removeForeignKey(change.getName());
        } else {
            table.addForeignKey(change.getName(), change.getRefTableName(), change.getIndexName(), change.getColumnNames(), change.getRefColumnNames());
        }
    }

    private void applyChange(AddTableComment change) {
        MTable table = this.tables.get(change.getName());
        if (table == null) {
            throw new IllegalStateException("Table [" + change.getName() + "] does not exist in model?");
        }
        if (DdlHelp.isDropComment(change.getComment())) {
            table.setComment(null);
        } else {
            table.setComment(change.getComment());
        }
    }

    protected void applyChange(CreateTable createTable) {
        String tableName = createTable.getName();
        if (this.tables.containsKey(tableName)) {
            throw new IllegalStateException("Table [" + tableName + "] already exists in model?");
        }
        this.tables.put(tableName, new MTable(createTable));
    }

    protected void applyChange(DropTable dropTable) {
        this.tables.remove(dropTable.getName());
    }

    protected void applyChange(AlterTable alterTable) {
        MTable table = this.getTable(alterTable.getName());
        if (table == null) {
            throw new IllegalStateException("Table [" + alterTable.getName() + "] does not exist in model?");
        }
        TablespaceMeta ts = table.getTablespaceMeta();
        if (alterTable.getTablespace() != null) {
            String currentTableSpace = DdlHelp.toTablespace(alterTable.getTablespace());
            String currentIndexSpace = DdlHelp.toTablespace(alterTable.getIndexTablespace());
            String currentLobSpace = DdlHelp.toTablespace(alterTable.getLobTablespace());
            if (currentTableSpace != null) {
                assert (currentIndexSpace != null);
                assert (currentLobSpace != null);
                table.setTablespaceMeta(new TablespaceMeta(currentTableSpace, currentIndexSpace, currentLobSpace));
            } else {
                assert (currentIndexSpace == null);
                assert (currentLobSpace == null);
                table.setTablespaceMeta(null);
            }
        }
    }

    protected void applyChange(CreateIndex createIndex) {
        String indexName = createIndex.getIndexName();
        if (this.indexes.containsKey(indexName)) {
            throw new IllegalStateException("Index [" + indexName + "] already exists in model?");
        }
        MIndex index = new MIndex(createIndex);
        this.indexes.put(index.getKey(), index);
    }

    protected void applyChange(DropIndex dropIndex) {
        this.indexes.remove(dropIndex.getIndexName());
    }

    protected void applyChange(AddColumn addColumn) {
        MTable table = this.tables.get(addColumn.getTableName());
        if (table == null) {
            throw new IllegalStateException("Table [" + addColumn.getTableName() + "] does not exist in model?");
        }
        table.apply(addColumn);
    }

    protected void applyChange(AlterColumn alterColumn) {
        MTable table = this.tables.get(alterColumn.getTableName());
        if (table == null) {
            throw new IllegalStateException("Table [" + alterColumn.getTableName() + "] does not exist in model?");
        }
        table.apply(alterColumn);
    }

    protected void applyChange(DropColumn dropColumn) {
        MTable table = this.tables.get(dropColumn.getTableName());
        if (table == null) {
            throw new IllegalStateException("Table [" + dropColumn.getTableName() + "] does not exist in model?");
        }
        table.apply(dropColumn);
    }

    protected void applyChange(RenameColumn renameColumn) {
        MTable table = this.tables.get(renameColumn.getTableName());
        if (table == null) {
            throw new IllegalStateException("Table [" + renameColumn.getTableName() + "] does not exist in model?");
        }
        table.apply(renameColumn);
    }

    public MTable addTable(MTable table) {
        String schema;
        if (table.isPartitioned()) {
            this.partitionedTables.add(table);
        }
        if ((schema = table.getSchema()) != null) {
            this.schemas.add(schema);
        }
        return this.tables.put(table.getName(), table);
    }

    public void addTableElementCollection(MTable table) {
        MTable reusedElementCollection = this.tables.get(table.getName());
        if (reusedElementCollection != null) {
            MIndex index = reusedElementCollection.setReusedElementCollection();
            if (index != null) {
                this.indexes.put(index.getKey(), index);
            }
        } else {
            if (table.isPartitioned()) {
                this.partitionedTables.add(table);
            }
            this.tables.put(table.getName(), table);
        }
    }

    public void addIndex(MIndex index) {
        this.indexes.put(index.getKey(), index);
    }

    public List<String> getPendingDrops() {
        return this.pendingDrops.pendingDrops();
    }

    public Migration migrationForPendingDrop(String pendingVersion) {
        return this.pendingDrops.migrationForVersion(pendingVersion);
    }

    public void registerPendingHistoryDropColumns(ModelContainer newModel) {
        this.pendingDrops.registerPendingHistoryDropColumns(newModel);
    }

    public void registerPendingHistoryDropColumns(ChangeSet changeSet) {
        for (Object change : changeSet.getChangeSetChildren()) {
            if (!(change instanceof DropColumn)) continue;
            DropColumn dropColumn = (DropColumn)change;
            this.registerPendingDropColumn(dropColumn);
        }
    }

    private void registerPendingDropColumn(DropColumn dropColumn) {
        MTable table = this.getTable(dropColumn.getTableName());
        if (table == null) {
            throw new IllegalArgumentException("Table [" + dropColumn.getTableName() + "] not found?");
        }
        table.registerPendingDropColumn(dropColumn.getColumnName());
    }
}

