/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource;

import io.avaje.applog.AppLog;
import io.ebean.datasource.DataSourceConfig;
import io.ebean.datasource.InitDatabase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class PostgresInitDatabase
implements InitDatabase {
    private static final System.Logger log = AppLog.getLogger((String)"io.ebean.datasource");

    @Override
    public void run(Connection connection, DataSourceConfig config) throws SQLException {
        String username = config.getUsername();
        String password = config.getPassword();
        log.log(System.Logger.Level.INFO, "Creating schema and role for {0}", username);
        this.execute(connection, String.format("create schema if not exists %s", username));
        this.execute(connection, String.format("create role %s with login password '%s'", username, password));
        this.execute(connection, String.format("grant all on schema %s to %s", username, username));
    }

    private void execute(Connection connection, String sql) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.execute();
        }
    }
}

