/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource;

import io.ebean.datasource.DataSourceAlert;
import io.ebean.datasource.DataSourceConfig;
import io.ebean.datasource.DataSourcePool;
import io.ebean.datasource.DataSourcePoolListener;
import io.ebean.datasource.InitDatabase;
import java.sql.Driver;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.sql.DataSource;

public interface DataSourceBuilder {
    public static DataSourceBuilder create() {
        return new DataSourceConfig();
    }

    public static DataSourceBuilder from(Properties properties) {
        return DataSourceBuilder.create().load(properties);
    }

    public static DataSourceBuilder from(Properties properties, String prefix) {
        return DataSourceBuilder.create().load(properties, prefix);
    }

    public DataSourcePool build();

    public Settings settings();

    public DataSourceBuilder apply(Consumer<Settings> var1);

    default public DataSourceBuilder alsoIf(BooleanSupplier predicate, Consumer<Settings> apply) {
        if (predicate.getAsBoolean()) {
            this.apply(apply);
        }
        return this;
    }

    public DataSourceBuilder copy();

    public DataSourceBuilder setDefaults(DataSourceBuilder var1);

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setName(String var1);

    default public DataSourceBuilder name(String name) {
        return this.setName(name);
    }

    public DataSourceBuilder dataSource(DataSource var1);

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setApplicationName(String var1);

    default public DataSourceBuilder applicationName(String applicationName) {
        return this.setApplicationName(applicationName);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setClientInfo(Properties var1);

    default public DataSourceBuilder clientInfo(Properties clientInfo) {
        return this.setClientInfo(clientInfo);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setReadOnlyUrl(String var1);

    default public DataSourceBuilder readOnlyUrl(String readOnlyUrl) {
        return this.setReadOnlyUrl(readOnlyUrl);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setUrl(String var1);

    default public DataSourceBuilder url(String url) {
        return this.setUrl(url);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setUsername(String var1);

    default public DataSourceBuilder username(String username) {
        return this.setUsername(username);
    }

    @Deprecated
    public DataSourceBuilder setPassword(String var1);

    default public DataSourceBuilder password(String password) {
        return this.setPassword(password);
    }

    @Deprecated
    public DataSourceBuilder setPassword2(String var1);

    default public DataSourceBuilder password2(String password2) {
        return this.setPassword2(password2);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setSchema(String var1);

    default public DataSourceBuilder schema(String schema) {
        return this.setSchema(schema);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setDriver(String var1);

    default public DataSourceBuilder driver(String driverClassName) {
        return this.setDriver(driverClassName);
    }

    public DataSourceBuilder driver(Class<? extends Driver> var1);

    public DataSourceBuilder driver(Driver var1);

    default public DataSourceBuilder isolationLevel(int isolationLevel) {
        return this.setIsolationLevel(isolationLevel);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setIsolationLevel(int var1);

    default public DataSourceBuilder autoCommit(boolean autoCommit) {
        return this.setAutoCommit(autoCommit);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setAutoCommit(boolean var1);

    default public DataSourceBuilder readOnly(boolean readOnly) {
        return this.setReadOnly(readOnly);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setReadOnly(boolean var1);

    default public DataSourceBuilder minConnections(int minConnections) {
        return this.setMinConnections(minConnections);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setMinConnections(int var1);

    default public DataSourceBuilder maxConnections(int maxConnections) {
        return this.setMaxConnections(maxConnections);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setMaxConnections(int var1);

    default public DataSourceBuilder alert(DataSourceAlert alert) {
        return this.setAlert(alert);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setAlert(DataSourceAlert var1);

    default public DataSourceBuilder listener(DataSourcePoolListener listener) {
        return this.setListener(listener);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setListener(DataSourcePoolListener var1);

    default public DataSourceBuilder heartbeatSql(String heartbeatSql) {
        return this.setHeartbeatSql(heartbeatSql);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setHeartbeatSql(String var1);

    default public DataSourceBuilder heartbeatFreqSecs(int heartbeatFreqSecs) {
        return this.setHeartbeatFreqSecs(heartbeatFreqSecs);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setHeartbeatFreqSecs(int var1);

    default public DataSourceBuilder heartbeatTimeoutSeconds(int heartbeatTimeoutSeconds) {
        return this.setHeartbeatTimeoutSeconds(heartbeatTimeoutSeconds);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setHeartbeatTimeoutSeconds(int var1);

    default public DataSourceBuilder captureStackTrace(boolean captureStackTrace) {
        return this.setCaptureStackTrace(captureStackTrace);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setCaptureStackTrace(boolean var1);

    default public DataSourceBuilder maxStackTraceSize(int maxStackTraceSize) {
        return this.setMaxStackTraceSize(maxStackTraceSize);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setMaxStackTraceSize(int var1);

    default public DataSourceBuilder leakTimeMinutes(int leakTimeMinutes) {
        return this.setLeakTimeMinutes(leakTimeMinutes);
    }

    @Deprecated(forRemoval=true)
    public DataSourceBuilder setLeakTimeMinutes(int var1);

    default public DataSourceBuilder pstmtCacheSize(int pstmtCacheSize) {
        return this.setPstmtCacheSize(pstmtCacheSize);
    }

    @Deprecated
    public DataSourceBuilder setPstmtCacheSize(int var1);

    default public DataSourceBuilder cstmtCacheSize(int cstmtCacheSize) {
        return this.setCstmtCacheSize(cstmtCacheSize);
    }

    @Deprecated
    public DataSourceBuilder setCstmtCacheSize(int var1);

    default public DataSourceBuilder waitTimeoutMillis(int waitTimeoutMillis) {
        return this.setWaitTimeoutMillis(waitTimeoutMillis);
    }

    @Deprecated
    public DataSourceBuilder setWaitTimeoutMillis(int var1);

    default public DataSourceBuilder maxAgeMinutes(int maxAgeMinutes) {
        return this.setMaxAgeMinutes(maxAgeMinutes);
    }

    @Deprecated
    public DataSourceBuilder setMaxAgeMinutes(int var1);

    default public DataSourceBuilder maxInactiveTimeSecs(int maxInactiveTimeSecs) {
        return this.setMaxInactiveTimeSecs(maxInactiveTimeSecs);
    }

    @Deprecated
    public DataSourceBuilder setMaxInactiveTimeSecs(int var1);

    default public DataSourceBuilder trimPoolFreqSecs(int trimPoolFreqSecs) {
        return this.setTrimPoolFreqSecs(trimPoolFreqSecs);
    }

    @Deprecated
    public DataSourceBuilder setTrimPoolFreqSecs(int var1);

    default public DataSourceBuilder poolListener(String poolListener) {
        return this.setPoolListener(poolListener);
    }

    @Deprecated
    public DataSourceBuilder setPoolListener(String var1);

    default public DataSourceBuilder failOnStart(boolean failOnStart) {
        return this.setFailOnStart(failOnStart);
    }

    @Deprecated
    public DataSourceBuilder setFailOnStart(boolean var1);

    default public DataSourceBuilder offline(boolean offline) {
        return this.setOffline(offline);
    }

    @Deprecated
    public DataSourceBuilder setOffline(boolean var1);

    default public DataSourceBuilder initSql(List<String> initSql) {
        return this.setInitSql(initSql);
    }

    @Deprecated
    public DataSourceBuilder setInitSql(List<String> var1);

    default public DataSourceBuilder customProperties(Map<String, String> customProperties) {
        return this.setCustomProperties(customProperties);
    }

    @Deprecated
    public DataSourceBuilder setCustomProperties(Map<String, String> var1);

    public DataSourceBuilder addProperty(String var1, String var2);

    public DataSourceBuilder addProperty(String var1, boolean var2);

    public DataSourceBuilder addProperty(String var1, int var2);

    default public DataSourceBuilder ownerUsername(String ownerUsername) {
        return this.setOwnerUsername(ownerUsername);
    }

    @Deprecated
    public DataSourceBuilder setOwnerUsername(String var1);

    default public DataSourceBuilder ownerPassword(String ownerPassword) {
        return this.setOwnerPassword(ownerPassword);
    }

    @Deprecated
    public DataSourceBuilder setOwnerPassword(String var1);

    default public DataSourceBuilder platform(String platform) {
        return this.setPlatform(platform);
    }

    @Deprecated
    public DataSourceBuilder setPlatform(String var1);

    default public DataSourceBuilder initDatabase(InitDatabase initDatabase) {
        return this.setInitDatabase(initDatabase);
    }

    @Deprecated
    public DataSourceBuilder setInitDatabase(InitDatabase var1);

    default public DataSourceBuilder initDatabaseForPlatform(String platform) {
        return this.setInitDatabaseForPlatform(platform);
    }

    @Deprecated
    public DataSourceBuilder setInitDatabaseForPlatform(String var1);

    public DataSourceBuilder shutdownOnJvmExit(boolean var1);

    public DataSourceBuilder validateOnHeartbeat(boolean var1);

    @Deprecated(since="Experimental feature")
    public DataSourceBuilder lambdaMode(boolean var1);

    public DataSourceBuilder load(Properties var1);

    public DataSourceBuilder load(Properties var1, String var2);

    public DataSourceBuilder loadSettings(Properties var1, String var2);

    public static interface Settings
    extends DataSourceBuilder {
        public boolean isEmpty();

        public DataSource dataSource();

        public boolean isShutdownOnJvmExit();

        public boolean isValidateOnHeartbeat();

        public Properties connectionProperties();

        public String getApplicationName();

        public Properties getClientInfo();

        public String getReadOnlyUrl();

        public int getMaxAgeMinutes();

        public String getUrl();

        public String getUsername();

        public String getPassword();

        public String getPassword2();

        public String getSchema();

        public Driver driver();

        public Class<? extends Driver> driverClass();

        default public String driverClassName() {
            return this.getDriver();
        }

        @Deprecated(forRemoval=true)
        public String getDriver();

        public int getIsolationLevel();

        public boolean isAutoCommit();

        public boolean isReadOnly();

        public int getMinConnections();

        public int getMaxConnections();

        public DataSourceAlert getAlert();

        public DataSourcePoolListener getListener();

        public String getHeartbeatSql();

        public int getHeartbeatFreqSecs();

        public int getHeartbeatTimeoutSeconds();

        public boolean isCaptureStackTrace();

        public int getMaxStackTraceSize();

        public int getLeakTimeMinutes();

        public int getPstmtCacheSize();

        public int getCstmtCacheSize();

        public int getWaitTimeoutMillis();

        public int getMaxInactiveTimeSecs();

        public boolean isFailOnStart();

        public int getTrimPoolFreqSecs();

        public String getPoolListener();

        public boolean isOffline();

        public Map<String, String> getCustomProperties();

        public List<String> getInitSql();

        public String getOwnerUsername();

        public String getOwnerPassword();

        public String getPlatform();

        public InitDatabase getInitDatabase();

        public boolean useInitDatabase();
    }
}

