/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.PostgresHelper;
import io.ebean.core.type.ScalarType;
import io.ebean.text.TextException;
import io.ebean.text.json.EJson;
import io.ebeaninternal.json.ModifyAwareSet;
import io.ebeaninternal.server.type.ArrayElementConverter;
import io.ebeaninternal.server.type.ScalarTypeJsonCollection;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.PersistenceException;

final class ScalarTypeJsonSet {
    ScalarTypeJsonSet() {
    }

    static ScalarType<?> typeFor(boolean postgres, int dbType, DocPropertyType docPropertyType, boolean nullable, boolean keepSource) {
        if (postgres) {
            switch (dbType) {
                case 5002: {
                    return new JsonB(docPropertyType, nullable, keepSource);
                }
                case 5001: {
                    return new Json(docPropertyType, nullable, keepSource);
                }
            }
        }
        return new Varchar(docPropertyType, nullable, keepSource);
    }

    private static class PgBase
    extends Base {
        final String pgType;

        PgBase(int jdbcType, String pgType, DocPropertyType docPropertyType, boolean nullable, boolean keepSource) {
            super(jdbcType, docPropertyType, nullable, keepSource);
            this.pgType = pgType;
        }

        @Override
        protected final void bindRawJson(DataBinder binder, String rawJson) throws SQLException {
            binder.setObject(PostgresHelper.asObject((String)this.pgType, (String)rawJson));
        }

        @Override
        protected final void bindNull(DataBinder binder) throws SQLException {
            binder.setObject(PostgresHelper.asObject((String)this.pgType, (String)(this.nullable ? null : "[]")));
        }
    }

    private static abstract class Base
    extends ScalarTypeJsonCollection<Set> {
        final boolean keepSource;

        private Base(int dbType, DocPropertyType docPropertyType, boolean nullable, boolean keepSource) {
            super(Set.class, dbType, docPropertyType, nullable);
            this.keepSource = keepSource;
        }

        public final boolean jsonMapper() {
            return this.keepSource;
        }

        public final Set read(DataReader reader) throws SQLException {
            String json = reader.getString();
            if (this.keepSource) {
                reader.pushJson(json);
            }
            return this.readJsonConvert(json);
        }

        Set readJsonConvert(String json) {
            try {
                return EJson.parseSet((String)json, (boolean)true);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as Set", json, (Exception)e);
            }
        }

        public final void bind(DataBinder binder, Set value) throws SQLException {
            String rawJson;
            String string = rawJson = this.keepSource ? binder.popJson() : null;
            if (rawJson == null && value != null) {
                rawJson = this.formatValue(value);
            }
            if (value == null) {
                this.bindNull(binder);
            } else {
                this.bindRawJson(binder, rawJson);
            }
        }

        @Override
        protected void bindNull(DataBinder binder) throws SQLException {
            if (this.nullable) {
                binder.setNull(12);
            } else {
                binder.setString("[]");
            }
        }

        protected void bindRawJson(DataBinder binder, String rawJson) throws SQLException {
            binder.setString(rawJson);
        }

        public final String formatValue(Set value) {
            try {
                return EJson.write((Object)value);
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to format List into JSON content", (Throwable)e);
            }
        }

        public Set parse(String value) {
            try {
                return this.convertList(EJson.parseList((String)value));
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to parse JSON content as Set: " + value, (Throwable)e);
            }
        }

        public final Set jsonRead(JsonParser parser) throws IOException {
            return this.convertList(EJson.parseList((JsonParser)parser, (JsonToken)parser.getCurrentToken()));
        }

        public final void jsonWrite(JsonGenerator writer, Set value) throws IOException {
            EJson.write((Object)value, (JsonGenerator)writer);
        }

        private Set convertList(List list) {
            return new LinkedHashSet(list);
        }
    }

    private static final class JsonB
    extends PgBase {
        private JsonB(DocPropertyType docPropertyType, boolean nullable, boolean keepSource) {
            super(5002, "jsonb", docPropertyType, nullable, keepSource);
        }
    }

    private static final class Json
    extends PgBase {
        private Json(DocPropertyType docPropertyType, boolean nullable, boolean keepSource) {
            super(5001, "json", docPropertyType, nullable, keepSource);
        }
    }

    static final class Varchar
    extends Base {
        public Varchar(DocPropertyType docPropertyType, boolean nullable, boolean keepSource) {
            super(12, docPropertyType, nullable, keepSource);
        }
    }

    static final class VarcharWithConverter
    extends Base {
        private final ArrayElementConverter converter;

        VarcharWithConverter(DocPropertyType docType, boolean nullable, boolean keepSource, ArrayElementConverter converter) {
            super(12, docType, nullable, keepSource);
            this.converter = converter;
        }

        @Override
        Set readJsonConvert(String json) {
            try {
                return this.convertElements(EJson.parseSet((String)json, (boolean)false));
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as List", json, (Exception)e);
            }
        }

        private Set convertElements(Set<Object> rawSet) {
            if (rawSet == null) {
                return null;
            }
            LinkedHashSet result = new LinkedHashSet(rawSet.size());
            for (Object o : rawSet) {
                result.add(this.converter.fromSerialized(o));
            }
            return new ModifyAwareSet(result);
        }

        @Override
        public Set parse(String value) {
            try {
                return this.convertElements(EJson.parseSet((String)value, (boolean)false));
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to parse JSON content as Set: " + value, (Throwable)e);
            }
        }
    }
}

