/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.TimedMetric;
import io.ebean.metric.TimedMetricStats;
import io.ebeaninternal.server.query.CQueryPlan;

public final class CQueryPlanStats {
    private final CQueryPlan queryPlan;
    private final TimedMetric timedMetric;
    private boolean collected;
    private long lastQueryTime;
    private String reportName;

    CQueryPlanStats(CQueryPlan queryPlan) {
        this.queryPlan = queryPlan;
        this.timedMetric = queryPlan.createTimedMetric();
    }

    public boolean isEmpty() {
        return this.timedMetric.isEmpty();
    }

    public void add(long timeMicros) {
        this.timedMetric.add(timeMicros);
        this.lastQueryTime = System.currentTimeMillis();
    }

    public void reset() {
        this.timedMetric.reset();
    }

    long lastQueryTime() {
        return this.lastQueryTime;
    }

    Snapshot visit(MetricVisitor visitor) {
        TimedMetricStats collect = this.timedMetric.collect(visitor.reset());
        String name = this.reportName != null ? this.reportName : this.reportName(visitor);
        Snapshot snapshot = new Snapshot(name, this.collected, this.queryPlan, collect);
        this.collected = true;
        return snapshot;
    }

    String reportName(MetricVisitor visitor) {
        String tmp;
        this.reportName = tmp = (String)visitor.namingConvention().apply(this.queryPlan.name());
        return tmp;
    }

    static class Snapshot
    implements MetaQueryMetric {
        private final String name;
        private final boolean collected;
        private final CQueryPlan queryPlan;
        private final TimedMetricStats metrics;

        Snapshot(String name, boolean collected, CQueryPlan queryPlan, TimedMetricStats metrics) {
            this.name = name;
            this.collected = collected;
            this.queryPlan = queryPlan;
            this.metrics = metrics;
        }

        public String toString() {
            return "label:" + this.label() + " location:" + this.location() + " metrics:" + this.metrics + " sql:" + this.sql();
        }

        public Class<?> type() {
            return this.queryPlan.beanType();
        }

        public String label() {
            return this.queryPlan.label();
        }

        public String name() {
            return this.name;
        }

        public String location() {
            return this.queryPlan.location();
        }

        public long count() {
            return this.metrics.count();
        }

        public long total() {
            return this.metrics.total();
        }

        public long max() {
            return this.metrics.max();
        }

        public long mean() {
            return this.metrics.mean();
        }

        public String hash() {
            return this.queryPlan.hash();
        }

        public String sql() {
            return this.queryPlan.sql();
        }

        public boolean initialCollection() {
            return !this.collected;
        }
    }
}

