/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarTypeBase;
import io.ebean.text.TextException;
import io.ebeaninternal.api.CoreLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

final class ScalarTypeFile
extends ScalarTypeBase<File> {
    private final String prefix;
    private final String suffix;
    private final File directory;
    private final int bufferSize;

    ScalarTypeFile() {
        this(-4, "db-", null, null, 8096);
    }

    ScalarTypeFile(int jdbcType, String prefix, String suffix, File directory, int bufferSize) {
        super(File.class, false, jdbcType);
        this.prefix = prefix;
        this.suffix = suffix;
        this.directory = directory;
        this.bufferSize = bufferSize;
    }

    public boolean binary() {
        return true;
    }

    private InputStream getInputStream(File value) throws IOException {
        FileInputStream fi = new FileInputStream(value);
        return new BufferedInputStream(fi, this.bufferSize);
    }

    private OutputStream getOutputStream(File value) throws IOException {
        FileOutputStream fi = new FileOutputStream(value);
        return new BufferedOutputStream(fi, this.bufferSize);
    }

    public File read(DataReader reader) throws SQLException {
        InputStream is = reader.getBinaryStream();
        if (is == null) {
            return null;
        }
        try {
            File tempFile = File.createTempFile(this.prefix, this.suffix, this.directory);
            OutputStream os = this.getOutputStream(tempFile);
            this.pump(is, os);
            return tempFile;
        }
        catch (IOException e) {
            throw new SQLException("Error reading db file inputStream", e);
        }
    }

    public void bind(DataBinder binder, File value) throws SQLException {
        if (value == null) {
            binder.setNull(this.jdbcType);
        } else {
            try {
                InputStream fi = this.getInputStream(value);
                binder.setBinaryStream(fi, value.length());
            }
            catch (IOException e) {
                throw new SQLException("Error trying to set file inputStream", e);
            }
        }
    }

    public Object toJdbcType(Object value) {
        return value;
    }

    public File toBeanType(Object value) {
        return (File)value;
    }

    public void jsonWrite(JsonGenerator writer, File value) throws IOException {
        InputStream is = this.getInputStream(value);
        writer.writeBinary(is, (int)value.length());
    }

    public File jsonRead(JsonParser parser) throws IOException {
        File tempFile = File.createTempFile(this.prefix, this.suffix, this.directory);
        try (OutputStream os = this.getOutputStream(tempFile);){
            parser.readBinaryValue(os);
            os.flush();
        }
        return tempFile;
    }

    public DocPropertyType docType() {
        return DocPropertyType.BINARY;
    }

    public String formatValue(File file) {
        throw new TextException("Not supported");
    }

    public File parse(String value) {
        throw new TextException("Not supported");
    }

    public File readData(DataInput dataInput) throws IOException {
        return null;
    }

    public void writeData(DataOutput dataOutput, File file) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pump(InputStream is, OutputStream out) throws IOException {
        long totalBytes = 0L;
        BufferedInputStream input = null;
        OutputStream output = null;
        try {
            int length;
            input = new BufferedInputStream(is, this.bufferSize);
            output = new BufferedOutputStream(out, this.bufferSize);
            byte[] buffer = new byte[this.bufferSize];
            while ((length = ((InputStream)input).read(buffer)) > 0) {
                output.write(buffer, 0, length);
                totalBytes += (long)length;
            }
            output.flush();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    CoreLog.log.log(System.Logger.Level.ERROR, "Error when closing outputStream", (Throwable)e);
                }
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e) {
                    CoreLog.log.log(System.Logger.Level.ERROR, "Error when closing inputStream ", (Throwable)e);
                }
            }
        }
    }
}

