/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.ScalarTypeBaseVarchar;
import java.io.IOException;
import java.sql.SQLException;

final class ScalarTypeCharArray
extends ScalarTypeBaseVarchar<char[]> {
    ScalarTypeCharArray() {
        super(char[].class, false, 12);
    }

    public char[] convertFromDbString(String dbValue) {
        return dbValue.toCharArray();
    }

    public String convertToDbString(char[] beanValue) {
        return new String(beanValue);
    }

    public void bind(DataBinder binder, char[] value) throws SQLException {
        if (value == null) {
            binder.setNull(12);
        } else {
            String s = BasicTypeConverter.toString((Object)value);
            binder.setString(s);
        }
    }

    public char[] read(DataReader reader) throws SQLException {
        String string = reader.getString();
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toString((Object)value);
    }

    public char[] toBeanType(Object value) {
        if (value == null) {
            return null;
        }
        String s = BasicTypeConverter.toString((Object)value);
        return s.toCharArray();
    }

    public String formatValue(char[] t) {
        return String.valueOf(t);
    }

    public char[] parse(String value) {
        return value.toCharArray();
    }

    public char[] jsonRead(JsonParser parser) throws IOException {
        return parser.getValueAsString().toCharArray();
    }
}

