/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.type.DataEncryptSupport;
import io.ebeaninternal.server.type.ScalarTypeBytesBase;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public final class ScalarTypeBytesEncrypted
implements ScalarType<byte[]> {
    private final ScalarTypeBytesBase baseType;
    private final DataEncryptSupport dataEncryptSupport;

    public ScalarTypeBytesEncrypted(ScalarTypeBytesBase baseType, DataEncryptSupport dataEncryptSupport) {
        this.baseType = baseType;
        this.dataEncryptSupport = dataEncryptSupport;
    }

    public boolean binary() {
        return true;
    }

    public void bind(DataBinder binder, byte[] value) throws SQLException {
        value = this.dataEncryptSupport.encrypt(value);
        this.baseType.bind(binder, value);
    }

    public int jdbcType() {
        return this.baseType.jdbcType();
    }

    public int length() {
        return this.baseType.length();
    }

    public Class<byte[]> type() {
        return byte[].class;
    }

    public boolean jdbcNative() {
        return this.baseType.jdbcNative();
    }

    public void jsonWrite(JsonGenerator writer, byte[] value) throws IOException {
        writer.writeBinary(value);
    }

    public byte[] jsonRead(JsonParser parser) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(500);
        parser.readBinaryValue((OutputStream)out);
        return out.toByteArray();
    }

    public DocPropertyType docType() {
        return this.baseType.docType();
    }

    public String formatValue(byte[] v) {
        throw new RuntimeException("Not used");
    }

    public byte[] parse(String value) {
        return this.baseType.parse(value);
    }

    public byte[] read(DataReader reader) throws SQLException {
        byte[] data = (byte[])this.baseType.read(reader);
        data = this.dataEncryptSupport.decrypt(data);
        return data;
    }

    public byte[] toBeanType(Object value) {
        return this.baseType.toBeanType(value);
    }

    public Object toJdbcType(Object value) {
        return this.baseType.toJdbcType(value);
    }

    public byte[] readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        int len = dataInput.readInt();
        byte[] value = new byte[len];
        dataInput.readFully(value);
        return value;
    }

    public void writeData(DataOutput dataOutput, byte[] value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(value.length);
            dataOutput.write(value);
        }
    }
}

