/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebeaninternal.api.SpiDbQueryPlan;
import io.ebeaninternal.api.SpiQueryPlan;
import io.ebeaninternal.server.bind.capture.BindCapture;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class QueryPlanLogger {
    abstract SpiDbQueryPlan collectPlan(Connection var1, SpiQueryPlan var2, BindCapture var3);

    final SpiDbQueryPlan readQueryPlan(SpiQueryPlan plan, BindCapture bind, ResultSet rset) throws SQLException {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= rset.getMetaData().getColumnCount(); ++i) {
            sb.append(rset.getMetaData().getColumnLabel(i)).append("\t");
        }
        sb.setLength(sb.length() - 1);
        this.readPlanData(sb, rset);
        return this.createPlan(plan, bind.toString(), sb.toString());
    }

    final SpiDbQueryPlan createPlan(SpiQueryPlan plan, String bind, String planString) {
        return plan.createMeta(bind, planString);
    }

    final SpiDbQueryPlan readQueryPlanBasic(SpiQueryPlan plan, BindCapture bind, ResultSet rset) throws SQLException {
        StringBuilder sb = new StringBuilder();
        this.readPlanData(sb, rset);
        return this.createPlan(plan, bind.toString(), sb.toString().trim());
    }

    private void readPlanData(StringBuilder sb, ResultSet rset) throws SQLException {
        while (rset.next()) {
            sb.append('\n');
            for (int i = 1; i <= rset.getMetaData().getColumnCount(); ++i) {
                sb.append(rset.getString(i)).append("\t");
            }
            sb.setLength(sb.length() - 1);
        }
    }
}

