/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.meta.MetaQueryPlan;
import io.ebean.meta.QueryPlanRequest;
import io.ebeaninternal.server.query.CQueryBindCapture;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

final class CQueryPlanRequest {
    private final List<MetaQueryPlan> plans = new ArrayList<MetaQueryPlan>();
    private final Connection connection;
    private final long since;
    private final int maxCount;
    private final long maxTime;
    private final Iterator<CQueryBindCapture> iterator;

    CQueryPlanRequest(Connection connection, QueryPlanRequest req, Iterator<CQueryBindCapture> iterator) {
        this.connection = connection;
        this.iterator = iterator;
        this.maxCount = req.maxCount();
        long reqSince = req.since();
        this.since = reqSince == 0L ? Long.MAX_VALUE : reqSince;
        long maxTimeMillis = req.maxTimeMillis();
        this.maxTime = maxTimeMillis > 0L ? System.currentTimeMillis() + maxTimeMillis : 0L;
    }

    Connection connection() {
        return this.connection;
    }

    void add(MetaQueryPlan dbQueryPlan) {
        this.plans.add(dbQueryPlan);
    }

    long since() {
        return this.since;
    }

    List<MetaQueryPlan> plans() {
        return this.plans;
    }

    boolean hasNext() {
        return this.moreByCount() && this.moreByTime() && this.iterator.hasNext();
    }

    void nextCapture() {
        CQueryBindCapture next = this.iterator.next();
        if (next.collectQueryPlan(this)) {
            this.iterator.remove();
        }
    }

    private boolean moreByCount() {
        return this.maxCount == 0 || this.maxCount > this.plans.size();
    }

    private boolean moreByTime() {
        return this.maxTime == 0L || this.maxTime > System.currentTimeMillis();
    }
}

