/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.TimedMetric;
import io.ebean.metric.TimedMetricStats;
import io.ebeaninternal.server.profile.DProfileLocation;
import io.ebeaninternal.server.profile.TimedProfileLocation;

final class DTimedProfileLocation
extends DProfileLocation
implements TimedProfileLocation {
    private final String label;
    private final TimedMetric timedMetric;
    private final boolean overrideMetricName;
    private String fullName;
    private String reportName;

    DTimedProfileLocation(int lineNumber, String label, TimedMetric timedMetric) {
        super(lineNumber);
        this.label = label;
        this.timedMetric = timedMetric;
        this.overrideMetricName = "".equals(label);
    }

    @Override
    protected void initWith(String locationLabel) {
        if (this.overrideMetricName) {
            this.fullName = "txn.named." + locationLabel;
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public TimedMetric getMetric() {
        return this.timedMetric;
    }

    @Override
    public void add(long executionTime) {
        this.timedMetric.add(executionTime);
    }

    @Override
    public void visit(MetricVisitor visitor) {
        TimedMetricStats collect = this.timedMetric.collect(visitor.reset());
        if (collect != null) {
            String name = this.reportName != null ? this.reportName : this.reportName(visitor, collect.name());
            collect.setName(name);
            collect.setLocation(this.location());
            visitor.visitTimed((MetaTimedMetric)collect);
        }
    }

    private String reportName(MetricVisitor visitor, String name) {
        String tmp;
        String defaultName = this.overrideMetricName ? this.fullName : name;
        this.reportName = tmp = (String)visitor.namingConvention().apply(defaultName);
        return tmp;
    }
}

