/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.platform;

import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.bind.DataBind;
import io.ebeaninternal.server.persist.platform.MultiValueBind;
import java.sql.SQLException;
import java.util.Collection;

abstract class AbstractMultiValueBind
extends MultiValueBind {
    AbstractMultiValueBind() {
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public boolean isTypeSupported(int jdbcType) {
        return this.getArrayType(jdbcType) != null;
    }

    @Override
    public void bindMultiValues(DataBind dataBind, Collection<?> values, ScalarType<?> type, MultiValueBind.BindOne bindOne) throws SQLException {
        String arrayType = this.getArrayType(type.jdbcType());
        if (arrayType == null) {
            super.bindMultiValues(dataBind, values, type, bindOne);
        } else {
            dataBind.setArray(arrayType, this.toArray(values, type));
        }
    }

    String getArrayType(int dbType) {
        switch (dbType) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return "bigint";
            }
            case 6: 
            case 7: 
            case 8: {
                return "float";
            }
            case -7: 
            case 16: {
                return "bit";
            }
            case 91: {
                return "date";
            }
            case 93: 
            case 2013: 
            case 2014: 
            case 5009: {
                return "timestamp";
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: 
            case 5010: 
            case 5020: {
                return "varchar";
            }
        }
        return null;
    }
}

