/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebeaninternal.server.transaction.JdbcTransaction;
import io.ebeaninternal.server.transaction.TransactionManager;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import javax.transaction.UserTransaction;

public class JtaTransaction
extends JdbcTransaction {
    private final UserTransaction userTransaction;
    private final boolean newTransaction;
    private boolean committed;

    public JtaTransaction(String id, boolean explicit, UserTransaction utx, DataSource ds, TransactionManager manager) {
        super(id, explicit, null, manager);
        this.userTransaction = utx;
        try {
            boolean bl = this.newTransaction = this.userTransaction.getStatus() == 6;
            if (this.newTransaction) {
                this.userTransaction.begin();
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        try {
            this.connection = ds.getConnection();
            if (this.connection == null) {
                throw new PersistenceException("The DataSource returned a null connection.");
            }
            if (this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    @Override
    public void commit() {
        if (this.committed) {
            throw new PersistenceException("This transaction has already been committed.");
        }
        try {
            try {
                if (this.newTransaction) {
                    this.userTransaction.commit();
                }
                this.postCommit();
            }
            finally {
                this.close();
            }
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        this.committed = true;
    }

    @Override
    public void rollback() {
        this.rollback(null);
    }

    @Override
    public void rollback(Throwable e) {
        if (!this.committed) {
            try {
                try {
                    if (this.userTransaction != null) {
                        if (this.newTransaction) {
                            this.userTransaction.rollback();
                        } else {
                            this.userTransaction.setRollbackOnly();
                        }
                    }
                    this.postRollback(e);
                }
                finally {
                    this.closeConnection();
                }
            }
            catch (Exception ex) {
                throw new PersistenceException((Throwable)ex);
            }
        }
    }

    private void closeConnection() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }
}

