/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.bean.PersistenceContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public final class DefaultPersistenceContext
implements PersistenceContext {
    private final HashMap<Class<?>, ClassContext> typeCache = new HashMap();
    private final ReentrantLock lock = new ReentrantLock();
    private int putCount;

    public DefaultPersistenceContext() {
    }

    private DefaultPersistenceContext(DefaultPersistenceContext parent, boolean initial) {
        for (Map.Entry<Class<?>, ClassContext> entry : parent.typeCache.entrySet()) {
            this.typeCache.put(entry.getKey(), entry.getValue().copy(initial));
        }
    }

    public PersistenceContext forIterate() {
        return new DefaultPersistenceContext(this, true);
    }

    public PersistenceContext forIterateReset() {
        return new DefaultPersistenceContext(this, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetLimit() {
        this.lock.lock();
        try {
            if (this.putCount < 100) {
                boolean bl = false;
                return bl;
            }
            this.putCount = 0;
            for (ClassContext value : this.typeCache.values()) {
                if (!value.resetLimit()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Class<?> rootType, Object id, Object bean) {
        this.lock.lock();
        try {
            ++this.putCount;
            this.getClassContext(rootType).put(id, bean);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putIfAbsent(Class<?> rootType, Object id, Object bean) {
        this.lock.lock();
        try {
            ++this.putCount;
            Object object = this.getClassContext(rootType).putIfAbsent(id, bean);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Class<?> rootType, Object id) {
        this.lock.lock();
        try {
            Object object = this.getClassContext(rootType).get(id);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistenceContext.WithOption getWithOption(Class<?> rootType, Object id) {
        this.lock.lock();
        try {
            PersistenceContext.WithOption withOption = this.getClassContext(rootType).getWithOption(id);
            return withOption;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(Class<?> rootType) {
        this.lock.lock();
        try {
            ClassContext classMap = this.typeCache.get(rootType);
            int n = classMap == null ? 0 : classMap.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.lock.lock();
        try {
            this.typeCache.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear(Class<?> rootType) {
        this.lock.lock();
        try {
            ClassContext classMap = this.typeCache.get(rootType);
            if (classMap != null) {
                classMap.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleted(Class<?> rootType, Object id) {
        this.lock.lock();
        try {
            ClassContext classMap = this.typeCache.get(rootType);
            if (classMap != null && id != null) {
                classMap.deleted(id);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Class<?> rootType, Object id) {
        this.lock.lock();
        try {
            ClassContext classMap = this.typeCache.get(rootType);
            if (classMap != null && id != null) {
                classMap.remove(id);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        this.lock.lock();
        try {
            String string = this.typeCache.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private ClassContext getClassContext(Class<?> rootType) {
        return this.typeCache.computeIfAbsent(rootType, k -> new ClassContext());
    }

    private static class ClassContext {
        private final Map<Object, Object> map = new HashMap<Object, Object>();
        private Set<Object> deleteSet;
        private int initialSize;
        private ClassContext parent;

        private ClassContext() {
        }

        private ClassContext(ClassContext source, boolean initial) {
            if (initial || source.isTransfer()) {
                this.parent = source.transferParent();
                this.initialSize = this.parent.size();
                if (source.deleteSet != null) {
                    this.deleteSet = new HashSet<Object>(source.deleteSet);
                }
            }
        }

        private boolean isTransfer() {
            return this.map.isEmpty() && this.initialSize > 0;
        }

        private ClassContext transferParent() {
            return this.parent != null ? this.parent : this;
        }

        private ClassContext copy(boolean initial) {
            return new ClassContext(this, initial);
        }

        private boolean resetLimit() {
            return this.map.size() > 1000;
        }

        public String toString() {
            return "size:" + this.map.size();
        }

        private Object get(Object id) {
            Object bean = this.parent == null ? null : this.parent.get(id);
            return bean != null ? bean : this.map.get(id);
        }

        private PersistenceContext.WithOption getWithOption(Object id) {
            if (this.deleteSet != null && this.deleteSet.contains(id)) {
                return PersistenceContext.WithOption.DELETED;
            }
            Object bean = this.get(id);
            return bean == null ? null : new PersistenceContext.WithOption(bean);
        }

        private Object putIfAbsent(Object id, Object bean) {
            Object existingValue = this.get(id);
            if (existingValue != null) {
                return existingValue;
            }
            this.map.put(id, bean);
            return null;
        }

        private void put(Object id, Object b) {
            this.map.put(id, b);
        }

        private int size() {
            return this.map.size() + this.initialSize;
        }

        private void clear() {
            this.map.clear();
        }

        private void remove(Object id) {
            this.map.remove(id);
        }

        private void deleted(Object id) {
            if (this.deleteSet == null) {
                this.deleteSet = new HashSet<Object>();
            }
            this.deleteSet.add(id);
            this.map.remove(id);
        }
    }
}

