/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.Version;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.query.STreePropertyAssocMany;
import io.ebeaninternal.server.query.STreeType;
import io.ebeaninternal.server.query.SqlJoinType;
import io.ebeaninternal.server.query.SqlTreeNode;
import io.ebeaninternal.server.query.SqlTreeNodeBean;
import io.ebeaninternal.server.query.SqlTreeProperties;
import io.ebeaninternal.server.query.SqlTreeRoot;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;

final class SqlTreeNodeRoot
extends SqlTreeNodeBean
implements SqlTreeRoot {
    private final TableJoin includeJoin;
    private final boolean sqlDistinct;
    private final String baseTable;

    SqlTreeNodeRoot(STreeType desc, SqlTreeProperties props, List<SqlTreeNode> myList, boolean withId, TableJoin includeJoin, STreePropertyAssocMany many, SpiQuery.TemporalMode temporalMode, boolean disableLazyLoad, boolean sqlDistinct, String baseTable) {
        super(desc, props, myList, withId, many, temporalMode, disableLazyLoad);
        this.includeJoin = includeJoin;
        this.sqlDistinct = sqlDistinct;
        this.baseTable = baseTable;
    }

    @Override
    protected boolean isRoot() {
        return true;
    }

    @Override
    public EntityBean load(DbReadContext ctx) throws SQLException {
        return this.load(ctx, null, null);
    }

    @Override
    public <T> Version<T> loadVersion(DbReadContext ctx) throws SQLException {
        Timestamp start = ctx.getDataReader().getTimestamp();
        Timestamp end = ctx.getDataReader().getTimestamp();
        EntityBean bean = this.load(ctx, null, null);
        return new Version((Object)bean, start, end);
    }

    @Override
    public boolean isSqlDistinct() {
        return this.sqlDistinct;
    }

    @Override
    public void appendDistinctOn(DbSqlContext ctx, boolean subQuery) {
        if (this.readId) {
            ctx.pushTableAlias(this.prefix);
            this.appendSelectId(ctx, this.idBinder.getBeanProperty());
            ctx.popTableAlias();
            super.appendDistinctOn(ctx, subQuery);
        }
    }

    @Override
    public void addAsOfTableAlias(SpiQuery<?> query) {
        if (this.desc.isHistorySupport()) {
            query.setAsOfBaseTable();
            query.incrementAsOfTableCount();
        }
        if (this.lazyLoadParent != null && this.lazyLoadParent.isManyToManyWithHistory()) {
            query.incrementAsOfTableCount();
        }
        for (SqlTreeNode aChildren : this.children) {
            aChildren.addAsOfTableAlias(query);
        }
    }

    @Override
    public SqlJoinType appendFromBaseTable(DbSqlContext ctx, SqlJoinType joinType) {
        ctx.append(this.baseTable);
        ctx.append(" ").append(this.baseTableAlias);
        ctx.appendFromForUpdate();
        if (this.includeJoin != null) {
            String a1 = this.baseTableAlias;
            String a2 = "int_";
            this.includeJoin.addJoin(joinType, a1, a2, ctx);
        }
        return joinType;
    }

    @Override
    public void dependentTables(Set<String> tables) {
        for (SqlTreeNode child : this.children) {
            child.dependentTables(tables);
        }
    }
}

