/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.Query;
import io.ebean.QueryIterator;
import io.ebean.Transaction;
import io.ebean.ValuePair;
import io.ebean.Version;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.ObjectGraphNode;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.util.JdbcClose;
import io.ebean.util.StringHelper;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.DiffHelp;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.core.SpiResultSet;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.lib.Str;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.query.CQuery;
import io.ebeaninternal.server.query.CQueryBuilder;
import io.ebeaninternal.server.query.CQueryDraftSupport;
import io.ebeaninternal.server.query.CQueryFetchSingleAttribute;
import io.ebeaninternal.server.query.CQueryHistorySupport;
import io.ebeaninternal.server.query.CQueryRowCount;
import io.ebeaninternal.server.query.CQueryUpdate;
import io.ebeaninternal.server.query.OrderVersionDesc;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQueryEngine {
    private static final Logger logger = LoggerFactory.getLogger(CQueryEngine.class);
    private static final int defaultSecondaryQueryBatchSize = 100;
    private static final String T0 = "t0";
    private final int defaultFetchSizeFindList;
    private final int defaultFetchSizeFindEach;
    private final boolean forwardOnlyHintOnFindIterate;
    private final CQueryBuilder queryBuilder;
    private final CQueryHistorySupport historySupport;
    private final DatabasePlatform dbPlatform;

    public CQueryEngine(DatabaseConfig config, DatabasePlatform dbPlatform, Binder binder, Map<String, String> asOfTableMapping, Map<String, String> draftTableMap) {
        this.dbPlatform = dbPlatform;
        this.defaultFetchSizeFindEach = config.getJdbcFetchSizeFindEach();
        this.defaultFetchSizeFindList = config.getJdbcFetchSizeFindList();
        this.forwardOnlyHintOnFindIterate = dbPlatform.isForwardOnlyHintOnFindIterate();
        this.historySupport = new CQueryHistorySupport(dbPlatform.getHistorySupport(), asOfTableMapping, config.getAsOfSysPeriod());
        this.queryBuilder = new CQueryBuilder(dbPlatform, binder, this.historySupport, new CQueryDraftSupport(draftTableMap));
    }

    public <T> CQuery<T> buildQuery(OrmQueryRequest<T> request) {
        return this.queryBuilder.buildQuery(request);
    }

    public <T> int delete(OrmQueryRequest<T> request) {
        CQueryUpdate query = this.queryBuilder.buildUpdateQuery(true, request);
        return this.executeUpdate(request, query);
    }

    public <T> int update(OrmQueryRequest<T> request) {
        CQueryUpdate query = this.queryBuilder.buildUpdateQuery(false, request);
        return this.executeUpdate(request, query);
    }

    private <T> int executeUpdate(OrmQueryRequest<T> request, CQueryUpdate query) {
        try {
            int rows = query.execute();
            if (request.isLogSql()) {
                String logSql = query.getGeneratedSql();
                logSql = Str.add(logSql, "; --bind(", query.getBindLog(), ") rows:", String.valueOf(rows));
                request.logSql(logSql);
            }
            return rows;
        }
        catch (SQLException e) {
            throw this.translate(request, query.getBindLog(), query.getGeneratedSql(), e);
        }
    }

    public <A> List<A> findSingleAttributeList(OrmQueryRequest<?> request) {
        CQueryFetchSingleAttribute rcQuery = this.queryBuilder.buildFetchAttributeQuery(request);
        return this.findAttributeList(request, rcQuery);
    }

    private <A> List<A> findAttributeList(OrmQueryRequest<?> request, CQueryFetchSingleAttribute rcQuery) {
        try {
            List<Object> list = rcQuery.findList();
            if (request.isLogSql()) {
                this.logGeneratedSql(request, rcQuery.getGeneratedSql(), rcQuery.getBindLog());
            }
            if (request.isLogSummary()) {
                request.getTransaction().logSummary(rcQuery.getSummary());
            }
            if (request.isQueryCachePut()) {
                request.addDependentTables(rcQuery.getDependentTables());
                list = Collections.unmodifiableList(list);
                request.putToQueryCache(list);
                if (Boolean.FALSE.equals(request.getQuery().isReadOnly())) {
                    list = new ArrayList<Object>(list);
                }
            }
            return list;
        }
        catch (SQLException e) {
            throw this.translate(request, rcQuery.getBindLog(), rcQuery.getGeneratedSql(), e);
        }
    }

    <T> PersistenceException translate(OrmQueryRequest<T> request, String bindLog, String sql, SQLException e) {
        Transaction t = request.getTransaction();
        if (t.isLogSummary()) {
            String msg = "ERROR executing query, bindLog[" + bindLog + "] error[" + StringHelper.removeNewLines((String)e.getMessage()) + "]";
            t.logSummary(msg);
        }
        t.getConnection();
        String m = "Query threw SQLException:" + e.getMessage() + " Bind values:[" + bindLog + "] Query was:" + sql;
        return this.dbPlatform.translate(m, e);
    }

    public <A> List<A> findIds(OrmQueryRequest<?> request) {
        CQueryFetchSingleAttribute rcQuery = this.queryBuilder.buildFetchIdsQuery(request);
        return this.findAttributeList(request, rcQuery);
    }

    private <T> void logGeneratedSql(OrmQueryRequest<T> request, String sql, String bindLog) {
        request.logSql(Str.add(sql, "; --bind(", bindLog, ")"));
    }

    public <T> int findCount(OrmQueryRequest<T> request) {
        CQueryRowCount rcQuery = this.queryBuilder.buildRowCountQuery(request);
        try {
            int count = rcQuery.findCount();
            if (request.isLogSql()) {
                this.logGeneratedSql(request, rcQuery.getGeneratedSql(), rcQuery.getBindLog());
            }
            if (request.isLogSummary()) {
                request.getTransaction().logSummary(rcQuery.getSummary());
            }
            if (request.getQuery().isFutureFetch()) {
                request.getTransaction().end();
            }
            if (request.isQueryCachePut()) {
                request.addDependentTables(rcQuery.getDependentTables());
                request.putToQueryCache(count);
            }
            return count;
        }
        catch (SQLException e) {
            throw this.translate(request, rcQuery.getBindLog(), rcQuery.getGeneratedSql(), e);
        }
    }

    public <T> QueryIterator<T> findIterate(OrmQueryRequest<T> request) {
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        request.setCancelableQuery(cquery);
        try {
            int iterateBufferSize;
            if (this.defaultFetchSizeFindEach > 0) {
                request.setDefaultFetchBuffer(this.defaultFetchSizeFindEach);
            }
            if (!cquery.prepareBindExecuteQueryForwardOnly(this.forwardOnlyHintOnFindIterate)) {
                logger.trace("Future fetch already cancelled");
                return null;
            }
            if (request.isLogSql()) {
                this.logSql(cquery);
            }
            if ((iterateBufferSize = request.getSecondaryQueriesMinBatchSize(100)) < 1) {
                int queryBatch = request.getQuery().getLazyLoadBatchSize();
                iterateBufferSize = queryBatch > 0 ? queryBatch : 100;
            }
            QueryIterator<T> readIterate = cquery.readIterate(iterateBufferSize, request);
            if (request.isLogSummary()) {
                this.logFindManySummary(cquery);
            }
            if (request.isAuditReads()) {
                cquery.auditFindIterate();
            }
            return readIterate;
        }
        catch (SQLException e) {
            try {
                cquery.close();
                throw cquery.createPersistenceException(e);
            }
            catch (Throwable throwable) {
                request.rollbackTransIfRequired();
                throw throwable;
            }
        }
    }

    public <T> List<Version<T>> findVersions(OrmQueryRequest<T> request) {
        Query query = request.getQuery();
        String sysPeriodLower = this.getSysPeriodLower((SpiQuery<T>)query);
        if (query.isVersionsBetween() && !this.historySupport.isStandardsBased()) {
            query.where().lt(sysPeriodLower, (Object)query.getVersionEnd());
            query.where().geOrNull(this.getSysPeriodUpper((SpiQuery<T>)query), (Object)query.getVersionStart());
        }
        query.order().desc(sysPeriodLower);
        try (CQuery<T> cquery = this.queryBuilder.buildQuery(request);){
            cquery.prepareBindExecuteQuery();
            if (request.isLogSql()) {
                this.logSql(cquery);
            }
            List<Version<T>> versions = cquery.readVersions();
            versions.sort(OrderVersionDesc.INSTANCE);
            this.deriveVersionDiffs(versions, request);
            if (request.isLogSummary()) {
                this.logFindManySummary(cquery);
            }
            if (request.isAuditReads()) {
                cquery.auditFindMany();
            }
            List<Version<T>> list = versions;
            return list;
        }
    }

    private <T> void deriveVersionDiffs(List<Version<T>> versions, OrmQueryRequest<T> request) {
        BeanDescriptor<T> descriptor = request.getBeanDescriptor();
        if (!versions.isEmpty()) {
            Version<T> current = versions.get(0);
            if (versions.size() > 1) {
                for (int i = 1; i < versions.size(); ++i) {
                    Version<T> next = versions.get(i);
                    this.deriveVersionDiff(current, next, descriptor);
                    current = next;
                }
            }
            current.setDiff(new LinkedHashMap());
        }
    }

    private <T> void deriveVersionDiff(Version<T> current, Version<T> prior, BeanDescriptor<T> descriptor) {
        Map<String, ValuePair> diff = DiffHelp.diff(current.getBean(), prior.getBean(), descriptor);
        current.setDiff(diff);
    }

    private <T> String getSysPeriodLower(SpiQuery<T> query) {
        return this.historySupport.getSysPeriodLower(query.getAlias(T0));
    }

    private <T> String getSysPeriodUpper(SpiQuery<T> query) {
        return this.historySupport.getSysPeriodUpper(query.getAlias(T0));
    }

    public <T> SpiResultSet findResultSet(OrmQueryRequest<T> request) {
        CQuery<T> cquery = this.queryBuilder.buildQuery(request);
        try {
            boolean fwdOnly;
            if (request.isFindIterate()) {
                fwdOnly = this.forwardOnlyHintOnFindIterate;
                if (this.defaultFetchSizeFindEach > 0) {
                    request.setDefaultFetchBuffer(this.defaultFetchSizeFindEach);
                }
            } else {
                fwdOnly = false;
                if (this.defaultFetchSizeFindList > 0) {
                    request.setDefaultFetchBuffer(this.defaultFetchSizeFindList);
                }
            }
            ResultSet resultSet = cquery.prepareResultSet(fwdOnly);
            if (request.isLogSql()) {
                this.logSql(cquery);
            }
            return new SpiResultSet(cquery.getPstmt(), resultSet);
        }
        catch (SQLException e) {
            JdbcClose.close((Statement)cquery.getPstmt());
            throw cquery.createPersistenceException(e);
        }
    }

    <T> BeanCollection<T> findMany(OrmQueryRequest<T> request) {
        request.setCancelableQuery(cquery);
        try (CQuery<T> cquery = this.queryBuilder.buildQuery(request);){
            if (this.defaultFetchSizeFindList > 0) {
                request.setDefaultFetchBuffer(this.defaultFetchSizeFindList);
            }
            if (!cquery.prepareBindExecuteQuery()) {
                logger.trace("Future fetch already cancelled");
                BeanCollection<T> beanCollection = null;
                return beanCollection;
            }
            if (request.isLogSql()) {
                this.logSql(cquery);
            }
            BeanCollection<T> beanCollection = cquery.readCollection();
            if (request.isLogSummary()) {
                this.logFindManySummary(cquery);
            }
            if (request.isAuditReads()) {
                cquery.auditFindMany();
            }
            request.executeSecondaryQueries(false);
            if (request.isQueryCachePut()) {
                request.addDependentTables(cquery.getDependentTables());
            }
            BeanCollection<T> beanCollection2 = beanCollection;
            return beanCollection2;
        }
    }

    public <T> T find(OrmQueryRequest<T> request) {
        EntityBean bean = null;
        try (CQuery<T> cquery = this.queryBuilder.buildQuery(request);){
            cquery.prepareBindExecuteQuery();
            if (request.isLogSql()) {
                this.logSql(cquery);
            }
            if (cquery.readBean()) {
                bean = cquery.next();
            }
            if (request.isLogSummary()) {
                this.logFindBeanSummary(cquery);
            }
            if (request.isAuditReads()) {
                cquery.auditFind(bean);
            }
            request.executeSecondaryQueries(false);
            EntityBean entityBean = bean;
            return (T)entityBean;
        }
    }

    private void logSql(CQuery<?> query) {
        String sql = query.getGeneratedSql();
        sql = Str.add(sql, "; --bind(", query.getBindLog(), ")");
        query.getTransaction().logSql(sql);
    }

    private void logFindBeanSummary(CQuery<?> q) {
        Query query = q.getQueryRequest().getQuery();
        String loadMode = query.getLoadMode();
        String loadDesc = query.getLoadDescription();
        String lazyLoadProp = query.getLazyLoadProperty();
        ObjectGraphNode node = query.getParentNode();
        String originKey = node == null || node.getOriginQueryPoint() == null ? null : node.getOriginQueryPoint().getKey();
        StringBuilder msg = new StringBuilder(200);
        msg.append("FindBean ");
        if (loadMode != null) {
            msg.append("mode[").append(loadMode).append("] ");
        }
        msg.append("type[").append(q.getBeanName()).append("] ");
        if (query.isAutoTuned()) {
            msg.append("tuned[true] ");
        }
        if (query.isAsDraft()) {
            msg.append(" draft[true] ");
        }
        if (originKey != null) {
            msg.append("origin[").append(originKey).append("] ");
        }
        if (lazyLoadProp != null) {
            msg.append("lazyLoadProp[").append(lazyLoadProp).append("] ");
        }
        if (loadDesc != null) {
            msg.append("load[").append(loadDesc).append("] ");
        }
        msg.append("exeMicros[").append(q.getQueryExecutionTimeMicros());
        msg.append("] rows[").append(q.getLoadedRowDetail());
        msg.append("] bind[").append(q.getBindLog()).append("]");
        q.getTransaction().logSummary(msg.toString());
    }

    private void logFindManySummary(CQuery<?> q) {
        Query query = q.getQueryRequest().getQuery();
        String loadMode = query.getLoadMode();
        String loadDesc = query.getLoadDescription();
        String lazyLoadProp = query.getLazyLoadProperty();
        ObjectGraphNode node = query.getParentNode();
        String originKey = node == null || node.getOriginQueryPoint() == null ? null : node.getOriginQueryPoint().getKey();
        StringBuilder msg = new StringBuilder(200);
        msg.append("FindMany ");
        if (loadMode != null) {
            msg.append("mode[").append(loadMode).append("] ");
        }
        msg.append("type[").append(q.getBeanName()).append("] ");
        if (query.isAutoTuned()) {
            msg.append("tuned[true] ");
        }
        if (query.isAsDraft()) {
            msg.append(" draft[true] ");
        }
        if (originKey != null) {
            msg.append("origin[").append(originKey).append("] ");
        }
        if (lazyLoadProp != null) {
            msg.append("lazyLoadProp[").append(lazyLoadProp).append("] ");
        }
        if (loadDesc != null) {
            msg.append("load[").append(loadDesc).append("] ");
        }
        msg.append("exeMicros[").append(q.getQueryExecutionTimeMicros());
        msg.append("] rows[").append(q.getLoadedRowDetail());
        msg.append("] predicates[").append(q.getLogWhereSql());
        msg.append("] bind[").append(q.getBindLog()).append("]");
        q.getTransaction().logSummary(msg.toString());
    }
}

