/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.Junction;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.expression.DefaultExpressionList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

class PrepareDocNested {
    private final Junction.Type type;
    private final DefaultExpressionList<?> original;
    private final BeanDescriptor<?> beanDescriptor;
    private final List<SpiExpression> origUnderlying;
    private final int origSize;
    private boolean hasNesting;
    private boolean hasMixedNesting;
    private String firstNestedPath;

    static void prepare(DefaultExpressionList<?> expressions, BeanDescriptor<?> beanDescriptor) {
        new PrepareDocNested(expressions, beanDescriptor, null).process();
    }

    static void prepare(DefaultExpressionList<?> expressions, BeanDescriptor<?> beanDescriptor, Junction.Type type) {
        new PrepareDocNested(expressions, beanDescriptor, type).process();
    }

    PrepareDocNested(DefaultExpressionList<?> original, BeanDescriptor<?> beanDescriptor, Junction.Type type) {
        this.type = type;
        this.beanDescriptor = beanDescriptor;
        this.original = original;
        this.origUnderlying = original.getUnderlyingList();
        this.origSize = this.origUnderlying.size();
    }

    void process() {
        Mode mode = this.determineMode();
        if (mode == Mode.SINGLE) {
            this.original.setAllDocNested(this.firstNestedPath);
        } else if (mode == Mode.MIXED) {
            this.original.setUnderlying(this.group());
        }
    }

    private List<SpiExpression> group() {
        LinkedHashMap<String, Group> groups = new LinkedHashMap<String, Group>();
        for (int i = 0; i < this.origSize; ++i) {
            SpiExpression expr = this.origUnderlying.get(i);
            String nestedPath = expr.nestedPath(this.beanDescriptor);
            Group group = groups.computeIfAbsent(nestedPath, x$0 -> new Group((String)x$0));
            group.list.add(expr);
        }
        ArrayList<SpiExpression> newList = new ArrayList<SpiExpression>();
        Collection values = groups.values();
        for (Group group : values) {
            group.addTo(newList);
        }
        return newList;
    }

    private Mode determineMode() {
        if (!this.hasNesting()) {
            return Mode.NONE;
        }
        if (!this.hasMixedNesting) {
            return Mode.SINGLE;
        }
        return Mode.MIXED;
    }

    private boolean hasNesting() {
        for (int i = 0; i < this.origSize; ++i) {
            SpiExpression expr = this.origUnderlying.get(i);
            String nestedPath = expr.nestedPath(this.beanDescriptor);
            if (nestedPath == null) {
                this.hasMixedNesting = true;
            }
            if (nestedPath == null) continue;
            this.hasNesting = true;
            if (this.firstNestedPath == null) {
                this.firstNestedPath = nestedPath;
                continue;
            }
            if (!this.hasMixedNesting && this.firstNestedPath.equals(nestedPath)) continue;
            this.hasMixedNesting = true;
            return true;
        }
        return this.hasNesting;
    }

    class Group {
        final String nestedPath;
        final List<SpiExpression> list = new ArrayList<SpiExpression>();

        Group(String nestedPath) {
            this.nestedPath = nestedPath;
        }

        void addTo(List<SpiExpression> newList) {
            if (this.nestedPath == null) {
                newList.addAll(this.list);
            } else {
                newList.add(PrepareDocNested.this.original.wrap(this.list, this.nestedPath, PrepareDocNested.this.type));
            }
        }
    }

    static enum Mode {
        NONE,
        SINGLE,
        MIXED;

    }
}

