/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.event.BeanFindController;
import io.ebeaninternal.server.core.bootup.BootupClasses;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BeanFinderManager {
    private final Logger logger = LoggerFactory.getLogger(BeanFinderManager.class);
    private final List<BeanFindController> list;

    BeanFinderManager(BootupClasses bootupClasses) {
        this.list = bootupClasses.getBeanFindControllers();
    }

    int getRegisterCount() {
        return this.list.size();
    }

    void addFindControllers(DeployBeanDescriptor<?> deployDesc) {
        for (BeanFindController c : this.list) {
            if (!c.isRegisterFor(deployDesc.getBeanType())) continue;
            this.logger.debug("BeanFindController on[{}] {}", (Object)deployDesc.getFullName(), (Object)c.getClass().getName());
            deployDesc.setBeanFinder(c);
        }
    }
}

