/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.CacheMode;
import io.ebean.OrderBy;
import io.ebean.PersistenceContextScope;
import io.ebean.QueryIterator;
import io.ebean.Version;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.PersistenceContext;
import io.ebean.cache.QueryCacheEntry;
import io.ebean.common.BeanList;
import io.ebean.common.BeanMap;
import io.ebean.common.CopyOnFirstWriteList;
import io.ebean.event.BeanFindController;
import io.ebean.event.BeanQueryAdapter;
import io.ebean.event.BeanQueryRequest;
import io.ebean.text.json.JsonReadOptions;
import io.ebeaninternal.api.BeanCacheResult;
import io.ebeaninternal.api.CQueryPlanKey;
import io.ebeaninternal.api.CacheIdLookup;
import io.ebeaninternal.api.HashQuery;
import io.ebeaninternal.api.LoadContext;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.NaturalKeySet;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiQuerySecondary;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.BeanRequest;
import io.ebeaninternal.server.core.OrmQueryEngine;
import io.ebeaninternal.server.core.SpiOrmQueryRequest;
import io.ebeaninternal.server.core.SpiResultSet;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.DeployParser;
import io.ebeaninternal.server.deploy.DeployPropertyParserMap;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.loadcontext.DLoadContext;
import io.ebeaninternal.server.query.CQueryPlan;
import io.ebeaninternal.server.query.CancelableQuery;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrmQueryRequest<T>
extends BeanRequest
implements SpiOrmQueryRequest<T> {
    private static final Logger log = LoggerFactory.getLogger(OrmQueryRequest.class);
    private final BeanDescriptor<T> beanDescriptor;
    private final OrmQueryEngine queryEngine;
    private final SpiQuery<T> query;
    private final BeanFindController finder;
    private final Boolean readOnly;
    private LoadContext loadContext;
    private PersistenceContext persistenceContext;
    private JsonReadOptions jsonRead;
    private HashQuery cacheKey;
    private CQueryPlanKey queryPlanKey;
    private SpiQuerySecondary secondaryQueries;
    private List<T> cacheBeans;
    private BeanPropertyAssocMany<?> manyProperty;
    private boolean inlineCountDistinct;
    private Set<String> dependentTables;

    public OrmQueryRequest(SpiEbeanServer server, OrmQueryEngine queryEngine, SpiQuery<T> query, SpiTransaction t) {
        super(server, t);
        this.beanDescriptor = query.getBeanDescriptor();
        this.finder = this.beanDescriptor.getBeanFinder();
        this.queryEngine = queryEngine;
        this.query = query;
        this.readOnly = query.isReadOnly();
        this.persistenceContext = query.getPersistenceContext();
    }

    public PersistenceException translate(String bindLog, String sql, SQLException e) {
        return this.queryEngine.translate(this, bindLog, sql, e);
    }

    @Override
    public boolean isDeleteByStatement() {
        if (!this.transaction.isPersistCascade() || this.beanDescriptor.isDeleteByStatement()) {
            return true;
        }
        this.queryPlanKey = this.query.setDeleteByIdsPlan();
        return false;
    }

    public boolean isPadInExpression() {
        return this.beanDescriptor.isPadInExpression();
    }

    public boolean isMultiValueIdSupported() {
        return this.beanDescriptor.isMultiValueIdSupported();
    }

    public boolean isMultiValueSupported(Class<?> valueType) {
        return this.queryEngine.isMultiValueSupported(valueType);
    }

    @Override
    public void markNotQueryOnly() {
        this.transaction.markNotQueryOnly();
    }

    @Override
    public String getDBLikeClause(boolean rawLikeExpression) {
        return this.ebeanServer.getDatabasePlatform().getLikeClause(rawLikeExpression);
    }

    @Override
    public String escapeLikeString(String value) {
        return this.ebeanServer.getDatabasePlatform().escapeLikeString(value);
    }

    @Override
    public void executeSecondaryQueries(boolean forEach) {
        if (this.loadContext != null) {
            this.loadContext.executeSecondaryQueries(this, forEach);
        }
    }

    public int getSecondaryQueriesMinBatchSize(int defaultQueryBatch) {
        return this.loadContext.getSecondaryQueriesMinBatchSize(defaultQueryBatch);
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public BeanDescriptor<T> getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public LoadContext getGraphContext() {
        return this.loadContext;
    }

    @Override
    public boolean isUseDocStore() {
        return this.query.isUseDocStore();
    }

    private void adapterPreQuery() {
        BeanQueryAdapter queryAdapter = this.beanDescriptor.getQueryAdapter();
        if (queryAdapter != null) {
            queryAdapter.preQuery((BeanQueryRequest)this);
        }
    }

    @Override
    public void prepareQuery() {
        this.beanDescriptor.prepareQuery(this.query);
        this.adapterPreQuery();
        this.secondaryQueries = this.query.convertJoins();
        this.queryPlanKey = this.query.prepare(this);
    }

    public boolean isNativeSql() {
        return this.query.isNativeSql();
    }

    public boolean isRawSql() {
        return this.query.isRawSql();
    }

    public DeployParser createDeployParser() {
        if (this.query.isRawSql()) {
            return new DeployPropertyParserMap(this.query.getRawSql().getColumnMapping().getMapping());
        }
        return this.beanDescriptor.parser();
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public void persistenceContextAdd(EntityBean bean) {
        Object id = this.beanDescriptor.getId(bean);
        this.beanDescriptor.contextPut(this.persistenceContext, id, bean);
    }

    @Override
    public void initTransIfRequired() {
        if (this.transaction == null) {
            this.transaction = this.query.getType().isUpdate() ? this.ebeanServer.beginServerTransaction() : this.ebeanServer.createReadOnlyTransaction(this.query.getTenantId());
            this.createdTransaction = true;
        }
        this.persistenceContext = this.getPersistenceContext(this.query, this.transaction);
        this.loadContext = new DLoadContext(this, this.secondaryQueries);
    }

    @Override
    public void rollbackTransIfRequired() {
        if (this.createdTransaction) {
            try {
                this.transaction.end();
            }
            catch (Exception e) {
                log.error("Error trying to rollback a transaction (after a prior exception thrown)", (Throwable)e);
            }
        }
    }

    @Override
    public JsonReadOptions createJsonReadOptions() {
        this.persistenceContext = this.getPersistenceContext(this.query, this.transaction);
        if (this.query.getPersistenceContext() == null) {
            this.query.setPersistenceContext(this.persistenceContext);
        }
        this.jsonRead = new JsonReadOptions();
        this.jsonRead.setPersistenceContext(this.persistenceContext);
        if (!this.query.isDisableLazyLoading()) {
            this.loadContext = new DLoadContext(this, this.secondaryQueries);
            this.jsonRead.setLoadContext((Object)this.loadContext);
        }
        return this.jsonRead;
    }

    public void flushPersistenceContextOnIterate() {
        if (this.persistenceContext.resetLimit()) {
            this.persistenceContext = this.persistenceContext.forIterateReset();
            this.loadContext.resetPersistenceContext(this.persistenceContext);
            if (this.jsonRead != null) {
                this.jsonRead.setPersistenceContext(this.persistenceContext);
                this.jsonRead.setLoadContext((Object)this.loadContext);
            }
        }
    }

    private PersistenceContext getPersistenceContext(SpiQuery<?> query, SpiTransaction t) {
        PersistenceContext ctx = query.getPersistenceContext();
        if (ctx != null) {
            return ctx;
        }
        PersistenceContextScope scope = this.ebeanServer.getPersistenceContextScope(query);
        if (scope == PersistenceContextScope.QUERY || t == null) {
            return new DefaultPersistenceContext();
        }
        if (SpiQuery.Type.ITERATE == query.getType()) {
            return t.getPersistenceContext().forIterate();
        }
        return t.getPersistenceContext();
    }

    @Override
    public void endTransIfRequired() {
        if (this.createdTransaction && this.transaction.isActive()) {
            this.transaction.commit();
            if (this.query.getType().isUpdate()) {
                this.ebeanServer.clearServerTransaction();
            }
        }
    }

    public boolean isFindById() {
        return this.query.getType() == SpiQuery.Type.BEAN;
    }

    public boolean isFindIterate() {
        return this.query.getType() == SpiQuery.Type.ITERATE;
    }

    @Override
    public int delete() {
        return this.notifyCache(this.queryEngine.delete(this), false);
    }

    @Override
    public int update() {
        return this.notifyCache(this.queryEngine.update(this), true);
    }

    private int notifyCache(int rows, boolean update) {
        if (rows > 0) {
            this.beanDescriptor.cacheUpdateQuery(update, this.transaction);
        }
        return rows;
    }

    @Override
    public SpiResultSet findResultSet() {
        return this.queryEngine.findResultSet(this);
    }

    @Override
    public Object findId() {
        return this.queryEngine.findId(this);
    }

    @Override
    public int findCount() {
        return this.queryEngine.findCount(this);
    }

    @Override
    public <A> List<A> findIds() {
        return this.queryEngine.findIds(this);
    }

    @Override
    public void findEach(Consumer<T> consumer) {
        try (QueryIterator it = this.queryEngine.findIterate(this);){
            while (it.hasNext()) {
                consumer.accept(it.next());
            }
        }
    }

    @Override
    public void findEach(int batch, Consumer<List<T>> batchConsumer) {
        ArrayList<Object> buffer = new ArrayList<Object>(batch);
        try (QueryIterator it = this.queryEngine.findIterate(this);){
            while (it.hasNext()) {
                buffer.add(it.next());
                if (buffer.size() < batch) continue;
                batchConsumer.accept(buffer);
                buffer.clear();
            }
            if (!buffer.isEmpty()) {
                batchConsumer.accept(buffer);
            }
        }
    }

    @Override
    public void findEachWhile(Predicate<T> consumer) {
        try (QueryIterator it = this.queryEngine.findIterate(this);){
            while (it.hasNext() && consumer.test(it.next())) {
            }
        }
    }

    @Override
    public QueryIterator<T> findIterate() {
        return this.queryEngine.findIterate(this);
    }

    @Override
    public List<T> findList() {
        return (List)this.queryEngine.findMany(this);
    }

    @Override
    public List<Version<T>> findVersions() {
        return this.queryEngine.findVersions(this);
    }

    @Override
    public Set<T> findSet() {
        return (Set)this.queryEngine.findMany(this);
    }

    @Override
    public <K> Map<K, T> findMap() {
        String mapKey = this.query.getMapKey();
        if (mapKey == null) {
            BeanProperty idProp = this.beanDescriptor.getIdProperty();
            if (idProp != null) {
                this.query.setMapKey(idProp.getName());
            } else {
                throw new PersistenceException("No mapKey specified for query");
            }
        }
        return (Map)this.queryEngine.findMany(this);
    }

    @Override
    public <A> List<A> findSingleAttributeList() {
        return this.queryEngine.findSingleAttributeList(this);
    }

    public BeanFindController getBeanFinder() {
        return this.finder;
    }

    @Override
    public SpiQuery<T> getQuery() {
        return this.query;
    }

    public BeanPropertyAssocMany<?> determineMany() {
        this.manyProperty = this.beanDescriptor.getManyProperty(this.query);
        return this.manyProperty;
    }

    public BeanPropertyAssocMany<?> getManyProperty() {
        return this.manyProperty;
    }

    public CQueryPlan getQueryPlan() {
        return this.beanDescriptor.getQueryPlan(this.queryPlanKey);
    }

    public CQueryPlanKey getQueryPlanKey() {
        return this.queryPlanKey;
    }

    public void putQueryPlan(CQueryPlan queryPlan) {
        this.beanDescriptor.putQueryPlan(this.queryPlanKey, queryPlan);
    }

    @Override
    public void resetBeanCacheAutoMode(boolean findOne) {
        this.query.resetBeanCacheAutoMode(findOne);
    }

    public boolean isQueryCachePut() {
        return this.cacheKey != null && this.query.getUseQueryCache().isPut();
    }

    public boolean isBeanCachePutMany() {
        return !this.transaction.isSkipCacheExplicit() && this.query.isBeanCachePut();
    }

    public boolean isBeanCachePut() {
        return !this.transaction.isSkipCache() && this.query.isBeanCachePut();
    }

    public void mergeCacheHits(BeanCollection<T> result) {
        if (this.cacheBeans != null && !this.cacheBeans.isEmpty()) {
            if (this.query.getType() == SpiQuery.Type.MAP) {
                this.mergeCacheHitsToMap(result);
            } else {
                this.mergeCacheHitsToList(result);
            }
        }
    }

    private void mergeCacheHitsToList(BeanCollection<T> result) {
        OrderBy<T> orderBy;
        for (T hit : this.cacheBeans) {
            result.internalAdd(hit);
        }
        if (result instanceof BeanList && (orderBy = this.query.getOrderBy()) != null) {
            this.beanDescriptor.sort(((BeanList)result).getActualList(), orderBy.toStringFormat());
        }
    }

    private void mergeCacheHitsToMap(BeanCollection<T> result) {
        BeanMap map = (BeanMap)result;
        ElPropertyValue property = this.mapProperty();
        for (T bean : this.cacheBeans) {
            map.internalPut(property.pathGet(bean), bean);
        }
    }

    @Override
    public List<T> getBeanCacheHits() {
        OrderBy<T> orderBy = this.query.getOrderBy();
        if (orderBy != null) {
            this.beanDescriptor.sort(this.cacheBeans, orderBy.toStringFormat());
        }
        return this.cacheBeans;
    }

    @Override
    public <K> Map<K, T> getBeanCacheHitsAsMap() {
        OrderBy<T> orderBy = this.query.getOrderBy();
        if (orderBy != null) {
            this.beanDescriptor.sort(this.cacheBeans, orderBy.toStringFormat());
        }
        return this.cacheBeansToMap();
    }

    private <K> Map<K, T> cacheBeansToMap() {
        ElPropertyValue property = this.mapProperty();
        LinkedHashMap<Object, T> map = new LinkedHashMap<Object, T>();
        for (T bean : this.cacheBeans) {
            map.put(property.pathGet(bean), bean);
        }
        return map;
    }

    private ElPropertyValue mapProperty() {
        ElPropertyValue property = this.beanDescriptor.getElGetValue(this.query.getMapKey());
        if (property == null) {
            throw new IllegalStateException("Unknown map key property " + this.query.getMapKey());
        }
        return property;
    }

    @Override
    public boolean getFromBeanCache() {
        NaturalKeySet naturalKeySet;
        if (!this.query.isBeanCacheGet()) {
            return false;
        }
        CacheIdLookup<T> idLookup = this.query.cacheIdLookup();
        if (idLookup != null) {
            BeanCacheResult<T> cacheResult = this.beanDescriptor.cacheIdLookup(this.persistenceContext, idLookup.idValues());
            this.cacheBeans = idLookup.removeHits(cacheResult);
            return idLookup.allHits();
        }
        if (!this.beanDescriptor.isNaturalKeyCaching()) {
            return false;
        }
        NaturalKeyQueryData<T> data = this.query.naturalKey();
        if (data != null && (naturalKeySet = data.buildKeys()) != null) {
            BeanCacheResult<T> cacheResult = this.beanDescriptor.naturalKeyLookup(this.persistenceContext, naturalKeySet.keys());
            this.cacheBeans = data.removeHits(cacheResult);
            return data.allHits();
        }
        return false;
    }

    @Override
    public Object getFromQueryCache() {
        if (this.query.getUseQueryCache() == CacheMode.OFF || this.transaction != null && this.transaction.isSkipCache() || this.ebeanServer.isDisableL2Cache()) {
            return null;
        }
        this.cacheKey = this.query.queryHash();
        if (!this.query.getUseQueryCache().isGet()) {
            return null;
        }
        Cloneable cached = this.beanDescriptor.queryCacheGet(this.cacheKey);
        if (cached != null && this.isAuditReads() && this.readAuditQueryType() && cached instanceof BeanCollection) {
            Collection actualDetails = ((BeanCollection)cached).getActualDetails();
            ArrayList<Object> ids = new ArrayList<Object>(actualDetails.size());
            for (Object bean : actualDetails) {
                ids.add(this.beanDescriptor.getIdForJson(bean));
            }
            this.beanDescriptor.readAuditMany(this.queryPlanKey.getPartialKey(), "l2-query-cache", ids);
        }
        if (Boolean.FALSE.equals(this.query.isReadOnly())) {
            if (cached instanceof BeanCollection) {
                cached = ((BeanCollection)cached).getShallowCopy();
            } else if (cached instanceof List) {
                cached = new CopyOnFirstWriteList((List)((Object)cached));
            } else if (cached instanceof Set) {
                cached = new LinkedHashSet(cached);
            } else if (cached instanceof Map) {
                cached = new LinkedHashMap((Map)((Object)cached));
            }
        }
        return cached;
    }

    private boolean readAuditQueryType() {
        SpiQuery.Type type = this.query.getType();
        switch (type) {
            case BEAN: 
            case ITERATE: 
            case LIST: 
            case SET: 
            case MAP: {
                return true;
            }
        }
        return false;
    }

    public void putToQueryCache(Object result) {
        this.beanDescriptor.queryCachePut(this.cacheKey, new QueryCacheEntry(result, this.dependentTables, this.transaction.getStartNanoTime()));
    }

    public void setCancelableQuery(CancelableQuery cancelableQuery) {
        this.query.setCancelableQuery(cancelableQuery);
    }

    public void logSql(String sql) {
        this.transaction.logSql(sql);
    }

    public int getLazyLoadBatchSize() {
        int batchSize = this.query.getLazyLoadBatchSize();
        return batchSize > 0 ? batchSize : this.ebeanServer.getLazyLoadBatchSize();
    }

    public boolean isAuditReads() {
        return this.beanDescriptor.isReadAuditing() && !this.query.isDisableReadAudit();
    }

    public String getBaseTableAlias() {
        return this.query.getAlias(this.beanDescriptor.getBaseTableAlias());
    }

    public void setDefaultFetchBuffer(int fetchSize) {
        this.query.setDefaultFetchBuffer(fetchSize);
    }

    public Object getTenantId() {
        return this.transaction == null ? null : this.transaction.getTenantId();
    }

    public void slowQueryCheck(long executionTimeMicros, int rowCount) {
        this.ebeanServer.slowQueryCheck(executionTimeMicros, rowCount, this.query);
    }

    public void setInlineCountDistinct() {
        this.inlineCountDistinct = true;
    }

    public boolean isInlineCountDistinct() {
        return this.inlineCountDistinct;
    }

    public void addDependentTables(Set<String> tables) {
        if (tables != null && !tables.isEmpty()) {
            if (this.dependentTables == null) {
                this.dependentTables = new LinkedHashSet<String>();
            }
            this.dependentTables.addAll(tables);
        }
    }

    public boolean isInlineSqlUpdateLimit() {
        return this.query.getMaxRows() < 1 || this.ebeanServer.getDatabasePlatform().isInlineSqlUpdateLimit();
    }
}

