/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebean.text.TextException;
import io.ebean.text.json.EJson;
import io.ebeaninternal.server.type.PostgresHelper;
import io.ebeaninternal.server.type.ScalarTypeJsonCollection;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.persistence.PersistenceException;

public class ScalarTypeJsonList {
    public static ScalarType<?> typeFor(boolean postgres, int dbType, DocPropertyType docType, boolean nullable) {
        if (postgres) {
            switch (dbType) {
                case 5002: {
                    return new JsonB(docType, nullable);
                }
                case 5001: {
                    return new Json(docType, nullable);
                }
            }
        }
        return new Varchar(docType, nullable);
    }

    private static class JsonB
    extends PgBase {
        public JsonB(DocPropertyType docType, boolean nullable) {
            super(5002, "jsonb", docType, nullable);
        }
    }

    private static class Json
    extends PgBase {
        public Json(DocPropertyType docType, boolean nullable) {
            super(5001, "json", docType, nullable);
        }
    }

    public static class Varchar
    extends Base {
        public Varchar(DocPropertyType docType, boolean nullable) {
            super(12, docType, nullable);
        }
    }

    private static class PgBase
    extends Base {
        final String pgType;

        PgBase(int jdbcType, String pgType, DocPropertyType docType, boolean nullable) {
            super(jdbcType, docType, nullable);
            this.pgType = pgType;
        }

        @Override
        public void bind(DataBinder binder, List value) throws SQLException {
            if (value == null) {
                this.bindNull(binder);
            } else {
                binder.setObject(PostgresHelper.asObject(this.pgType, this.formatValue(value)));
            }
        }

        @Override
        protected void bindNull(DataBinder binder) throws SQLException {
            binder.setObject(PostgresHelper.asObject(this.pgType, this.nullable ? null : "[]"));
        }
    }

    private static abstract class Base
    extends ScalarTypeJsonCollection<List> {
        public Base(int dbType, DocPropertyType docType, boolean nullable) {
            super(List.class, dbType, docType, nullable);
        }

        public List read(DataReader reader) throws SQLException {
            String json = reader.getString();
            try {
                return EJson.parseList((String)json, (boolean)true);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as List", json, (Exception)e);
            }
        }

        public void bind(DataBinder binder, List value) throws SQLException {
            if (value == null) {
                this.bindNull(binder);
            } else if (value.isEmpty()) {
                binder.setString("[]");
            } else {
                try {
                    binder.setString(EJson.write((Object)value));
                }
                catch (IOException e) {
                    throw new SQLException("Failed to format List into JSON content", e);
                }
            }
        }

        @Override
        protected void bindNull(DataBinder binder) throws SQLException {
            if (this.nullable) {
                binder.setNull(12);
            } else {
                binder.setString("[]");
            }
        }

        public String formatValue(List value) {
            try {
                return EJson.write((Object)value);
            }
            catch (IOException e) {
                throw new PersistenceException("Failed to format List into JSON content", (Throwable)e);
            }
        }

        public List parse(String value) {
            try {
                return EJson.parseList((String)value, (boolean)false);
            }
            catch (IOException e) {
                throw new TextException("Failed to parse JSON [{}] as List", value, (Exception)e);
            }
        }

        public List jsonRead(JsonParser parser) throws IOException {
            return EJson.parseList((JsonParser)parser, (JsonToken)parser.getCurrentToken());
        }

        public void jsonWrite(JsonGenerator writer, List value) throws IOException {
            EJson.write((Object)value, (JsonGenerator)writer);
        }
    }
}

