/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.CacheMode;
import io.ebean.CountDistinctOrder;
import io.ebean.DtoQuery;
import io.ebean.Expression;
import io.ebean.ExpressionFactory;
import io.ebean.ExpressionList;
import io.ebean.FetchGroup;
import io.ebean.FetchPath;
import io.ebean.FutureIds;
import io.ebean.FutureList;
import io.ebean.FutureRowCount;
import io.ebean.Junction;
import io.ebean.OrderBy;
import io.ebean.PagedList;
import io.ebean.Pairs;
import io.ebean.Query;
import io.ebean.QueryIterator;
import io.ebean.Transaction;
import io.ebean.UpdateQuery;
import io.ebean.Version;
import io.ebean.event.BeanQueryRequest;
import io.ebean.search.Match;
import io.ebean.search.MultiMatch;
import io.ebean.search.TextCommonTerms;
import io.ebean.search.TextQueryString;
import io.ebean.search.TextSimple;
import io.ebeaninternal.api.ManyWhereJoins;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionList;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiExpressionValidation;
import io.ebeaninternal.api.SpiJunction;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.expression.JunctionExpression;
import io.ebeaninternal.server.expression.PrepareDocNested;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class DefaultExpressionList<T>
implements SpiExpressionList<T> {
    private static final String AND = " and ";
    protected List<SpiExpression> list;
    protected final Query<T> query;
    private final ExpressionList<T> parentExprList;
    protected final ExpressionFactory expr;
    String allDocNestedPath;
    private final boolean textRoot;

    public DefaultExpressionList(Query<T> query) {
        this(query, query.getExpressionFactory(), null, new ArrayList<SpiExpression>(), true);
    }

    public DefaultExpressionList(Query<T> query, ExpressionList<T> parentExprList) {
        this(query, query.getExpressionFactory(), parentExprList);
    }

    DefaultExpressionList(Query<T> query, ExpressionFactory expr, ExpressionList<T> parentExprList) {
        this(query, expr, parentExprList, new ArrayList<SpiExpression>());
    }

    DefaultExpressionList(Query<T> query, ExpressionFactory expr, ExpressionList<T> parentExprList, List<SpiExpression> list) {
        this(query, expr, parentExprList, list, false);
    }

    private DefaultExpressionList(Query<T> query, ExpressionFactory expr, ExpressionList<T> parentExprList, List<SpiExpression> list, boolean textRoot) {
        this.textRoot = textRoot;
        this.list = list;
        this.query = query;
        this.expr = expr;
        this.parentExprList = parentExprList;
    }

    private DefaultExpressionList() {
        this(null, null, null, new ArrayList<SpiExpression>());
    }

    SpiExpression wrap(List<SpiExpression> list, String nestedPath, Junction.Type type) {
        DefaultExpressionList<T> wrapper = new DefaultExpressionList<T>(this.query, this.expr, null, list, false);
        wrapper.setAllDocNested(nestedPath);
        if (type != null) {
            return new JunctionExpression<T>(type, wrapper);
        }
        return wrapper;
    }

    void simplifyEntries() {
        for (SpiExpression element : this.list) {
            element.simplify();
        }
    }

    @Override
    public Junction<T> toJunction() {
        return new JunctionExpression(Junction.Type.FILTER, this);
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        return false;
    }

    @Override
    public void simplify() {
        this.simplifyEntries();
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        if (!this.textRoot) {
            this.writeDocQuery(context, null);
        } else {
            boolean implicitBool;
            if (this.list.isEmpty()) {
                throw new IllegalStateException("empty expression list?");
            }
            if (this.allDocNestedPath != null) {
                context.startNested(this.allDocNestedPath);
            }
            int size = this.list.size();
            SpiExpression first = this.list.get(0);
            boolean explicitBool = first instanceof SpiJunction;
            boolean bl = implicitBool = !explicitBool && size > 1;
            if (implicitBool || explicitBool) {
                context.startBoolGroup();
            }
            if (implicitBool) {
                context.startBoolGroupList(Junction.Type.SHOULD);
            }
            for (SpiExpression expr : this.list) {
                if (explicitBool) {
                    try {
                        ((SpiJunction)((Object)expr)).writeDocQueryJunction(context);
                        continue;
                    }
                    catch (ClassCastException e) {
                        throw new IllegalStateException("The top level text() expressions should be all be 'Must', 'Should' or 'Must Not' or none of them should be.", e);
                    }
                }
                expr.writeDocQuery(context);
            }
            if (implicitBool) {
                context.endBoolGroupList();
            }
            if (implicitBool || explicitBool) {
                context.endBoolGroup();
            }
            if (this.allDocNestedPath != null) {
                context.endNested();
            }
        }
    }

    @Override
    public void writeDocQuery(DocQueryContext context, SpiExpression idEquals) throws IOException {
        int size;
        if (this.allDocNestedPath != null) {
            context.startNested(this.allDocNestedPath);
        }
        if ((size = this.list.size()) == 1 && idEquals == null) {
            this.list.get(0).writeDocQuery(context);
        } else if (size == 0 && idEquals != null) {
            idEquals.writeDocQuery(context);
        } else {
            context.startBoolMust();
            if (idEquals != null) {
                idEquals.writeDocQuery(context);
            }
            for (SpiExpression aList : this.list) {
                aList.writeDocQuery(context);
            }
            context.endBool();
        }
        if (this.allDocNestedPath != null) {
            context.endNested();
        }
    }

    @Override
    public SpiExpressionList<?> trimPath(int prefixTrim) {
        throw new IllegalStateException("Only allowed on FilterExpressionList");
    }

    public List<SpiExpression> internalList() {
        return this.list;
    }

    public DefaultExpressionList<T> copy(Query<T> query) {
        DefaultExpressionList<T> copy = new DefaultExpressionList<T>(query, this.expr, null);
        copy.list.addAll(this.list);
        return copy;
    }

    @Override
    public DefaultExpressionList<T> copyForPlanKey() {
        DefaultExpressionList<T> copy = new DefaultExpressionList<T>();
        for (int i = 0; i < this.list.size(); ++i) {
            copy.list.add(this.list.get(i).copyForPlanKey());
        }
        return copy;
    }

    @Override
    public Object getIdEqualTo(String idName) {
        return null;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins whereManyJoins) {
        for (SpiExpression aList : this.list) {
            aList.containsMany(desc, whereManyJoins);
        }
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        for (SpiExpression aList : this.list) {
            aList.validate(validation);
        }
    }

    public Query<T> query() {
        return this.query;
    }

    public Query<T> asOf(Timestamp asOf) {
        return this.query.asOf(asOf);
    }

    public Query<T> asDraft() {
        return this.query.asDraft();
    }

    public <D> DtoQuery<D> asDto(Class<D> dtoClass) {
        return this.query.asDto(dtoClass);
    }

    public UpdateQuery<T> asUpdate() {
        return this.query.asUpdate();
    }

    public Query<T> setIncludeSoftDeletes() {
        return this.query.setIncludeSoftDeletes();
    }

    public List<Version<T>> findVersions() {
        return this.query.findVersions();
    }

    public List<Version<T>> findVersionsBetween(Timestamp start, Timestamp end) {
        return this.query.findVersionsBetween(start, end);
    }

    public ExpressionList<T> where() {
        return this.query.where();
    }

    public OrderBy<T> order() {
        return this.query.order();
    }

    public OrderBy<T> orderBy() {
        return this.query.order();
    }

    public ExpressionList<T> order(String orderByClause) {
        this.query.order(orderByClause);
        return this;
    }

    public ExpressionList<T> orderBy(String orderBy) {
        this.query.order(orderBy);
        return this;
    }

    public Query<T> setOrderBy(String orderBy) {
        return this.query.order(orderBy);
    }

    public Query<T> orderById(boolean orderById) {
        return this.query.orderById(orderById);
    }

    public Query<T> apply(FetchPath fetchPath) {
        return this.query.apply(fetchPath);
    }

    public Query<T> usingTransaction(Transaction transaction) {
        return this.query.usingTransaction(transaction);
    }

    public Query<T> usingConnection(Connection connection) {
        return this.query.usingConnection(connection);
    }

    public int delete() {
        return this.query.delete();
    }

    public int delete(Transaction transaction) {
        return this.query.delete(transaction);
    }

    public int update() {
        return this.query.update();
    }

    public int update(Transaction transaction) {
        return this.query.update(transaction);
    }

    public FutureIds<T> findFutureIds() {
        return this.query.findFutureIds();
    }

    public FutureRowCount<T> findFutureCount() {
        return this.query.findFutureCount();
    }

    public FutureList<T> findFutureList() {
        return this.query.findFutureList();
    }

    public PagedList<T> findPagedList() {
        return this.query.findPagedList();
    }

    public int findCount() {
        return this.query.findCount();
    }

    public <A> List<A> findIds() {
        return this.query.findIds();
    }

    public QueryIterator<T> findIterate() {
        return this.query.findIterate();
    }

    public void findEach(Consumer<T> consumer) {
        this.query.findEach(consumer);
    }

    public void findEachWhile(Predicate<T> consumer) {
        this.query.findEachWhile(consumer);
    }

    public List<T> findList() {
        return this.query.findList();
    }

    public Set<T> findSet() {
        return this.query.findSet();
    }

    public <K> Map<K, T> findMap() {
        return this.query.findMap();
    }

    public <A> List<A> findSingleAttributeList() {
        return this.query.findSingleAttributeList();
    }

    public boolean exists() {
        return this.query.exists();
    }

    public T findOne() {
        return (T)this.query.findOne();
    }

    public Optional<T> findOneOrEmpty() {
        return this.query.findOneOrEmpty();
    }

    public ExpressionList<T> filterMany(String manyProperty) {
        return this.query.filterMany(manyProperty);
    }

    public ExpressionList<T> filterMany(String manyProperty, String expressions, Object ... params) {
        return this.query.filterMany(manyProperty).where(expressions, params);
    }

    public Query<T> withLock(Query.LockType lockType) {
        return this.query.withLock(lockType);
    }

    public Query<T> withLock(Query.LockType lockType, Query.LockWait lockWait) {
        return this.query.withLock(lockType, lockWait);
    }

    public Query<T> forUpdate() {
        return this.query.forUpdate();
    }

    public Query<T> forUpdateNoWait() {
        return this.query.forUpdateNoWait();
    }

    public Query<T> forUpdateSkipLocked() {
        return this.query.forUpdateSkipLocked();
    }

    public Query<T> select(String fetchProperties) {
        return this.query.select(fetchProperties);
    }

    public Query<T> select(FetchGroup<T> fetchGroup) {
        return this.query.select(fetchGroup);
    }

    public Query<T> setDistinct(boolean distinct) {
        return this.query.setDistinct(distinct);
    }

    public Query<T> setDocIndexName(String indexName) {
        return this.query.setDocIndexName(indexName);
    }

    public ExpressionList<T> setFirstRow(int firstRow) {
        this.query.setFirstRow(firstRow);
        return this;
    }

    public ExpressionList<T> setMaxRows(int maxRows) {
        this.query.setMaxRows(maxRows);
        return this;
    }

    public Query<T> setMapKey(String mapKey) {
        return this.query.setMapKey(mapKey);
    }

    public Query<T> setUseCache(boolean useCache) {
        return this.query.setUseCache(useCache);
    }

    public Query<T> setBeanCacheMode(CacheMode useCache) {
        return this.query.setBeanCacheMode(useCache);
    }

    public Query<T> setUseQueryCache(CacheMode useCache) {
        return this.query.setUseQueryCache(useCache);
    }

    public Query<T> setCountDistinct(CountDistinctOrder orderBy) {
        return this.query.setCountDistinct(orderBy);
    }

    public Query<T> setUseDocStore(boolean useDocsStore) {
        return this.query.setUseDocStore(useDocsStore);
    }

    public Query<T> setDisableLazyLoading(boolean disableLazyLoading) {
        return this.query.setDisableLazyLoading(disableLazyLoading);
    }

    public Query<T> setDisableReadAuditing() {
        return this.query.setDisableReadAuditing();
    }

    public Query<T> setLabel(String label) {
        return this.query.setLabel(label);
    }

    public ExpressionList<T> having() {
        return this.query.having();
    }

    public ExpressionList<T> add(Expression expr) {
        this.list.add((SpiExpression)expr);
        return this;
    }

    public ExpressionList<T> addAll(ExpressionList<T> exprList) {
        SpiExpressionList spiList = (SpiExpressionList)exprList;
        this.list.addAll(spiList.getUnderlyingList());
        return this;
    }

    @Override
    public List<SpiExpression> getUnderlyingList() {
        return this.list;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            SpiExpression expression = this.list.get(i);
            if (i > 0) {
                request.append(AND);
            }
            expression.addSql(request);
        }
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        for (SpiExpression aList : this.list) {
            aList.addBindValues(request);
        }
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        for (SpiExpression aList : this.list) {
            aList.prepareExpression(request);
        }
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("List[");
        if (this.textRoot) {
            builder.append("textRoot:true ");
        }
        if (this.allDocNestedPath != null) {
            builder.append("path:").append(this.allDocNestedPath).append(" ");
        }
        for (SpiExpression aList : this.list) {
            aList.queryPlanHash(builder);
            builder.append(",");
        }
        builder.append("]");
    }

    @Override
    public int queryBindHash() {
        int hash = DefaultExpressionList.class.getName().hashCode();
        for (SpiExpression aList : this.list) {
            hash = hash * 92821 + aList.queryBindHash();
        }
        return hash;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        DefaultExpressionList that = (DefaultExpressionList)other;
        if (this.list.size() != that.list.size()) {
            return false;
        }
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            if (this.list.get(i).isSameByBind(that.list.get(i))) continue;
            return false;
        }
        return true;
    }

    public ExpressionList<T> jsonExists(String propertyName, String path) {
        return this.add(this.expr.jsonExists(propertyName, path));
    }

    public ExpressionList<T> jsonNotExists(String propertyName, String path) {
        return this.add(this.expr.jsonNotExists(propertyName, path));
    }

    public ExpressionList<T> jsonEqualTo(String propertyName, String path, Object value) {
        return this.add(this.expr.jsonEqualTo(propertyName, path, value));
    }

    public ExpressionList<T> jsonNotEqualTo(String propertyName, String path, Object val) {
        return this.add(this.expr.jsonNotEqualTo(propertyName, path, val));
    }

    public ExpressionList<T> jsonGreaterThan(String propertyName, String path, Object val) {
        return this.add(this.expr.jsonGreaterThan(propertyName, path, val));
    }

    public ExpressionList<T> jsonGreaterOrEqual(String propertyName, String path, Object val) {
        return this.add(this.expr.jsonGreaterOrEqual(propertyName, path, val));
    }

    public ExpressionList<T> jsonLessThan(String propertyName, String path, Object val) {
        return this.add(this.expr.jsonLessThan(propertyName, path, val));
    }

    public ExpressionList<T> jsonLessOrEqualTo(String propertyName, String path, Object val) {
        return this.add(this.expr.jsonLessOrEqualTo(propertyName, path, val));
    }

    public ExpressionList<T> jsonBetween(String propertyName, String path, Object lowerValue, Object upperValue) {
        return this.add(this.expr.jsonBetween(propertyName, path, lowerValue, upperValue));
    }

    public ExpressionList<T> where(String expressions, Object ... params) {
        this.expr.where((ExpressionList)this, expressions, params);
        return this;
    }

    public ExpressionList<T> bitwiseAny(String propertyName, long flags) {
        return this.add(this.expr.bitwiseAny(propertyName, flags));
    }

    public ExpressionList<T> bitwiseNot(String propertyName, long flags) {
        return this.add(this.expr.bitwiseAnd(propertyName, flags, 0L));
    }

    public ExpressionList<T> bitwiseAll(String propertyName, long flags) {
        return this.add(this.expr.bitwiseAll(propertyName, flags));
    }

    public ExpressionList<T> bitwiseAnd(String propertyName, long flags, long match) {
        return this.add(this.expr.bitwiseAnd(propertyName, flags, match));
    }

    public ExpressionList<T> eq(String propertyName, Object value) {
        return this.add(this.expr.eq(propertyName, value));
    }

    public ExpressionList<T> eqOrNull(String propertyName, Object value) {
        return this.add(this.expr.eqOrNull(propertyName, value));
    }

    public ExpressionList<T> ieq(String propertyName, String value) {
        return this.add(this.expr.ieq(propertyName, value));
    }

    public ExpressionList<T> ine(String propertyName, String value) {
        return this.add(this.expr.ine(propertyName, value));
    }

    public ExpressionList<T> ne(String propertyName, Object value) {
        return this.add(this.expr.ne(propertyName, value));
    }

    public ExpressionList<T> allEq(Map<String, Object> propertyMap) {
        return this.add(this.expr.allEq(propertyMap));
    }

    public ExpressionList<T> and(Expression expOne, Expression expTwo) {
        return this.add(this.expr.and(expOne, expTwo));
    }

    public ExpressionList<T> inRangeWith(String lowProperty, String highProperty, Object value) {
        return this.add(this.expr.inRangeWith(lowProperty, highProperty, value));
    }

    public ExpressionList<T> inRange(String propertyName, Object value1, Object value2) {
        return this.add(this.expr.inRange(propertyName, value1, value2));
    }

    public ExpressionList<T> between(String propertyName, Object value1, Object value2) {
        return this.add(this.expr.between(propertyName, value1, value2));
    }

    public ExpressionList<T> betweenProperties(String lowProperty, String highProperty, Object value) {
        return this.add(this.expr.betweenProperties(lowProperty, highProperty, value));
    }

    public ExpressionList<T> contains(String propertyName, String value) {
        return this.add(this.expr.contains(propertyName, value));
    }

    public ExpressionList<T> endsWith(String propertyName, String value) {
        return this.add(this.expr.endsWith(propertyName, value));
    }

    public ExpressionList<T> ge(String propertyName, Object value) {
        this.add(this.expr.ge(propertyName, value));
        return this;
    }

    public ExpressionList<T> gt(String propertyName, Object value) {
        return this.add(this.expr.gt(propertyName, value));
    }

    public ExpressionList<T> gtOrNull(String propertyName, Object value) {
        this.add(this.expr.gtOrNull(propertyName, value));
        return this;
    }

    public ExpressionList<T> geOrNull(String propertyName, Object value) {
        this.add(this.expr.geOrNull(propertyName, value));
        return this;
    }

    public ExpressionList<T> icontains(String propertyName, String value) {
        return this.add(this.expr.icontains(propertyName, value));
    }

    public ExpressionList<T> idIn(Object ... idValues) {
        return this.add(this.expr.idIn(idValues));
    }

    public ExpressionList<T> idIn(Collection<?> idCollection) {
        return this.add(this.expr.idIn(idCollection));
    }

    public ExpressionList<T> idEq(Object value) {
        if (this.query != null && this.parentExprList == null) {
            this.query.setId(value);
        } else {
            this.add(this.expr.idEq(value));
        }
        return this;
    }

    public ExpressionList<T> iendsWith(String propertyName, String value) {
        return this.add(this.expr.iendsWith(propertyName, value));
    }

    public ExpressionList<T> ilike(String propertyName, String value) {
        return this.add(this.expr.ilike(propertyName, value));
    }

    public ExpressionList<T> inPairs(Pairs pairs) {
        return this.add(this.expr.inPairs(pairs));
    }

    public ExpressionList<T> in(String propertyName, Query<?> subQuery) {
        return this.add(this.expr.in(propertyName, subQuery));
    }

    public ExpressionList<T> in(String propertyName, Collection<?> values) {
        return this.add(this.expr.in(propertyName, values));
    }

    public ExpressionList<T> inOrEmpty(String propertyName, Collection<?> values) {
        if (this.notEmpty(values)) {
            this.add(this.expr.in(propertyName, values));
        }
        return this;
    }

    public ExpressionList<T> in(String propertyName, Object ... values) {
        return this.add(this.expr.in(propertyName, values));
    }

    public ExpressionList<T> notIn(String propertyName, Object ... values) {
        return this.add(this.expr.notIn(propertyName, values));
    }

    public ExpressionList<T> notIn(String propertyName, Collection<?> values) {
        return this.add(this.expr.notIn(propertyName, values));
    }

    public ExpressionList<T> notIn(String propertyName, Query<?> subQuery) {
        return this.add(this.expr.notIn(propertyName, subQuery));
    }

    public ExpressionList<T> isEmpty(String propertyName) {
        return this.add(this.expr.isEmpty(propertyName));
    }

    public ExpressionList<T> isNotEmpty(String propertyName) {
        return this.add(this.expr.isNotEmpty(propertyName));
    }

    public ExpressionList<T> exists(Query<?> subQuery) {
        return this.add(this.expr.exists(subQuery));
    }

    public ExpressionList<T> notExists(Query<?> subQuery) {
        return this.add(this.expr.notExists(subQuery));
    }

    public ExpressionList<T> isNotNull(String propertyName) {
        return this.add(this.expr.isNotNull(propertyName));
    }

    public ExpressionList<T> isNull(String propertyName) {
        return this.add(this.expr.isNull(propertyName));
    }

    public ExpressionList<T> istartsWith(String propertyName, String value) {
        return this.add(this.expr.istartsWith(propertyName, value));
    }

    public ExpressionList<T> le(String propertyName, Object value) {
        return this.add(this.expr.le(propertyName, value));
    }

    public ExpressionList<T> exampleLike(Object example) {
        return this.add((Expression)this.expr.exampleLike(example));
    }

    public ExpressionList<T> iexampleLike(Object example) {
        return this.add((Expression)this.expr.iexampleLike(example));
    }

    public ExpressionList<T> like(String propertyName, String value) {
        return this.add(this.expr.like(propertyName, value));
    }

    public ExpressionList<T> lt(String propertyName, Object value) {
        return this.add(this.expr.lt(propertyName, value));
    }

    public ExpressionList<T> ltOrNull(String propertyName, Object value) {
        return this.add(this.expr.ltOrNull(propertyName, value));
    }

    public ExpressionList<T> leOrNull(String propertyName, Object value) {
        return this.add(this.expr.leOrNull(propertyName, value));
    }

    public ExpressionList<T> not(Expression exp) {
        return this.add(this.expr.not(exp));
    }

    public ExpressionList<T> or(Expression expOne, Expression expTwo) {
        return this.add(this.expr.or(expOne, expTwo));
    }

    public ExpressionList<T> arrayContains(String propertyName, Object ... elementValue) {
        return this.add(this.expr.arrayContains(propertyName, elementValue));
    }

    public ExpressionList<T> arrayNotContains(String propertyName, Object ... values) {
        return this.add(this.expr.arrayNotContains(propertyName, values));
    }

    public ExpressionList<T> arrayIsEmpty(String propertyName) {
        return this.add(this.expr.arrayIsEmpty(propertyName));
    }

    public ExpressionList<T> arrayIsNotEmpty(String propertyName) {
        return this.add(this.expr.arrayIsNotEmpty(propertyName));
    }

    public ExpressionList<T> raw(String raw, Object value) {
        return this.add(this.expr.raw(raw, value));
    }

    public ExpressionList<T> raw(String raw, Object ... values) {
        return this.add(this.expr.raw(raw, values));
    }

    public ExpressionList<T> raw(String raw) {
        return this.add(this.expr.raw(raw));
    }

    public ExpressionList<T> rawOrEmpty(String raw, Collection<?> values) {
        if (this.notEmpty(values)) {
            this.add(this.expr.raw(raw, values));
        }
        return this;
    }

    private boolean notEmpty(Collection<?> values) {
        return values != null && !values.isEmpty();
    }

    public ExpressionList<T> startsWith(String propertyName, String value) {
        return this.add(this.expr.startsWith(propertyName, value));
    }

    public ExpressionList<T> match(String propertyName, String search) {
        return this.match(propertyName, search, null);
    }

    public ExpressionList<T> match(String propertyName, String search, Match options) {
        this.setUseDocStore(true);
        return this.add(this.expr.textMatch(propertyName, search, options));
    }

    public ExpressionList<T> multiMatch(String query, String ... fields) {
        return this.multiMatch(query, MultiMatch.fields((String[])fields));
    }

    public ExpressionList<T> multiMatch(String query, MultiMatch options) {
        this.setUseDocStore(true);
        return this.add(this.expr.textMultiMatch(query, options));
    }

    public ExpressionList<T> textSimple(String search, TextSimple options) {
        this.setUseDocStore(true);
        return this.add(this.expr.textSimple(search, options));
    }

    public ExpressionList<T> textQueryString(String search, TextQueryString options) {
        this.setUseDocStore(true);
        return this.add(this.expr.textQueryString(search, options));
    }

    public ExpressionList<T> textCommonTerms(String search, TextCommonTerms options) {
        this.setUseDocStore(true);
        return this.add(this.expr.textCommonTerms(search, options));
    }

    protected Junction<T> junction(Junction.Type type) {
        Junction junction = this.expr.junction(type, this.query, (ExpressionList)this);
        this.add((Expression)junction);
        return junction;
    }

    public ExpressionList<T> endJunction() {
        return this.parentExprList == null ? this : this.parentExprList;
    }

    public ExpressionList<T> endAnd() {
        return this.endJunction();
    }

    public ExpressionList<T> endOr() {
        return this.endJunction();
    }

    public ExpressionList<T> endNot() {
        return this.endJunction();
    }

    public Junction<T> and() {
        return this.conjunction();
    }

    public Junction<T> or() {
        return this.disjunction();
    }

    public Junction<T> not() {
        return this.junction(Junction.Type.NOT);
    }

    public Junction<T> conjunction() {
        return this.junction(Junction.Type.AND);
    }

    public Junction<T> disjunction() {
        return this.junction(Junction.Type.OR);
    }

    public Junction<T> must() {
        this.setUseDocStore(true);
        return this.junction(Junction.Type.MUST);
    }

    public Junction<T> should() {
        this.setUseDocStore(true);
        return this.junction(Junction.Type.SHOULD);
    }

    public Junction<T> mustNot() {
        this.setUseDocStore(true);
        return this.junction(Junction.Type.MUST_NOT);
    }

    @Override
    public String nestedPath(BeanDescriptor<?> desc) {
        return null;
    }

    public void setAllDocNested(String allDocNestedPath) {
        this.allDocNestedPath = allDocNestedPath;
    }

    public void setUnderlying(List<SpiExpression> groupedByNesting) {
        this.list = groupedByNesting;
    }

    public void prepareDocNested(BeanDescriptor<T> beanDescriptor) {
        PrepareDocNested.prepare(this, beanDescriptor);
    }

    public Object idEqualTo(String idName) {
        if (idName == null) {
            return null;
        }
        if (this.list.size() == 1) {
            return this.list.get(0).getIdEqualTo(idName);
        }
        return null;
    }
}

