/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DocPropertyType;
import io.ebeaninternal.server.type.CheckMarkedDirty;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.ScalarTypeArray;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

abstract class ScalarTypeJsonCollection<T>
extends ScalarTypeBase<T>
implements ScalarTypeArray {
    protected final DocPropertyType docPropertyType;
    protected final boolean nullable;

    public ScalarTypeJsonCollection(Class<T> type, int dbType, DocPropertyType docPropertyType, boolean nullable) {
        super(type, false, dbType);
        this.docPropertyType = docPropertyType;
        this.nullable = nullable;
    }

    protected void bindNull(DataBinder binder) throws SQLException {
        if (this.nullable) {
            binder.setNull(12);
        } else {
            binder.setString("[]");
        }
    }

    @Override
    public String getDbColumnDefn() {
        switch (this.docPropertyType) {
            case SHORT: 
            case INTEGER: 
            case LONG: {
                return "integer[]";
            }
            case DOUBLE: 
            case FLOAT: {
                return "decimal[]";
            }
        }
        return "varchar[]";
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public boolean isDirty(Object value) {
        return CheckMarkedDirty.isDirty(value);
    }

    public Object toJdbcType(Object value) {
        return value;
    }

    public T toBeanType(Object value) {
        return (T)value;
    }

    public DocPropertyType getDocType() {
        return this.docPropertyType;
    }

    public boolean isDateTimeCapable() {
        return false;
    }

    public T convertFromMillis(long dateTime) {
        return null;
    }

    public T readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return (T)this.parse(dataInput.readUTF());
    }

    public void writeData(DataOutput dataOutput, T value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            ScalarHelp.writeUTF(dataOutput, this.format(value));
        }
    }
}

