/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.Version;
import io.ebean.bean.EntityBean;
import io.ebean.core.type.ScalarType;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.TableJoin;
import io.ebeaninternal.server.query.STreePropertyAssoc;
import io.ebeaninternal.server.query.STreePropertyAssocMany;
import io.ebeaninternal.server.query.STreePropertyAssocOne;
import io.ebeaninternal.server.query.STreeType;
import io.ebeaninternal.server.query.SqlJoinType;
import io.ebeaninternal.server.query.SqlTreeNode;
import java.util.List;
import java.util.Set;

class SqlTreeNodeManyWhereJoin
implements SqlTreeNode {
    private final String parentPrefix;
    private final String prefix;
    private final STreePropertyAssoc nodeBeanProp;
    private final STreeType target;
    private final SqlJoinType manyJoinType;
    private final boolean softDelete;

    SqlTreeNodeManyWhereJoin(String prefix, STreePropertyAssoc prop, SqlJoinType manyJoinType, SpiQuery.TemporalMode temporalMode) {
        this.nodeBeanProp = prop;
        this.prefix = prefix;
        this.manyJoinType = manyJoinType;
        this.target = this.nodeBeanProp.target();
        this.softDelete = temporalMode != SpiQuery.TemporalMode.SOFT_DELETED && this.target.isSoftDelete();
        String[] split = SplitName.split((String)prefix);
        this.parentPrefix = split[0];
    }

    @Override
    public boolean isSingleProperty() {
        return false;
    }

    public ScalarType<?> getSingleAttributeReader() {
        throw new IllegalStateException("No expected");
    }

    @Override
    public void addAsOfTableAlias(SpiQuery<?> query) {
    }

    @Override
    public void addSoftDeletePredicate(SpiQuery<?> query) {
    }

    @Override
    public boolean isAggregation() {
        return false;
    }

    @Override
    public void appendDistinctOn(DbSqlContext ctx, boolean subQuery) {
    }

    @Override
    public void appendGroupBy(DbSqlContext ctx, boolean subQuery) {
    }

    @Override
    public void appendFrom(DbSqlContext ctx, SqlJoinType currentJoinType) {
        this.appendFromBaseTable(ctx, this.manyJoinType);
    }

    private void appendFromBaseTable(DbSqlContext ctx, SqlJoinType joinType) {
        String alias = ctx.getTableAliasManyWhere(this.prefix);
        String parentAlias = ctx.getTableAliasManyWhere(this.parentPrefix);
        if (this.nodeBeanProp instanceof STreePropertyAssocOne) {
            this.nodeBeanProp.addJoin(joinType, parentAlias, alias, ctx);
            if (this.softDelete) {
                ctx.append(" and ").append(this.target.getSoftDeletePredicate(alias));
            }
        } else {
            STreePropertyAssocMany manyProp = (STreePropertyAssocMany)this.nodeBeanProp;
            if (!manyProp.hasJoinTable()) {
                manyProp.addJoin(joinType, parentAlias, alias, ctx);
                if (this.softDelete) {
                    ctx.append(" and ").append(this.target.getSoftDeletePredicate(alias));
                }
            } else {
                String alias2 = alias + "z_";
                TableJoin manyToManyJoin = manyProp.getIntersectionTableJoin();
                manyToManyJoin.addJoin(joinType, parentAlias, alias2, ctx);
                manyProp.addJoin(joinType, alias2, alias, ctx);
            }
        }
    }

    @Override
    public void dependentTables(Set<String> tables) {
        tables.add(this.nodeBeanProp.target().getBaseTable(SpiQuery.TemporalMode.CURRENT));
    }

    @Override
    public void buildRawSqlSelectChain(List<String> selectChain) {
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
    }

    @Override
    public void appendWhere(DbSqlContext ctx) {
    }

    @Override
    public EntityBean load(DbReadContext ctx, EntityBean localBean, EntityBean parentBean) {
        return null;
    }

    @Override
    public <T> Version<T> loadVersion(DbReadContext ctx) {
        return null;
    }

    @Override
    public boolean hasMany() {
        return true;
    }
}

