/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeLocalTime;
import java.sql.SQLException;
import java.time.LocalTime;

public class ScalarTypeLocalTimeWithNanos
extends ScalarTypeLocalTime {
    public ScalarTypeLocalTimeWithNanos() {
        super(-5);
    }

    @Override
    public void bind(DataBinder binder, LocalTime value) throws SQLException {
        if (value == null) {
            binder.setNull(-5);
        } else {
            binder.setLong(value.toNanoOfDay());
        }
    }

    @Override
    public LocalTime read(DataReader reader) throws SQLException {
        Long value = reader.getLong();
        return value == null ? null : LocalTime.ofNanoOfDay(value);
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof Long) {
            return value;
        }
        return ((LocalTime)value).toNanoOfDay();
    }

    @Override
    public LocalTime toBeanType(Object value) {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value == null) {
            return null;
        }
        return LocalTime.ofNanoOfDay(BasicTypeConverter.toLong(value));
    }
}

