/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.BackgroundExecutor;
import io.ebean.ProfileLocation;
import io.ebean.TxScope;
import io.ebean.annotation.PersistBatch;
import io.ebean.annotation.TxType;
import io.ebean.cache.ServerCacheNotification;
import io.ebean.cache.ServerCacheNotify;
import io.ebean.config.CurrentTenantProvider;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.event.changelog.ChangeLogListener;
import io.ebean.event.changelog.ChangeLogPrepare;
import io.ebean.event.changelog.ChangeSet;
import io.ebean.meta.MetricVisitor;
import io.ebean.metric.MetricFactory;
import io.ebean.metric.TimedMetric;
import io.ebean.metric.TimedMetricMap;
import io.ebeaninternal.api.ScopeTrans;
import io.ebeaninternal.api.ScopedTransaction;
import io.ebeaninternal.api.SpiLogManager;
import io.ebeaninternal.api.SpiLogger;
import io.ebeaninternal.api.SpiProfileHandler;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.SpiTransactionManager;
import io.ebeaninternal.api.TransactionEvent;
import io.ebeaninternal.api.TransactionEventTable;
import io.ebeaninternal.server.cache.CacheChangeSet;
import io.ebeaninternal.server.cluster.ClusterManager;
import io.ebeaninternal.server.deploy.BeanDescriptorManager;
import io.ebeaninternal.server.profile.TimedProfileLocation;
import io.ebeaninternal.server.profile.TimedProfileLocationRegistry;
import io.ebeaninternal.server.transaction.BeanPersistIds;
import io.ebeaninternal.server.transaction.BulkEventListenerMap;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import io.ebeaninternal.server.transaction.ExternalJdbcTransaction;
import io.ebeaninternal.server.transaction.JdbcTransaction;
import io.ebeaninternal.server.transaction.NoTransaction;
import io.ebeaninternal.server.transaction.PostCommitProcessing;
import io.ebeaninternal.server.transaction.RemoteTableMod;
import io.ebeaninternal.server.transaction.RemoteTransactionEvent;
import io.ebeaninternal.server.transaction.SavepointTransaction;
import io.ebeaninternal.server.transaction.TableModState;
import io.ebeaninternal.server.transaction.TransactionFactory;
import io.ebeaninternal.server.transaction.TransactionFactoryBuilder;
import io.ebeaninternal.server.transaction.TransactionManagerOptions;
import io.ebeaninternal.server.transaction.TransactionProfile;
import io.ebeaninternal.server.transaction.TransactionScopeManager;
import io.ebeanservice.docstore.api.DocStoreTransaction;
import io.ebeanservice.docstore.api.DocStoreUpdateProcessor;
import io.ebeanservice.docstore.api.DocStoreUpdates;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager
implements SpiTransactionManager {
    private static final Logger logger = LoggerFactory.getLogger(TransactionManager.class);
    private static final Logger clusterLogger = LoggerFactory.getLogger((String)"io.ebean.Cluster");
    private final BeanDescriptorManager beanDescriptorManager;
    private final boolean rollbackOnChecked;
    final String prefix;
    private final String externalTransPrefix;
    private final AtomicLong counter = new AtomicLong(1000L);
    private final DataSourceSupplier dataSourceSupplier;
    private final DatabasePlatform.OnQueryOnly onQueryOnly;
    private final BackgroundExecutor backgroundExecutor;
    private final ClusterManager clusterManager;
    private final String serverName;
    private final boolean docStoreActive;
    final DocStoreUpdateProcessor docStoreUpdateProcessor;
    private final boolean persistBatch;
    private final boolean persistBatchOnCascade;
    private final BulkEventListenerMap bulkEventListenerMap;
    private final ChangeLogPrepare changeLogPrepare;
    private final ChangeLogListener changeLogListener;
    private final boolean changeLogAsync;
    final boolean notifyL2CacheInForeground;
    private final boolean viewInvalidation;
    private final boolean skipCacheAfterWrite;
    private final TransactionFactory transactionFactory;
    private final SpiLogManager logManager;
    private final SpiLogger txnLogger;
    private final boolean txnDebug;
    private final DatabasePlatform databasePlatform;
    private final SpiProfileHandler profileHandler;
    private final TimedMetric txnMain;
    private final TimedMetric txnReadOnly;
    private final TimedMetricMap txnNamed;
    private final TransactionScopeManager scopeManager;
    private final TableModState tableModState;
    private final ServerCacheNotify cacheNotify;
    private final boolean supportsSavepointId;
    private final ConcurrentHashMap<String, ProfileLocation> profileLocations = new ConcurrentHashMap();

    public TransactionManager(TransactionManagerOptions options) {
        this.logManager = options.logManager;
        this.txnLogger = this.logManager.txn();
        this.txnDebug = this.txnLogger.isDebug();
        this.databasePlatform = options.config.getDatabasePlatform();
        this.supportsSavepointId = this.databasePlatform.isSupportsSavepointId();
        this.skipCacheAfterWrite = options.config.isSkipCacheAfterWrite();
        this.notifyL2CacheInForeground = options.notifyL2CacheInForeground;
        this.persistBatch = PersistBatch.ALL == options.config.getPersistBatch();
        this.persistBatchOnCascade = PersistBatch.ALL == options.config.appliedPersistBatchOnCascade();
        this.rollbackOnChecked = options.config.isTransactionRollbackOnChecked();
        this.beanDescriptorManager = options.descMgr;
        this.viewInvalidation = options.descMgr.requiresViewEntityCacheInvalidation();
        this.changeLogPrepare = options.descMgr.getChangeLogPrepare();
        this.changeLogListener = options.descMgr.getChangeLogListener();
        this.changeLogAsync = options.config.isChangeLogAsync();
        this.clusterManager = options.clusterManager;
        this.serverName = options.config.getName();
        this.scopeManager = options.scopeManager;
        this.tableModState = options.tableModState;
        this.cacheNotify = options.cacheNotify;
        this.backgroundExecutor = options.backgroundExecutor;
        this.dataSourceSupplier = options.dataSourceSupplier;
        this.docStoreActive = options.config.getDocStoreConfig().isActive();
        this.docStoreUpdateProcessor = options.docStoreUpdateProcessor;
        this.profileHandler = options.profileHandler;
        this.bulkEventListenerMap = new BulkEventListenerMap(options.config.getBulkTableEventListeners());
        this.prefix = "";
        this.externalTransPrefix = "e";
        this.onQueryOnly = this.initOnQueryOnly(options.config.getDatabasePlatform().getOnQueryOnly());
        CurrentTenantProvider tenantProvider = options.config.getCurrentTenantProvider();
        this.transactionFactory = TransactionFactoryBuilder.build(this, this.dataSourceSupplier, tenantProvider);
        MetricFactory metricFactory = MetricFactory.get();
        this.txnMain = metricFactory.createTimedMetric("txn.main");
        this.txnReadOnly = metricFactory.createTimedMetric("txn.readonly");
        this.txnNamed = metricFactory.createTimedMetricMap("txn.named.");
        this.scopeManager.register(this);
    }

    private ScopedTransaction createScopedTransaction() {
        return new ScopedTransaction(this.scopeManager);
    }

    @Override
    public TransactionScopeManager scope() {
        return this.scopeManager;
    }

    public void set(SpiTransaction txn) {
        this.scopeManager.set(txn);
    }

    @Override
    public SpiTransaction getActive() {
        return this.scopeManager.getActive();
    }

    private ScopedTransaction getActiveScoped() {
        return (ScopedTransaction)this.scopeManager.getActive();
    }

    public SpiTransaction getInScope() {
        return this.scopeManager.getInScope();
    }

    public PersistenceException translate(String message, SQLException cause) {
        return this.databasePlatform.translate(message, cause);
    }

    public void shutdown(boolean shutdownDataSource, boolean deregisterDriver) {
        if (shutdownDataSource) {
            this.dataSourceSupplier.shutdown(deregisterDriver);
        }
    }

    boolean isSupportsSavepointId() {
        return this.supportsSavepointId;
    }

    boolean isDocStoreActive() {
        return this.docStoreActive;
    }

    DocStoreTransaction createDocStoreTransaction(int docStoreBatchSize) {
        return this.docStoreUpdateProcessor.createTransaction(docStoreBatchSize);
    }

    boolean isSkipCacheAfterWrite() {
        return this.skipCacheAfterWrite;
    }

    public BeanDescriptorManager getBeanDescriptorManager() {
        return this.beanDescriptorManager;
    }

    BulkEventListenerMap getBulkEventListenerMap() {
        return this.bulkEventListenerMap;
    }

    boolean getPersistBatch() {
        return this.persistBatch;
    }

    public boolean getPersistBatchOnCascade() {
        return this.persistBatchOnCascade;
    }

    DatabasePlatform.OnQueryOnly initOnQueryOnly(DatabasePlatform.OnQueryOnly dbPlatformOnQueryOnly) {
        String systemPropertyValue = System.getProperty("ebean.transaction.onqueryonly");
        if (systemPropertyValue != null) {
            return DatabasePlatform.OnQueryOnly.valueOf((String)systemPropertyValue.trim().toUpperCase());
        }
        return dbPlatformOnQueryOnly == null ? DatabasePlatform.OnQueryOnly.COMMIT : dbPlatformOnQueryOnly;
    }

    public String getServerName() {
        return this.serverName;
    }

    @Override
    public Connection getQueryPlanConnection() throws SQLException {
        return this.dataSourceSupplier.getConnection(null);
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSourceSupplier.getDataSource();
    }

    @Override
    public DataSource getReadOnlyDataSource() {
        return this.dataSourceSupplier.getReadOnlyDataSource();
    }

    DatabasePlatform.OnQueryOnly getOnQueryOnly() {
        return this.onQueryOnly;
    }

    public SpiTransaction wrapExternalConnection(Connection c) {
        return this.wrapExternalConnection(this.externalTransPrefix + c.hashCode(), c);
    }

    private SpiTransaction wrapExternalConnection(String id, Connection c) {
        ExternalJdbcTransaction t = new ExternalJdbcTransaction(id, true, c, this);
        t.setBatchMode(this.persistBatch);
        t.setBatchOnCascade(this.persistBatchOnCascade);
        return t;
    }

    private SpiTransaction createTransaction(TxScope txScope) {
        if (txScope.isReadonly()) {
            return this.createReadOnlyTransaction(null);
        }
        return this.createTransaction(true, txScope.getIsolationLevel());
    }

    public SpiTransaction createTransaction(boolean explicit, int isolationLevel) {
        return this.transactionFactory.createTransaction(explicit, isolationLevel);
    }

    public SpiTransaction createReadOnlyTransaction(Object tenantId) {
        return this.transactionFactory.createReadOnlyTransaction(tenantId);
    }

    SpiTransaction createTransaction(boolean explicit, Connection c) {
        return new JdbcTransaction(this.nextTxnId(), explicit, c, this);
    }

    String nextTxnId() {
        return this.txnDebug ? this.prefix + this.counter.incrementAndGet() : this.prefix;
    }

    @Override
    public void notifyOfRollback(SpiTransaction transaction, Throwable cause) {
        try {
            if (this.txnLogger.isDebug()) {
                String msg = transaction.getLogPrefix() + "Rollback";
                if (cause != null) {
                    msg = msg + " error: " + this.formatThrowable(cause);
                }
                this.txnLogger.debug(msg);
            }
        }
        catch (Exception ex) {
            logger.error("Error while notifying TransactionEventListener of rollback event", (Throwable)ex);
        }
    }

    @Override
    public void notifyOfQueryOnly(SpiTransaction transaction) {
        if (this.txnLogger.isTrace()) {
            this.txnLogger.trace(transaction.getLogPrefix() + "Commit - query only");
        }
    }

    private String formatThrowable(Throwable e) {
        if (e == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        this.formatThrowable(e, sb);
        return sb.toString();
    }

    private void formatThrowable(Throwable e, StringBuilder sb) {
        Throwable cause;
        sb.append(e.toString());
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace.length > 0) {
            sb.append(" stack0: ");
            sb.append(stackTrace[0]);
        }
        if ((cause = e.getCause()) != null) {
            sb.append(" cause: ");
            this.formatThrowable(cause, sb);
        }
    }

    @Override
    public void notifyOfCommit(SpiTransaction transaction) {
        try {
            if (this.txnLogger.isDebug()) {
                this.txnLogger.debug(transaction.getLogPrefix() + "Commit");
            }
            PostCommitProcessing postCommit = new PostCommitProcessing(this.clusterManager, this, transaction);
            postCommit.notifyLocalCache();
            this.backgroundExecutor.execute(postCommit.backgroundNotify());
        }
        catch (Exception ex) {
            logger.error("NotifyOfCommit failed. L2 Cache potentially not notified.", (Throwable)ex);
        }
    }

    public void externalModification(TransactionEventTable tableEvent) {
        SpiTransaction t = this.getActive();
        if (t != null) {
            t.getEvent().add(tableEvent);
        } else {
            this.externalModificationEvent(tableEvent);
        }
    }

    private void externalModificationEvent(TransactionEventTable tableEvents) {
        TransactionEvent event = new TransactionEvent();
        event.add(tableEvents);
        PostCommitProcessing postCommit = new PostCommitProcessing(this.clusterManager, this, event);
        postCommit.notifyLocalCache();
        this.backgroundExecutor.execute(postCommit.backgroundNotify());
    }

    public void remoteTransactionEvent(RemoteTransactionEvent remoteEvent) {
        List<BeanPersistIds> beanPersistList;
        List<TransactionEventTable.TableIUD> tableIUDList;
        if (clusterLogger.isDebugEnabled()) {
            clusterLogger.debug("processing {}", (Object)remoteEvent);
        }
        CacheChangeSet changeSet = new CacheChangeSet();
        RemoteTableMod tableMod = remoteEvent.getRemoteTableMod();
        if (tableMod != null) {
            changeSet.addInvalidate(tableMod.getTables());
        }
        if ((tableIUDList = remoteEvent.getTableIUDList()) != null) {
            for (TransactionEventTable.TableIUD tableIUD : tableIUDList) {
                this.beanDescriptorManager.cacheNotify(tableIUD, changeSet);
            }
        }
        if ((beanPersistList = remoteEvent.getBeanPersistList()) != null) {
            for (BeanPersistIds persistIds : beanPersistList) {
                persistIds.notifyCache(changeSet);
            }
        }
        changeSet.apply();
    }

    void processDocStoreUpdates(DocStoreUpdates docStoreUpdates, int bulkBatchSize) {
        this.docStoreUpdateProcessor.process(docStoreUpdates, bulkBatchSize);
    }

    void sendChangeLog(ChangeSet changeSet) {
        if (this.changeLogPrepare.prepare(changeSet)) {
            if (this.changeLogAsync) {
                this.backgroundExecutor.execute(() -> this.changeLogListener.log(changeSet));
            } else {
                this.changeLogListener.log(changeSet);
            }
        }
    }

    void processTouchedTables(Set<String> touchedTables) {
        this.tableModState.touch(touchedTables);
        if (this.viewInvalidation) {
            this.beanDescriptorManager.processViewInvalidation(touchedTables);
        }
        this.cacheNotify.notify(new ServerCacheNotification(touchedTables));
    }

    void profileCollect(TransactionProfile transactionProfile) {
        this.profileHandler.collectTransactionProfile(transactionProfile);
    }

    void collectMetric(long exeMicros) {
        this.txnMain.add(exeMicros);
    }

    void collectMetricReadOnly(long exeMicros) {
        this.txnReadOnly.add(exeMicros);
    }

    void collectMetricNamed(long exeMicros, String label) {
        this.txnNamed.add(label, exeMicros);
    }

    public void visitMetrics(MetricVisitor visitor) {
        this.txnMain.visit(visitor);
        this.txnReadOnly.visit(visitor);
        this.txnNamed.visit(visitor);
        for (TimedProfileLocation timedLocation : TimedProfileLocationRegistry.registered()) {
            timedLocation.visit(visitor);
        }
    }

    public void clearServerTransaction() {
        this.scopeManager.clear();
    }

    public SpiTransaction beginServerTransaction() {
        SpiTransaction t = this.createTransaction(false, -1);
        this.scopeManager.set(t);
        return t;
    }

    public void exitScopedTransaction(Object returnOrThrowable, int opCode) {
        SpiTransaction st = this.getInScope();
        if (st instanceof ScopedTransaction) {
            ((ScopedTransaction)st).complete(returnOrThrowable, opCode);
        }
    }

    @Override
    public void externalRemoveTransaction() {
        this.scopeManager.clearExternal();
    }

    @Override
    public ScopedTransaction externalBeginTransaction(SpiTransaction transaction, TxScope txScope) {
        ScopedTransaction scopedTxn = new ScopedTransaction(this.scopeManager);
        scopedTxn.push(new ScopeTrans(this.rollbackOnChecked, false, transaction, txScope));
        this.scopeManager.replace(scopedTxn);
        return scopedTxn;
    }

    public ScopedTransaction beginScopedTransaction(TxScope txScope) {
        boolean createTransaction;
        boolean nestedSavepoint;
        SpiTransaction transaction;
        boolean setToScope;
        txScope = this.initTxScope(txScope);
        ScopedTransaction txnContainer = this.getActiveScoped();
        if (txnContainer == null) {
            txnContainer = this.createScopedTransaction();
            setToScope = true;
            transaction = null;
            nestedSavepoint = false;
        } else {
            setToScope = false;
            transaction = txnContainer.current();
            nestedSavepoint = transaction.isNestedUseSavepoint();
        }
        TxType type = txScope.getType();
        if (nestedSavepoint && (type == TxType.REQUIRED || type == TxType.REQUIRES_NEW)) {
            createTransaction = true;
            transaction = this.createSavepoint(transaction, this);
        } else {
            createTransaction = this.isCreateNewTransaction(transaction, type);
            if (createTransaction) {
                switch (type) {
                    case SUPPORTS: 
                    case NOT_SUPPORTED: 
                    case NEVER: {
                        transaction = NoTransaction.INSTANCE;
                        break;
                    }
                    default: {
                        transaction = this.createTransaction(txScope);
                        this.initNewTransaction(transaction, txScope);
                    }
                }
            }
        }
        txnContainer.push(new ScopeTrans(this.rollbackOnChecked, createTransaction, transaction, txScope));
        if (setToScope) {
            this.set(txnContainer);
        }
        return txnContainer;
    }

    private SpiTransaction createSavepoint(SpiTransaction transaction, TransactionManager manager) {
        try {
            return new SavepointTransaction(transaction, manager);
        }
        catch (SQLException e) {
            throw new PersistenceException("Error creating nested Savepoint Transaction", (Throwable)e);
        }
    }

    private void initNewTransaction(SpiTransaction transaction, TxScope txScope) {
        ProfileLocation profileLocation;
        String label;
        if (txScope.isSkipCache()) {
            transaction.setSkipCache(true);
        }
        if ((label = txScope.getLabel()) != null) {
            transaction.setLabel(label);
        }
        if ((profileLocation = txScope.getProfileLocation()) != null) {
            if (profileLocation.obtain()) {
                this.registerProfileLocation(profileLocation);
            }
            transaction.setProfileLocation(profileLocation);
            if (profileLocation.trace()) {
                transaction.setProfileStream(this.profileHandler.createProfileStream(profileLocation));
            }
        }
    }

    private void registerProfileLocation(ProfileLocation profileLocation) {
        this.profileLocations.put(profileLocation.fullLocation(), profileLocation);
    }

    private TxScope initTxScope(TxScope txScope) {
        if (txScope == null) {
            return new TxScope();
        }
        txScope.checkBatchMode();
        return txScope;
    }

    private boolean isCreateNewTransaction(SpiTransaction current, TxType type) {
        switch (type) {
            case SUPPORTS: 
            case REQUIRED: {
                return current == null;
            }
            case REQUIRES_NEW: {
                return true;
            }
            case MANDATORY: {
                if (current == null) {
                    throw new PersistenceException("Transaction missing when MANDATORY");
                }
                return false;
            }
            case NEVER: {
                if (current != null) {
                    throw new PersistenceException("Transaction exists for Transactional NEVER");
                }
                return true;
            }
            case NOT_SUPPORTED: {
                return true;
            }
        }
        throw new RuntimeException("Should never get here?");
    }

    public boolean isTxnDebug() {
        return this.txnDebug;
    }

    public SpiLogManager log() {
        return this.logManager;
    }

    public boolean isLogSql() {
        return this.logManager.sql().isDebug();
    }

    public boolean isLogSummary() {
        return this.logManager.sum().isDebug();
    }
}

