/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.el;

import io.ebean.bean.EntityBean;
import io.ebean.core.type.ScalarType;
import io.ebean.plugin.Property;
import io.ebean.text.StringParser;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.el.ElPropertyValue;
import java.util.Arrays;

public class ElPropertyChain
implements ElPropertyValue {
    private final String prefix;
    private final String placeHolder;
    private final String placeHolderEncrypted;
    private final String name;
    private final String expression;
    private final boolean containsMany;
    private final ElPropertyValue[] chain;
    private final boolean assocId;
    private final int last;
    private final BeanProperty lastBeanProperty;
    private final ScalarType<?> scalarType;
    private final ElPropertyValue lastElPropertyValue;

    public ElPropertyChain(boolean containsMany, boolean embedded, String expression, ElPropertyValue[] chain) {
        this.containsMany = containsMany;
        this.chain = chain;
        this.expression = expression;
        int dotPos = expression.lastIndexOf(46);
        if (dotPos > -1) {
            int embPos;
            this.name = expression.substring(dotPos + 1);
            this.prefix = embedded ? ((embPos = expression.lastIndexOf(46, dotPos - 1)) == -1 ? null : expression.substring(0, embPos)) : expression.substring(0, dotPos);
        } else {
            this.prefix = null;
            this.name = expression;
        }
        this.assocId = chain[chain.length - 1].isAssocId();
        this.last = chain.length - 1;
        this.lastBeanProperty = chain[chain.length - 1].getBeanProperty();
        this.scalarType = this.lastBeanProperty != null ? this.lastBeanProperty.getScalarType() : null;
        this.lastElPropertyValue = chain[chain.length - 1];
        this.placeHolder = this.getElPlaceHolder(this.prefix, this.lastElPropertyValue, false);
        this.placeHolderEncrypted = this.getElPlaceHolder(this.prefix, this.lastElPropertyValue, true);
    }

    public String toString() {
        return "expr:" + this.expression + " chain:" + Arrays.toString(this.chain);
    }

    @Override
    public int getFetchPreference() {
        return this.chain[0].getFetchPreference();
    }

    @Override
    public boolean isAggregation() {
        return false;
    }

    private String getElPlaceHolder(String prefix, ElPropertyValue lastElPropertyValue, boolean encrypted) {
        if (prefix == null) {
            return lastElPropertyValue.getElPlaceholder(encrypted);
        }
        String el = lastElPropertyValue.getElPlaceholder(encrypted);
        if (!el.contains("${}")) {
            return el.replace("${", "${" + prefix + ".");
        }
        return el.replace("${}", "${" + prefix + "}");
    }

    @Override
    public boolean containsManySince(String sinceProperty) {
        if (sinceProperty == null) {
            return this.containsMany;
        }
        if (!this.expression.startsWith(sinceProperty)) {
            return this.containsMany;
        }
        for (int i = 1 + SplitName.count((String)sinceProperty); i < this.chain.length; ++i) {
            if (!this.chain[i].getBeanProperty().containsMany()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsFormulaWithJoin() {
        return this.lastBeanProperty.containsFormulaWithJoin();
    }

    @Override
    public boolean containsMany() {
        return this.containsMany;
    }

    @Override
    public String getElPrefix() {
        return this.prefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getElName() {
        return this.expression;
    }

    @Override
    public String getElPlaceholder(boolean encrypted) {
        return encrypted ? this.placeHolderEncrypted : this.placeHolder;
    }

    @Override
    public boolean isDbEncrypted() {
        return this.lastElPropertyValue.isDbEncrypted();
    }

    @Override
    public boolean isLocalEncrypted() {
        return this.lastElPropertyValue.isLocalEncrypted();
    }

    @Override
    public Object localEncrypt(Object value) {
        return this.lastElPropertyValue.localEncrypt(value);
    }

    @Override
    public String getAssocIsEmpty(SpiExpressionRequest request, String path) {
        return this.lastElPropertyValue.getAssocIsEmpty(request, path);
    }

    public Object[] getAssocIdValues(EntityBean bean) {
        return this.lastElPropertyValue.getAssocIdValues(bean);
    }

    public String getAssocIdExpression(String prefix, String operator) {
        return this.lastElPropertyValue.getAssocIdExpression(this.expression, operator);
    }

    @Override
    public String getAssocIdInExpr(String prefix) {
        return this.lastElPropertyValue.getAssocIdInExpr(prefix);
    }

    @Override
    public String getAssocIdInValueExpr(boolean not, int size) {
        return this.lastElPropertyValue.getAssocIdInValueExpr(not, size);
    }

    @Override
    public boolean isAssocMany() {
        return this.lastElPropertyValue.isAssocMany();
    }

    public Property getProperty() {
        return this.lastBeanProperty;
    }

    @Override
    public boolean isAssocId() {
        return this.assocId;
    }

    @Override
    public boolean isAssocProperty() {
        for (ElPropertyValue aChain : this.chain) {
            if (!aChain.isAssocProperty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDbColumn() {
        return this.lastElPropertyValue.getDbColumn();
    }

    @Override
    public BeanProperty getBeanProperty() {
        return this.lastBeanProperty;
    }

    public boolean isDateTimeCapable() {
        return this.scalarType != null && this.scalarType.isDateTimeCapable();
    }

    public int getJdbcType() {
        return this.scalarType == null ? 0 : this.scalarType.getJdbcType();
    }

    public Object parseDateTime(long systemTimeMillis) {
        return this.scalarType.convertFromMillis(systemTimeMillis);
    }

    public StringParser getStringParser() {
        return this.scalarType;
    }

    public Object convert(Object value) {
        return this.lastElPropertyValue.convert(value);
    }

    public Object pathGet(Object bean) {
        for (ElPropertyValue aChain : this.chain) {
            if (aChain.isAssocMany()) {
                throw new UnsupportedOperationException("pathGet not supported on [" + this.expression + "], because " + aChain + " is an assocMany property");
            }
            if ((bean = aChain.pathGet(bean)) != null) continue;
            return null;
        }
        return bean;
    }

    @Override
    public Object pathGetNested(Object bean) {
        Object prevBean = bean;
        for (int i = 0; i < this.last; ++i) {
            prevBean = this.chain[i].pathGetNested(prevBean);
        }
        return this.chain[this.last].pathGet(prevBean);
    }

    public void pathSet(Object bean, Object value) {
        Object prevBean = bean;
        for (int i = 0; i < this.last; ++i) {
            prevBean = this.chain[i].pathGetNested(prevBean);
        }
        if (prevBean != null) {
            if (this.lastBeanProperty != null) {
                this.lastBeanProperty.pathSet(prevBean, value);
            } else {
                this.lastElPropertyValue.pathSet(prevBean, value);
            }
        }
    }
}

